/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.slottype.LegacySlotManager;

public class SlotBoostingItems
extends Item {
    private static final String[] AVAILABLE_SLOTS = new String[]{"charm", "necklace", "ring", "bands"};
    private static final String SELECTED_SLOT_KEY = "SelectedSlotIndex";

    public SlotBoostingItems(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_142312_(@NotNull CompoundTag tag) {
        super.m_142312_(tag);
        if (!tag.m_128441_(SELECTED_SLOT_KEY)) {
            tag.m_128405_(SELECTED_SLOT_KEY, 0);
        }
    }

    private CompoundTag getOrInitTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            tag.m_128405_(SELECTED_SLOT_KEY, 0);
            stack.m_41751_(tag);
        }
        return tag;
    }

    private int getSelectedIndex(ItemStack stack) {
        return this.getOrInitTag(stack).m_128451_(SELECTED_SLOT_KEY);
    }

    private void cycleSelectedIndex(ItemStack stack) {
        CompoundTag tag = this.getOrInitTag(stack);
        int next = (tag.m_128451_(SELECTED_SLOT_KEY) + 1) % AVAILABLE_SLOTS.length;
        tag = new CompoundTag();
        tag.m_128405_(SELECTED_SLOT_KEY, next);
        stack.m_41751_(tag);
    }

    private String getSelectedSlot(ItemStack stack) {
        int validIndex = this.getSelectedIndex(stack) % AVAILABLE_SLOTS.length;
        return AVAILABLE_SLOTS[validIndex];
    }

    private boolean isSlotValid(String slot) {
        return LegacySlotManager.getIdsToMods().containsKey(slot) || CuriosSlotManager.SERVER.getModsFromSlots().containsKey(slot) || CuriosEntityManager.SERVER.getModsFromSlots().containsKey(slot);
    }

    private int getCurrentSlots(Player player, String slot) {
        return CuriosApi.getSlotHelper().getSlotsForType((LivingEntity)player, slot);
    }

    private int getRequiredXp(Player player, String slot) {
        return this.getCurrentSlots(player, slot) * 2000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        String selectedSlot = this.getSelectedSlot(stack);
        if (!player.m_6144_()) {
            this.cycleSelectedIndex(stack);
            if (level.f_46443_) {
                String newSlot = this.getSelectedSlot(stack);
                int slotCount = this.getCurrentSlots(player, newSlot);
                player.m_5661_((Component)Component.m_237110_((String)"item.slot_boost.switch_hint", (Object[])new Object[]{newSlot, slotCount, this.getRequiredXp(player, newSlot)}).m_130938_(style -> style.m_178520_(65535)), true);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (player.m_6144_()) {
            if (!this.isSlotValid(selectedSlot) && level.f_46443_) {
                player.m_213846_((Component)Component.m_237110_((String)"item.slot_boost.invalid_slot", (Object[])new Object[]{selectedSlot}));
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            int requiredXp = this.getRequiredXp(player, selectedSlot);
            if (player.f_36079_ < requiredXp) {
                player.m_5661_((Component)Component.m_237110_((String)"item.slot_boost.xp_shortage", (Object[])new Object[]{requiredXp, player.f_36079_}), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6756_(-requiredXp);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CuriosApi.getSlotHelper().growSlotType(selectedSlot, 1, (LivingEntity)serverPlayer);
            }
            player.m_5661_((Component)Component.m_237110_((String)"item.slot_boost.success", (Object[])new Object[]{selectedSlot, this.getCurrentSlots(player, selectedSlot)}), true);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        String slot = this.getSelectedSlot(stack);
        return Component.m_237110_((String)"item.slot_boost.name", (Object[])new Object[]{slot});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.slot_boost.tooltip1").m_130938_(style -> style.m_178520_(0xAAAAAA)));
        tooltip.add((Component)Component.m_237115_((String)"item.slot_boost.tooltip2").m_130938_(style -> style.m_178520_(0xAAAAAA)));
        tooltip.add((Component)Component.m_237110_((String)"item.slot_boost.tooltip3", (Object[])new Object[]{this.getSelectedSlot(stack)}).m_130938_(style -> style.m_178520_(0xAAAAAA)));
    }
}

