/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.data.GTOBlocks;
import com.gtolib.GTOCore;
import com.gtolib.api.pattern.DebugBlockPattern;
import com.gtolib.utils.FileUtils;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.RegistriesUtils;
import com.gtolib.utils.StringIndex;
import com.gtolib.utils.StringUtils;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class StructureWriteBehavior
implements IItemUIFactory {
    public static final StructureWriteBehavior INSTANCE = new StructureWriteBehavior();
    private static Map<Block, BiConsumer<StringBuilder, Character>> BLOCK_MAP;

    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder playerInventoryHolder, Player entityPlayer) {
        WidgetGroup container = new WidgetGroup(8, 8, 160, 54);
        container.addWidget((Widget)new ImageWidget(4, 4, 152, 46, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(7, 7, () -> {
            BlockPos[] blockPos;
            int x = 0;
            int y = 0;
            int z = 0;
            if (StructureWriteBehavior.getPos(playerInventoryHolder.getHeld()) != null && (blockPos = StructureWriteBehavior.getPos(playerInventoryHolder.getHeld())) != null) {
                x = 1 + blockPos[1].m_123341_() - blockPos[0].m_123341_();
                y = 1 + blockPos[1].m_123342_() - blockPos[0].m_123342_();
                z = 1 + blockPos[1].m_123343_() - blockPos[0].m_123343_();
            }
            return LocalizationUtils.format((String)"structure_writer.structural_scale", (Object[])new Object[]{x, y, z});
        }).setTextColor(16447990)).addWidget((Widget)new LabelWidget(7, 20, () -> {
            Direction direction = StructureWriteBehavior.getDir(playerInventoryHolder.getHeld());
            RelativeDirection[] dirs = DebugBlockPattern.getDir((Direction)direction);
            return LocalizationUtils.format((String)"structure_writer.export_order", (Object[])new Object[]{dirs[0].name(), dirs[1].name(), dirs[2].name()});
        }).setTextColor(16447990));
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return new ModularUI(176, 120, (IUIHolder)playerInventoryHolder, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)container).widget((Widget)new ButtonWidget(9, 91, 77, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(playerInventoryHolder.getHeld().m_41784_().m_128471_("export") ? "\u5bfc\u51fa\u6a21\u5f0f" : "\u7ed1\u5b9a\u6a21\u5f0f")}), clickData -> StructureWriteBehavior.switchMode(playerInventoryHolder))).widget((Widget)new ButtonWidget(90, 91, 77, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("\u5bfc\u51fa\u4e3a\u65e5\u5fd7")}), clickData -> StructureWriteBehavior.exportLog(playerInventoryHolder))).widget((Widget)new ButtonWidget(9, 68, 77, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("\u6cbfX\u8f74\u65cb\u8f6c")}), clickData -> StructureWriteBehavior.changeDirX(playerInventoryHolder))).widget((Widget)new ButtonWidget(90, 68, 77, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("\u6cbfY\u8f74\u65cb\u8f6c")}), clickData -> StructureWriteBehavior.changeDirY(playerInventoryHolder)));
    }

    private static void exportLog(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        Player player;
        if (StructureWriteBehavior.getPos(playerInventoryHolder.getHeld()) != null && (player = playerInventoryHolder.getPlayer()) instanceof ServerPlayer) {
            ItemStack itemStack;
            String part;
            ServerPlayer player2 = (ServerPlayer)player;
            if (BLOCK_MAP == null) {
                BLOCK_MAP = ImmutableMap.builder().put((Object)Blocks.f_49999_, (b2, c) -> b2.append("controller(definition))")).put((Object)Blocks.f_50493_, (b2, c) -> b2.append("heatingCoils())")).put((Object)Blocks.f_50041_, (b2, c) -> b2.append("air())")).put((Object)Blocks.f_50058_, (b2, c) -> b2.append("GTOPredicates.glass())")).put((Object)Blocks.f_50141_, (b2, c) -> b2.append("GTOPredicates.light())")).put((Object)((Block)GTOBlocks.ABS_WHITE_CASING.get()), (b2, c) -> b2.append("GTOPredicates.absBlocks())")).put((Object)Blocks.f_50094_, (b2, c) -> b2.append("abilities(MUFFLER))")).build();
            }
            if ((part = (itemStack = playerInventoryHolder.getHeld()).m_41784_().m_128461_("part")).isEmpty()) {
                player2.m_5661_((Component)Component.m_237113_((String)"\u672a\u7ed1\u5b9a\u4ed3\u5ba4\u65b9\u5757"), false);
                return;
            }
            BlockPos[] blockPos = StructureWriteBehavior.getPos(playerInventoryHolder.getHeld());
            Direction direction = StructureWriteBehavior.getDir(playerInventoryHolder.getHeld());
            StringBuilder builder = new StringBuilder();
            DebugBlockPattern blockPattern = new DebugBlockPattern(playerInventoryHolder.getPlayer().m_9236_(), blockPos[0].m_123341_(), blockPos[0].m_123342_(), blockPos[0].m_123343_(), blockPos[1].m_123341_(), blockPos[1].m_123342_(), blockPos[1].m_123343_());
            RelativeDirection[] dirs = DebugBlockPattern.getDir((Direction)direction);
            blockPattern.changeDir(dirs[0], dirs[1], dirs[2]);
            builder.append("\n.block(").append(StructureWriteBehavior.convertBlockToString(RegistriesUtils.getBlock((String)part), part, StringUtils.decompose((String)part), true)).append(")\n");
            builder.append(".pattern(definition -> MultiBlockFileReader.start(definition)\n");
            blockPattern.legend.forEach((b2, c) -> {
                if (c.equals(Character.valueOf(' '))) {
                    return;
                }
                if (BLOCK_MAP.containsKey(b2)) {
                    builder.append(".where('").append(c).append("', ");
                    BLOCK_MAP.get(b2).accept(builder, (Character)c);
                    builder.append("\n");
                    return;
                }
                if (b2 == Blocks.f_50652_) {
                    builder.append(".where('").append(c).append("', blocks(").append(StructureWriteBehavior.convertBlockToString(RegistriesUtils.getBlock((String)part), part, StringUtils.decompose((String)part), false)).append(")\n").append(itemStack.m_41784_().m_128471_("laser") ? ".or(GTOPredicates.autoLaserAbilities(definition.getRecipeTypes()))\n.or(abilities(MAINTENANCE).setExactLimit(1)))\n" : ".or(autoAbilities(definition.getRecipeTypes()))\n.or(abilities(MAINTENANCE).setExactLimit(1)))\n");
                    return;
                }
                String id = ItemUtils.getId((Block)b2);
                String[] parts = StringUtils.decompose((String)id);
                boolean isGT = Objects.equals(parts[0], "gtceu");
                boolean isGTO = Objects.equals(parts[0], "gtocore");
                if ((isGT || isGTO) && parts[1].contains("_frame")) {
                    builder.append(".where('").append(c).append("', blocks(ChemicalHelper.getBlock(TagPrefix.frameGt, ").append(isGT ? "GTMaterials." : "GTOMaterials.").append(FormattingUtil.lowerUnderscoreToUpperCamel((String)StringUtils.lastDecompose((char)'_', (String)parts[1])[0])).append(")))\n");
                    return;
                }
                builder.append(".where('").append(c).append("', blocks(").append(StructureWriteBehavior.convertBlockToString(b2, id, parts, false)).append("))\n");
            });
            if (blockPattern.hasAir) {
                builder.append(".where(' ', any())\n");
            }
            builder.append(".build())\n");
            FileUtils.saveToFile((Object)blockPattern.pattern, (File)new File(GTOCore.getFile(), "structure_pattern.mbs"), (FileUtils.Serialize)FileUtils.Serialize.array((FileUtils.Serialize)FileUtils.Serialize.array((FileUtils.Serialize)FileUtils.Serializer.STRING)));
            FileUtils.saveToFile((Object)builder.toString(), (File)new File(GTOCore.getFile(), "structure_pattern.txt"), (FileUtils.Serialize)FileUtils.Serializer.TXT_STRING);
            for (int i = 0; i < blockPattern.pattern.length; ++i) {
                Object[] strings = blockPattern.pattern[i];
                builder.append(".aisle(\"%s\")\n".formatted(Joiner.on((String)"\", \"").join(strings)));
            }
            GTOCore.LOGGER.info(builder.toString());
        }
    }

    private static String convertBlockToString(Block b2, String id, String[] parts, boolean supplier) {
        if (StringIndex.BLOCK_LINK_MAP.containsKey(b2)) {
            return (String)StringIndex.BLOCK_LINK_MAP.get(b2) + (supplier ? "" : ".get()");
        }
        if (Objects.equals(parts[0], "gtocore")) {
            return "Blocks." + parts[1].toUpperCase() + (supplier ? "" : ".get()");
        }
        if (Objects.equals(parts[0], "minecraft")) {
            return (supplier ? "() -> " : "") + "Blocks." + parts[1].toUpperCase();
        }
        return "RegistriesUtils.get" + (supplier ? "Supplier" : "") + "Block(\"" + id + "\")";
    }

    private static void switchMode(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        if (playerInventoryHolder.getPlayer() instanceof ServerPlayer) {
            ItemStack itemStack = playerInventoryHolder.getHeld();
            itemStack.m_41784_().m_128379_("export", !itemStack.m_41784_().m_128471_("export"));
        }
    }

    private static void changeDirX(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        if (StructureWriteBehavior.getPos(playerInventoryHolder.getHeld()) != null && playerInventoryHolder.getPlayer() instanceof ServerPlayer) {
            ItemStack itemStack = playerInventoryHolder.getHeld();
            Direction direction = StructureWriteBehavior.getDir(itemStack);
            direction = direction.m_175362_(Direction.Axis.X);
            StructureWriteBehavior.setDir(itemStack, direction);
        }
    }

    private static void changeDirY(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        if (StructureWriteBehavior.getPos(playerInventoryHolder.getHeld()) != null && playerInventoryHolder.getPlayer() instanceof ServerPlayer) {
            ItemStack itemStack = playerInventoryHolder.getHeld();
            Direction direction = StructureWriteBehavior.getDir(itemStack);
            direction = direction.m_175362_(Direction.Axis.Y);
            StructureWriteBehavior.setDir(itemStack, direction);
        }
    }

    public static boolean isItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof ComponentItem) {
            ComponentItem item2 = (ComponentItem)item;
            return item2.getComponents().contains(INSTANCE);
        }
        return false;
    }

    private static Direction getDir(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("structure_writer");
        if (!tag.m_128441_("dir")) {
            return Direction.WEST;
        }
        return Direction.m_122402_((String)tag.m_128461_("dir"));
    }

    private static void setDir(ItemStack stack, Direction dir) {
        CompoundTag tag = stack.m_41698_("structure_writer");
        tag.m_128359_("dir", dir.m_122433_());
    }

    public static BlockPos[] getPos(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("structure_writer");
        if (!tag.m_128441_("minX")) {
            return null;
        }
        return new BlockPos[]{new BlockPos(tag.m_128451_("minX"), tag.m_128451_("minY"), tag.m_128451_("minZ")), new BlockPos(tag.m_128451_("maxX"), tag.m_128451_("maxY"), tag.m_128451_("maxZ"))};
    }

    private static void addPos(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41698_("structure_writer");
        if (!tag.m_128441_("minX") || tag.m_128451_("minX") > pos.m_123341_()) {
            tag.m_128405_("minX", pos.m_123341_());
        }
        if (!tag.m_128441_("maxX") || tag.m_128451_("maxX") < pos.m_123341_()) {
            tag.m_128405_("maxX", pos.m_123341_());
        }
        if (!tag.m_128441_("minY") || tag.m_128451_("minY") > pos.m_123342_()) {
            tag.m_128405_("minY", pos.m_123342_());
        }
        if (!tag.m_128441_("maxY") || tag.m_128451_("maxY") < pos.m_123342_()) {
            tag.m_128405_("maxY", pos.m_123342_());
        }
        if (!tag.m_128441_("minZ") || tag.m_128451_("minZ") > pos.m_123343_()) {
            tag.m_128405_("minZ", pos.m_123343_());
        }
        if (!tag.m_128441_("maxZ") || tag.m_128451_("maxZ") < pos.m_123343_()) {
            tag.m_128405_("maxZ", pos.m_123343_());
        }
    }

    private static void removePos(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("structure_writer");
        tag.m_128473_("minX");
        tag.m_128473_("maxX");
        tag.m_128473_("minY");
        tag.m_128473_("maxY");
        tag.m_128473_("minZ");
        tag.m_128473_("maxZ");
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(context.m_43724_());
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_("export")) {
            if (!player.m_6144_()) {
                StructureWriteBehavior.addPos(stack, context.m_8083_());
            } else {
                StructureWriteBehavior.removePos(stack);
            }
        } else if (player.m_6144_()) {
            boolean l = !itemStack.m_41784_().m_128471_("laser");
            player.m_5661_((Component)Component.m_237113_((String)"\u5bfc\u51fa\u5230").m_130946_(l ? "\u6fc0\u5149" : "\u666e\u901a").m_130946_("\u673a\u5668"), true);
            itemStack.m_41784_().m_128379_("laser", l);
        } else {
            Block block = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
            player.m_5661_((Component)Component.m_237113_((String)"\u5df2\u8bbe\u7f6e ").m_7220_((Component)Component.m_237115_((String)block.m_7705_())).m_130946_(" \u4e3a\u4ed3\u5ba4\u65b9\u5757"), true);
            tag.m_128359_("part", ItemUtils.getId((Block)block));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_()) {
            StructureWriteBehavior.removePos(stack);
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HeldItemUIFactory.INSTANCE.openUI(serverPlayer, usedHand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

