/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item.armor;

import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.armor.IArmorLogic;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpaceArmorComponentItem
extends ArmorComponentItem
implements BotariumFluidItem<WrappedItemFluidContainer> {
    private final long tankSize;

    public SpaceArmorComponentItem(ArmorMaterial material, ArmorItem.Type type, long size, Item.Properties properties) {
        super(material, type, properties);
        this.tankSize = size;
    }

    public void attachComponents(IItemComponent ... components) {
        super.attachComponents(components);
        IDurabilityBar durabilityBar = new IDurabilityBar(){

            public int getBarColor(ItemStack stack) {
                return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank((ItemStack)stack));
            }

            public int getBarWidth(ItemStack stack) {
                WrappedItemFluidContainer fluidContainer = SpaceArmorComponentItem.this.getFluidContainer(stack);
                return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
            }

            public boolean isBarVisible(ItemStack stack) {
                return FluidUtils.hasFluid((ItemStack)stack);
            }

            public boolean showEmptyBar(ItemStack itemStack) {
                return false;
            }
        };
        this.components.add(durabilityBar);
        durabilityBar.onAttached((Item)this);
    }

    @NotNull
    public SpaceArmorComponentItem setArmorLogic(@NotNull IArmorLogic armorLogic) {
        return (SpaceArmorComponentItem)super.setArmorLogic(armorLogic);
    }

    public WrappedItemFluidContainer getFluidContainer(ItemStack holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)this.tankSize), 1, (t, f) -> f.is(ModFluidTags.OXYGEN)));
    }

    public void onArmorTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player) {
        super.onArmorTick(stack, level, player);
        if (level.f_46443_) {
            return;
        }
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.m_146917_(0);
        if (player.f_19797_ % 20 == 0 && SpaceArmorComponentItem.hasOxygen((Entity)player)) {
            if (!OxygenApi.API.hasOxygen((Entity)player)) {
                SpaceArmorComponentItem.consumeOxygen(stack);
            }
            if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                SpaceArmorComponentItem.consumeOxygen(stack);
                player.m_20301_(Math.min(player.m_6062_(), player.m_20146_() + 40));
            }
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent((FluidHolder)FluidUtils.getTank((ItemStack)stack), (long)FluidConstants.fromMillibuckets((long)this.getFluidContainer(stack).getTankCapacity(0)), (Fluid)((Fluid)ModFluids.OXYGEN.get())));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static long getOxygenAmount(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0L;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        Item item = stack.m_41720_();
        if (!(item instanceof SpaceArmorComponentItem)) {
            return 0L;
        }
        SpaceArmorComponentItem suit = (SpaceArmorComponentItem)item;
        return suit.getFluidContainer(stack).getFirstFluid().getFluidAmount();
    }

    public static boolean hasOxygen(Entity entity) {
        return SpaceArmorComponentItem.getOxygenAmount(entity) > FluidConstants.fromMillibuckets((long)1L);
    }

    private static void consumeOxygen(ItemStack stack) {
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)holder);
        if (container == null) {
            return;
        }
        FluidHolder extracted = container.extractFluid(container.getFirstFluid().copyWithAmount(FluidConstants.fromMillibuckets((long)2L)), false);
        if (holder.isDirty() || extracted.getFluidAmount() > 0L) {
            stack.m_41751_(holder.getStack().m_41783_());
        }
    }
}

