/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gtolib.GTOCore;
import com.gtolib.api.capability.IManaContainer;
import com.gtolib.api.machine.mana.feature.IManaMachine;
import com.gtolib.api.machine.mana.trait.NotifiableManaContainer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class MagicEnergyMachine
extends TieredEnergyMachine
implements IManaMachine,
IControllable {
    private TickableSubscription energySubs;
    @Persisted
    private final NotifiableManaContainer manaContainer;
    @Persisted
    private boolean enabled;
    private final long tierMana;

    public MagicEnergyMachine(MetaMachineBlockEntity holder, int tier) {
        super(holder, tier, new Object[0]);
        this.tierMana = GTValues.V[tier] << 1;
        this.manaContainer = new NotifiableManaContainer((MetaMachine)this, IO.IN, 64L * this.tierMana);
        this.manaContainer.setAcceptDistributor(true);
    }

    @NotNull
    public IManaContainer getManaContainer() {
        return this.manaContainer;
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.energySubs = this.subscribeServerTick(this.energySubs, this::checkEnergy, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
    }

    private void checkEnergy() {
        if (this.enabled && this.getLevel() != null && !this.getLevel().m_6443_(EndCrystal.class, AABB.m_165882_((Vec3)new Vec3((double)this.getPos().m_123341_(), (double)(this.getPos().m_123342_() + 1), (double)this.getPos().m_123343_()), (double)1.0, (double)1.0, (double)1.0), e -> true).isEmpty()) {
            if (this.manaContainer.removeMana(this.tierMana, 20, false) == this.tierMana) {
                this.energyContainer.addEnergy(this.tierMana * 20L);
                if (this.energyContainer.getEnergyStored() == this.energyContainer.getEnergyCapacity()) {
                    this.doExplosion(this.tier);
                }
            } else {
                this.doExplosion(this.tier << 1);
            }
        }
    }

    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        long tierVoltage = GTValues.V[this.tier];
        NotifiableEnergyContainer energyContainer = NotifiableEnergyContainer.emitterContainer((MetaMachine)this, (long)(tierVoltage << 8), (long)tierVoltage, (long)this.getMaxInputOutputAmperage());
        energyContainer.setSideOutputCondition(side -> !this.hasFrontFacing() || side == this.getFrontFacing());
        return energyContainer;
    }

    protected boolean isEnergyEmitter() {
        return true;
    }

    protected long getMaxInputOutputAmperage() {
        return 16 >> GTOCore.difficulty;
    }

    public boolean isWorkingEnabled() {
        return this.enabled;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.enabled = isWorkingAllowed;
    }
}

