/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.part;

import appbot.ae2.ManaKey;
import appeng.api.config.Actionable;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.MEStorage;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHolder;
import com.gtocore.utils.ManaUnification;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.mana.ManaAmplifierPartMachine;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import gripe._90.arseng.me.key.SourceKey;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public final class MEManaAmplifierPartMachine
extends ManaAmplifierPartMachine
implements IGridConnectedMachine {
    @RegisterLanguage(cn="\u4eceME\u7f51\u7edc\u62c9\u53d6\u9b54\u529b", en="Pull Mana from ME Network")
    public static final String LANG_USE_SOURCE = "gtceu.machine.mana_amplifier.use_source";
    @RegisterLanguage(cn="\u4eceME\u7f51\u7edc\u62c9\u53d6\u9b54\u6e90", en="Pull Source from ME Network")
    public static final String LANG_USE_MANA = "gtceu.machine.mana_amplifier.use_mana";
    @Persisted
    private final GridNodeHolder nodeHolder = new GridNodeHolder((IGridConnectedMachine)this);
    @DescSynced
    private boolean isOnline;
    @Nullable
    private TickableSubscription updateSubs;
    private boolean useMana = true;
    private boolean useSource = true;

    public MEManaAmplifierPartMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public IManagedGridNode getMainNode() {
        return this.nodeHolder.getMainNode();
    }

    public void onLoad() {
        super.onLoad();
        this.updateSubs = this.subscribeServerTick(this.updateSubs, this::updateTick, 20);
    }

    public Widget createUIWidget() {
        WidgetGroup superWidget = (WidgetGroup)super.createUIWidget();
        return superWidget.addWidget((Widget)new LabelWidget(4, 26, () -> LANG_USE_MANA)).addWidget((Widget)new SwitchWidget(82, 22, 16, 16, (cd, result) -> {
            this.useMana = result;
        }).setPressed(this.useMana).setBaseTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.0, 1.0, 0.5).scale(0.8f)}).setPressedTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.5, 1.0, 0.5).scale(0.8f)})).addWidget((Widget)new LabelWidget(4, 44, () -> LANG_USE_SOURCE)).addWidget((Widget)new SwitchWidget(82, 40, 16, 16, (cd, result) -> {
            this.useSource = result;
        }).setPressed(this.useSource).setBaseTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.0, 1.0, 0.5).scale(0.8f)}).setPressedTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.5, 1.0, 0.5).scale(0.8f)}));
    }

    private void updateTick() {
        if (this.getActionableNode() != null && this.getActionableNode().isActive()) {
            long extracted;
            long canExtract;
            MEStorage meStorage = this.getActionableNode().getGrid().getStorageService().getInventory();
            long canInsert = this.manaContainer.getMaxMana() - this.manaContainer.getCurrentMana();
            if (canInsert > 0L && this.useMana && (canExtract = meStorage.extract(ManaKey.KEY, canInsert, Actionable.SIMULATE, IActionSource.ofMachine((IActionHost)this))) > 0L) {
                extracted = meStorage.extract(ManaKey.KEY, canExtract, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
                this.manaContainer.addMana(extracted, 1, false);
            }
            if ((canInsert = ManaUnification.manaToSource(this.manaContainer.getMaxMana() - this.manaContainer.getCurrentMana())) > 0L && this.useSource && (canExtract = meStorage.extract(SourceKey.KEY, canInsert, Actionable.SIMULATE, IActionSource.ofMachine((IActionHost)this))) > 0L) {
                extracted = meStorage.extract(SourceKey.KEY, canExtract, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
                this.manaContainer.addMana(ManaUnification.sourceToMana(extracted), 1, false);
            }
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.updateSubs != null) {
            this.updateSubs.unsubscribe();
            this.updateSubs = null;
        }
    }

    @Generated
    public boolean isOnline() {
        return this.isOnline;
    }

    @Generated
    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }
}

