/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.google.common.collect.ImmutableList;
import com.gtocore.common.machine.monitor.DisplayComponent;
import com.gtocore.common.machine.monitor.IDisplayComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class DisplayComponentList
extends ArrayList<IDisplayComponent> {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<ResourceLocation> availableOrderedIds;
    private final List<ResourceLocation> remainingOrderedIds = new ArrayList<ResourceLocation>();

    public DisplayComponentList(List<ResourceLocation> availableOrderedIds) {
        this.availableOrderedIds = ImmutableList.copyOf(availableOrderedIds);
        this.remainingOrderedIds.addAll(availableOrderedIds);
    }

    public void addIfAbsent(ResourceLocation id, IDisplayComponent component) {
        if (component == null || id == null) {
            return;
        }
        if (this.remainingOrderedIds.remove(id)) {
            this.add(component);
        }
    }

    public void addIfAbsent(ResourceLocation id, FormattedCharSequence text) {
        this.addIfAbsent(id, DisplayComponent.text(id, text));
    }

    @NotNull
    public DisplayComponentList sortInner() {
        this.sort(this.idSorter());
        return this;
    }

    private Comparator<IDisplayComponent> idSorter() {
        return (o1, o2) -> {
            int index1 = this.availableOrderedIds.indexOf((Object)o1.getId());
            int index2 = this.availableOrderedIds.indexOf((Object)o2.getId());
            if (index1 == -1 || index2 == -1) {
                return 0;
            }
            return Integer.compare(index1, index2);
        };
    }
}

