/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import appeng.api.config.CpuSelectionMode;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.crafting.execution.ElapsedTimeTracker;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.menu.me.crafting.CraftingStatusMenu;
import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gtocore.common.machine.monitor.AbstractAEInfoMonitor;
import com.gtocore.common.machine.monitor.DisplayComponent;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.gtocore.mixin.ae2.menu.CraftingStatusMenuAccessor;
import com.hepdd.gtmthings.utils.FormatUtil;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.Nullable;

public class MonitorAECPU
extends AbstractAEInfoMonitor {
    private static final CraftingStatusMenu.CraftingCpuList EMPTY_CPU_LIST = new CraftingStatusMenu.CraftingCpuList(Collections.emptyList());
    private static final Comparator<CraftingStatusMenu.CraftingCpuListEntry> CPU_COMPARATOR = CraftingStatusMenuAccessor.getCPU_COMPARATOR();
    private static final Comparator<ICraftingCPU> RAW_CPU_COMPARATOR = Comparator.comparing(cpu -> cpu.getName() == null).thenComparing(cpu -> cpu.getName() == null ? "" : cpu.getName().getString()).thenComparing(Comparator.comparingLong(ICraftingCPU::getAvailableStorage).reversed()).thenComparing(Comparator.comparingInt(ICraftingCPU::getCoProcessors).reversed());
    @Nullable
    private ICraftingCPU selectedCpu = null;
    private CraftingStatusMenu.CraftingCpuList cpuList = EMPTY_CPU_LIST;
    @DescSynced
    @Persisted
    private int selectedCpuSerial = -1;
    @DescSynced
    private CompoundTag cpuInfo = new CompoundTag();
    @DescSynced
    private Component cpuName = Component.m_237119_();
    private ImmutableSet<ICraftingCPU> lastCpuSet = ImmutableSet.of();
    private final WeakHashMap<ICraftingCPU, Integer> cpuSerialMap = new WeakHashMap();
    private int nextCpuSerial = 1;

    public MonitorAECPU(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public MonitorAECPU(Object o) {
        this((MetaMachineBlockEntity)o);
    }

    @Override
    public void syncInfoFromServer() {
        int time = (int)Objects.requireNonNull(this.getLevel(), "Not on the server side").m_46467_();
        if (time - this.lastUpdateTime < 20) {
            return;
        }
        if (!this.isOnline || this.getGridNode() == null) {
            this.state = AbstractAEInfoMonitor.State.NO_GRID;
            return;
        }
        this.updateCpus();
        this.lastUpdateTime = time;
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("cpuCount", this.lastCpuSet.size());
        tag.m_128405_("busyCpuCount", (int)this.lastCpuSet.stream().filter(ICraftingCPU::isBusy).count());
        if (this.selectedCpuSerial >= 0 && !this.trySelectCpu(this.selectedCpuSerial) || !this.lastCpuSet.contains((Object)this.selectedCpu)) {
            this.selectedCpu = null;
            this.selectedCpuSerial = -1;
        }
        if (this.selectedCpu != null) {
            CraftingCPUCluster cpu;
            this.cpuName = (Component)Objects.requireNonNullElse(this.selectedCpu.getName(), Component.m_237119_());
            tag.m_128356_("availableStorage", this.selectedCpu.getAvailableStorage());
            tag.m_128356_("coProcessors", (long)this.selectedCpu.getCoProcessors());
            tag.m_128405_("selectionMode", this.selectedCpu.getSelectionMode().ordinal());
            ICraftingCPU iCraftingCPU = this.selectedCpu;
            if (iCraftingCPU instanceof CraftingCPUCluster && (cpu = (CraftingCPUCluster)iCraftingCPU).getJobStatus() != null) {
                GenericStack item = cpu.craftingLogic.getFinalJobOutput();
                if (item != null) {
                    tag.m_128365_("cpuCraftingItem", (Tag)GenericStack.writeTag((GenericStack)item));
                    ElapsedTimeTracker elapsedTimeTracker = cpu.craftingLogic.getElapsedTimeTracker();
                    tag.m_128365_("elapsedTimeTracker", (Tag)elapsedTimeTracker.writeToNBT());
                } else {
                    tag.m_128365_("cpuCraftingItem", (Tag)ItemStack.f_41583_.serializeNBT());
                }
            }
            this.state = AbstractAEInfoMonitor.State.NORMAL;
        } else {
            this.state = AbstractAEInfoMonitor.State.NO_CONFIG;
        }
        this.cpuInfo = tag;
    }

    @Override
    public DisplayComponentList provideInformation() {
        DisplayComponentList infoList = super.provideInformation();
        infoList.addIfAbsent(DisplayRegistry.AE_CPU_USAGE.id(), Component.m_237110_((String)"gtocore.machine.monitor.ae.cpu.usage", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.cpuInfo.m_128451_("busyCpuCount"))).m_130940_(ChatFormatting.DARK_AQUA), Component.m_237113_((String)String.valueOf(this.cpuInfo.m_128451_("cpuCount"))).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.WHITE)}).m_7532_());
        if (this.state != AbstractAEInfoMonitor.State.NORMAL) {
            return infoList;
        }
        long storage = this.cpuInfo.m_128454_("availableStorage");
        if (storage > 0L) {
            GenericStack item;
            infoList.addIfAbsent(DisplayRegistry.AE_CPU_MONITORED.id(), Component.m_237110_((String)"gtocore.machine.monitor.ae.cpu.monitored", (Object[])new Object[]{this.selectedCpuSerial, this.cpuName}).m_7532_());
            infoList.addIfAbsent(DisplayRegistry.AE_CPU_CAPACITY.id(), Component.m_237110_((String)"gui.tooltips.ae2.CpuStatusStorage", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatNumber((long)this.cpuInfo.m_128454_("availableStorage"))).m_130940_(ChatFormatting.AQUA)}).m_130946_("   ").m_7220_((Component)(this.cpuInfo.m_128451_("coProcessors") == 1 ? Component.m_237110_((String)"gui.tooltips.ae2.CpuStatusCoProcessor", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatNumber((long)this.cpuInfo.m_128451_("coProcessors"))).m_130940_(ChatFormatting.AQUA)}) : Component.m_237110_((String)"gui.tooltips.ae2.CpuStatusCoProcessors", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatNumber((long)this.cpuInfo.m_128451_("coProcessors"))).m_130940_(ChatFormatting.AQUA)}))).m_7532_());
            ResourceLocation resourceLocation = DisplayRegistry.AE_CPU_MODE.id();
            infoList.addIfAbsent(resourceLocation, switch (this.cpuInfo.m_128451_("selectionMode")) {
                case 0 -> Component.m_237115_((String)"gui.tooltips.ae2.CpuSelectionModeAny").m_130940_(ChatFormatting.GREEN).m_7532_();
                case 1 -> Component.m_237115_((String)"gui.tooltips.ae2.CpuSelectionModePlayersOnly").m_130940_(ChatFormatting.AQUA).m_7532_();
                case 2 -> Component.m_237115_((String)"gui.tooltips.ae2.CpuSelectionModeAutomationOnly").m_130940_(ChatFormatting.YELLOW).m_7532_();
                default -> Component.m_237113_((String)"Unknown Mode").m_130940_(ChatFormatting.RED).m_7532_();
            });
            if (this.cpuInfo.m_128441_("elapsedTimeTracker") && (item = GenericStack.readTag((CompoundTag)this.cpuInfo.m_128469_("cpuCraftingItem"))) != null) {
                ElapsedTimeTracker elapsedTimeTracker = new ElapsedTimeTracker(this.cpuInfo.m_128469_("elapsedTimeTracker"));
                long elapsedTime = elapsedTimeTracker.getElapsedTime();
                double remainingItems = elapsedTimeTracker.getRemainingItemCount();
                double startItems = elapsedTimeTracker.getStartItemCount();
                long eta = (long)((double)elapsedTime / Math.max(1.0, startItems - remainingItems) * remainingItems);
                Object etaTimeText = String.format("%.02f%%", Float.valueOf(elapsedTimeTracker.getProgress() * 100.0f));
                if (eta > 0L) {
                    long etaInMilliseconds = TimeUnit.MILLISECONDS.convert(eta, TimeUnit.NANOSECONDS);
                    etaTimeText = (String)etaTimeText + " - " + DurationFormatUtils.formatDuration((long)etaInMilliseconds, (String)GuiText.ETAFormat.getLocal());
                }
                infoList.addIfAbsent(DisplayRegistry.AE_CPU_CURRENT_CRAFTING.id(), Component.m_237110_((String)"gui.ae2.Crafting", (Object[])new Object[]{item.what().getDisplayName()}).m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"(").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.Amount, (GenericStack)item)).m_130946_(")").m_130940_(ChatFormatting.DARK_GRAY)).m_7532_());
                infoList.addIfAbsent(DisplayRegistry.AE_CPU_CURRENT_PROGRESS.id(), DisplayComponent.progressBar(DisplayRegistry.AE_CPU_CURRENT_PROGRESS.id(), elapsedTimeTracker.getProgress(), (String)etaTimeText));
            }
        }
        return infoList;
    }

    @Override
    public List<ResourceLocation> getAvailableRLs() {
        List<ResourceLocation> rls = super.getAvailableRLs();
        rls.add(DisplayRegistry.AE_CPU_USAGE.id());
        rls.add(DisplayRegistry.AE_CPU_MONITORED.id());
        rls.add(DisplayRegistry.AE_CPU_CAPACITY.id());
        rls.add(DisplayRegistry.AE_CPU_MODE.id());
        rls.add(DisplayRegistry.AE_CPU_CURRENT_CRAFTING.id());
        rls.add(DisplayRegistry.AE_CPU_CURRENT_PROGRESS.id());
        return rls;
    }

    private void updateCpus() {
        IGridNode network = this.getGridNode();
        if (network != null) {
            if (!this.lastCpuSet.equals((Object)network.getGrid().getCraftingService().getCpus())) {
                this.cpuSerialMap.clear();
                this.nextCpuSerial = 1;
                this.lastCpuSet = network.getGrid().getCraftingService().getCpus();
                this.cpuList = this.createCpuList();
            }
        } else if (!this.lastCpuSet.isEmpty()) {
            this.cpuList = EMPTY_CPU_LIST;
            this.lastCpuSet = ImmutableSet.of();
        }
    }

    @Override
    public Widget createUIWidget() {
        Widget superWidget = super.createUIWidget();
        CPUListGui cpuListGui = new CPUListGui(198, 16, 50, 108);
        Widget panel = new ComponentPanelWidget(cpuListGui.getPositionX() + cpuListGui.getSizeWidth() / 2, cpuListGui.getPositionY() + 5 + cpuListGui.getSizeHeight(), List.of(Component.m_237115_((String)"gtocore.machine.monitor.ae.cpu.list").m_130940_(ChatFormatting.BLACK))).setCenter(true).setClientSideWidget();
        return new WidgetGroup(0, 0, superWidget.getSizeWidth() + 60, superWidget.getSizeHeight()).addWidget(superWidget).addWidget((Widget)cpuListGui).addWidget(panel);
    }

    private CraftingStatusMenu.CraftingCpuList createCpuList() {
        ArrayList<CraftingStatusMenu.CraftingCpuListEntry> entries = new ArrayList<CraftingStatusMenu.CraftingCpuListEntry>(this.lastCpuSet.size());
        for (ICraftingCPU cpu : this.lastCpuSet.stream().sorted(RAW_CPU_COMPARATOR).toList()) {
            int serial = this.getOrAssignCpuSerial(cpu);
            CraftingJobStatus status = cpu.getJobStatus();
            float progress = 0.0f;
            if (status != null && status.totalItems() > 0L) {
                progress = (float)((double)status.progress() / (double)status.totalItems());
            }
            entries.add(new CraftingStatusMenu.CraftingCpuListEntry(serial, cpu.getAvailableStorage(), cpu.getCoProcessors(), cpu.getName(), cpu.getSelectionMode(), status != null ? status.crafting() : null, progress, status != null ? status.elapsedTimeNanos() : 0L));
        }
        entries.sort(CPU_COMPARATOR);
        return new CraftingStatusMenu.CraftingCpuList(entries);
    }

    private int getOrAssignCpuSerial(ICraftingCPU cpu) {
        return this.cpuSerialMap.computeIfAbsent(cpu, ignored -> this.nextCpuSerial++);
    }

    private boolean trySelectCpu(int serial) {
        this.updateCpus();
        if (serial < 0) {
            this.selectedCpu = null;
            this.selectedCpuSerial = -1;
            return false;
        }
        for (ICraftingCPU cpu : this.lastCpuSet) {
            if (this.getOrAssignCpuSerial(cpu) != serial) continue;
            this.selectedCpu = cpu;
            this.selectedCpuSerial = serial;
            break;
        }
        return true;
    }

    private class CPUListGui
    extends WidgetGroup {
        private static final int PACKET_ID = 1;
        private DraggableScrollableWidgetGroup scrollArea;
        private final Int2ObjectOpenHashMap<SerialWidget> serialWidgets;

        private CPUListGui(int x, int y, int width, int height) {
            super(x, y, width, height);
            this.serialWidgets = new Int2ObjectOpenHashMap();
            this.setSize(width, height);
            this.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            this.init();
        }

        public void writeInitialData(FriendlyByteBuf buffer) {
            super.writeInitialData(buffer);
            MonitorAECPU.this.cpuList.writeToPacket(buffer);
        }

        public void readInitialData(FriendlyByteBuf buffer) {
            super.readInitialData(buffer);
            MonitorAECPU.this.cpuList = new CraftingStatusMenu.CraftingCpuList(buffer);
            this.init();
        }

        public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
            if (id == 1) {
                MonitorAECPU.this.cpuList = new CraftingStatusMenu.CraftingCpuList(buffer);
                MonitorAECPU.this.selectedCpuSerial = buffer.readInt();
            } else {
                super.readUpdateInfo(id, buffer);
            }
        }

        private void init() {
            boolean firstInit;
            boolean bl = firstInit = this.scrollArea == null;
            if (firstInit) {
                this.scrollArea = new DraggableScrollableWidgetGroup(4, 4, this.getSizeWidth() - 8, this.getSizeHeight() - 8);
                this.addWidget((Widget)this.scrollArea);
                this.scrollArea.setScrollable(true);
                this.scrollArea.setYBarStyle((IGuiTexture)GuiTextures.BACKGROUND, (IGuiTexture)GuiTextures.BOX_OVERLAY);
            } else {
                this.scrollArea.clearAllWidgets();
            }
            int y = 2;
            for (CraftingStatusMenu.CraftingCpuListEntry cpu : MonitorAECPU.this.cpuList.cpus()) {
                ChatFormatting color = cpu.serial() == MonitorAECPU.this.selectedCpuSerial ? ChatFormatting.GREEN : ChatFormatting.WHITE;
                SerialWidget cpuWidgets = (SerialWidget)this.serialWidgets.computeIfAbsent(cpu.serial(), serial -> new SerialWidget(serial, new LabelWidget(), new ButtonWidget()));
                LabelWidget cpuWidget = cpuWidgets.label();
                cpuWidget.setSelfPosition(5, y);
                cpuWidget.setClientSideWidget();
                cpuWidget.setHoverTooltips(this.createCpuTooltips(cpu));
                cpuWidget.setComponent((Component)Component.m_237113_((String)("#" + cpu.serial())).m_130940_(color));
                ButtonWidget button2 = cpuWidgets.button().setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON});
                button2.setSelfPosition(this.getSizeWidth() - 20, y);
                button2.setSize(10, 10);
                button2.setOnPressCallback(click -> {
                    if (!this.isRemote() && MonitorAECPU.this.trySelectCpu(cpu.serial())) {
                        this.init();
                        this.writeUpdateInfo(1, buf -> {
                            MonitorAECPU.this.cpuList.writeToPacket(buf);
                            buf.writeInt(cpu.serial());
                        });
                    }
                });
                button2.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.monitor.ae.cpu.set.1"), Component.m_237115_((String)"gtocore.machine.monitor.ae.cpu.set.2")});
                this.scrollArea.acceptWidget((IConfigurableWidget)button2);
                this.scrollArea.acceptWidget((IConfigurableWidget)cpuWidget);
                y += 10;
            }
        }

        private static MutableComponent getHashedComponent(CraftingStatusMenu.CraftingCpuListEntry cpu) {
            MutableComponent cpuName = Component.m_237113_((String)("CPU #" + cpu.serial()));
            if (cpu.name() != null) {
                cpuName = cpuName.m_130946_(" - ").m_7220_(cpu.name());
            }
            return cpuName;
        }

        private List<Component> createCpuTooltips(CraftingStatusMenu.CraftingCpuListEntry cpu) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            tooltips.add((Component)CPUListGui.getHashedComponent(cpu).m_130940_(ChatFormatting.GOLD));
            tooltips.add((Component)Component.m_237110_((String)"gui.tooltips.ae2.CpuStatusStorage", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatNumber((long)cpu.storage())).m_130940_(ChatFormatting.AQUA)}));
            tooltips.add((Component)(cpu.coProcessors() == 1 ? Component.m_237110_((String)"gui.tooltips.ae2.CpuStatusCoProcessor", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatNumber((long)cpu.coProcessors())).m_130940_(ChatFormatting.AQUA)}) : Component.m_237110_((String)"gui.tooltips.ae2.CpuStatusCoProcessors", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatNumber((long)cpu.coProcessors())).m_130940_(ChatFormatting.AQUA)})));
            tooltips.add((Component)(switch (cpu.mode()) {
                default -> throw new MatchException(null, null);
                case CpuSelectionMode.PLAYER_ONLY -> Component.m_237115_((String)"gui.tooltips.ae2.CpuSelectionModePlayersOnly").m_130940_(ChatFormatting.AQUA);
                case CpuSelectionMode.ANY -> Component.m_237115_((String)"gui.tooltips.ae2.CpuSelectionModeAny").m_130940_(ChatFormatting.GREEN);
                case CpuSelectionMode.MACHINE_ONLY -> Component.m_237115_((String)"gui.tooltips.ae2.CpuSelectionModeAutomationOnly").m_130940_(ChatFormatting.YELLOW);
            }));
            if (cpu.currentJob() != null) {
                tooltips.add((Component)Component.m_237110_((String)"gui.tooltips.ae2.CpuStatusCrafting", (Object[])new Object[]{cpu.currentJob().what().getDisplayName()}));
            } else {
                tooltips.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
            return tooltips;
        }

        private record SerialWidget(int serial, LabelWidget label, ButtonWidget button) {
        }
    }
}

