/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationHatch;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableComputationContainer;
import com.gtocore.common.machine.monitor.AbstractInfoProviderMonitor;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonitorCWU
extends AbstractInfoProviderMonitor
implements IOpticalComputationHatch {
    @DescSynced
    private long cwtTotal = 0L;
    @DescSynced
    private long cwtRequestable = 0L;
    @DescSynced
    boolean hasContainer = false;
    private long requestedCWUPerSec;
    @DescSynced
    private long lastRequestedCWUt;
    protected final NotifiableComputationContainer computationContainer = new InnerComputationContainer(this);

    public MonitorCWU(Object o) {
        this((MetaMachineBlockEntity)o);
    }

    public MonitorCWU(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public long requestCWU(long cwu, boolean simulate) {
        long requestedCWUt = this.computationContainer.requestCWU(cwu, simulate);
        if (!simulate) {
            this.requestedCWUPerSec += requestedCWUt;
        }
        return requestedCWUt;
    }

    public long getMaxCWU() {
        return this.computationContainer.getMaxCWU();
    }

    public boolean isTransmitter() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == GTCapability.CAPABILITY_COMPUTATION_PROVIDER) {
            return GTCapability.CAPABILITY_COMPUTATION_PROVIDER.orEmpty(cap, LazyOptional.of(() -> this));
        }
        return null;
    }

    public boolean canBridge() {
        return this.computationContainer.canBridge();
    }

    @Override
    public DisplayComponentList provideInformation() {
        DisplayComponentList infoList = super.provideInformation();
        infoList.addIfAbsent(DisplayRegistry.COMPUTATION_WORK.id(), Component.m_237110_((String)"gtocore.machine.monitor.cwu.capacity", (Object[])new Object[]{NumberFormat.getInstance().format(this.cwtTotal), NumberFormat.getInstance().format(this.cwtRequestable)}).m_130940_(ChatFormatting.GREEN).m_7532_());
        infoList.addIfAbsent(DisplayRegistry.COMPUTATION_WORK_USED.id(), Component.m_237110_((String)"gtocore.machine.monitor.cwu.used", (Object[])new Object[]{NumberFormat.getInstance().format(this.lastRequestedCWUt)}).m_130940_(ChatFormatting.GRAY).m_7532_());
        return infoList;
    }

    @Override
    public void syncInfoFromServer() {
        this.cwtTotal = this.getMaxCWU();
        this.cwtRequestable = this.requestCWU(Long.MAX_VALUE, true);
        this.hasContainer = true;
        this.lastRequestedCWUt = this.requestedCWUPerSec / 10L;
        this.requestedCWUPerSec = 0L;
    }

    @Override
    public List<ResourceLocation> getAvailableRLs() {
        List rls = super.getAvailableRLs();
        rls.add(DisplayRegistry.COMPUTATION_WORK.id());
        rls.add(DisplayRegistry.COMPUTATION_WORK_USED.id());
        return rls;
    }

    private class InnerComputationContainer
    extends NotifiableComputationContainer {
        InnerComputationContainer(MonitorCWU monitorCWU) {
            super((MetaMachine)monitorCWU, false);
        }

        @Nullable
        protected IOpticalComputationProvider getOpticalNetProvider() {
            IOpticalComputationProvider p = null;
            for (Direction direction : Direction.values()) {
                IOpticalComputationHatch hatch;
                BlockEntity blockEntity = this.machine.getNeighbor(direction);
                if (blockEntity == null) continue;
                IOpticalComputationProvider cap = (IOpticalComputationProvider)blockEntity.getCapability(GTCapability.CAPABILITY_COMPUTATION_PROVIDER, direction.m_122424_()).orElse(null);
                if (cap instanceof IOpticalComputationHatch && (hatch = (IOpticalComputationHatch)cap).isTransmitter() && hatch != this.machine) {
                    p = cap;
                    break;
                }
                if (cap == null) continue;
                p = cap;
                break;
            }
            return p;
        }
    }
}

