/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtolib.api.machine.impl.part.WirelessEnergyInterfacePartMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.wireless.ExtendWirelessEnergyContainer;
import com.gtolib.utils.MathUtil;
import com.gtolib.utils.holder.ObjectHolder;
import java.math.BigInteger;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnergyInjectorMachine
extends ElectricMultiblockMachine {
    private WirelessEnergyInterfacePartMachine energyInterfacePartMachine;

    public EnergyInjectorMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public boolean hasOverclockConfig() {
        return false;
    }

    public boolean hasBatchConfig() {
        return false;
    }

    public void onPartScan(@NotNull IMultiPart part) {
        super.onPartScan(part);
        if (this.energyInterfacePartMachine == null && part instanceof WirelessEnergyInterfacePartMachine) {
            WirelessEnergyInterfacePartMachine hatchPartMachine;
            this.energyInterfacePartMachine = hatchPartMachine = (WirelessEnergyInterfacePartMachine)part;
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.energyInterfacePartMachine = null;
    }

    @Nullable
    private Recipe getRecipe() {
        ExtendWirelessEnergyContainer container = null;
        BigInteger storage = null;
        if (this.energyInterfacePartMachine != null) {
            container = this.energyInterfacePartMachine.getWirelessEnergyContainer();
            if (container == null) {
                return null;
            }
            storage = container.getStorage();
            if (storage.signum() < 1) {
                return null;
            }
        }
        ObjectHolder eu = new ObjectHolder((Object)BigInteger.ZERO);
        RecipeBuilder builder = this.getRecipeBuilder();
        this.fastForEachInputItems((stack, amount) -> {
            ElectricItem electricItem;
            int count = MathUtil.saturatedCast((long)amount);
            ItemStack output = stack.m_255036_(count);
            IElectricItem patt0$temp = GTCapabilityHelper.getElectricItem((ItemStack)output);
            if (patt0$temp instanceof ElectricItem && (electricItem = (ElectricItem)patt0$temp).getTier() <= this.getTier()) {
                BigInteger change = BigInteger.valueOf(electricItem.getMaxCharge() - electricItem.getCharge()).multiply(BigInteger.valueOf(count));
                if (change.compareTo(BigInteger.ZERO) > 0) {
                    eu.value = ((BigInteger)eu.value).add(change);
                    electricItem.setCharge(electricItem.getMaxCharge());
                    builder.outputItems(output);
                    builder.inputItems(stack.m_41720_(), count);
                }
            } else if (output.m_41773_() > 0) {
                eu.value = ((BigInteger)eu.value).add(BigInteger.valueOf((long)output.m_41773_() << 7));
                output.m_41721_(0);
                builder.outputItems(output);
                builder.inputItems(stack.m_41720_(), count);
            } else {
                int change;
                IEnergyStorage energyStorage = GTCapabilityHelper.getForgeEnergyItem((ItemStack)output);
                if (energyStorage != null && (change = (energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored()) * count) > 0) {
                    eu.value = ((BigInteger)eu.value).add(BigInteger.valueOf((long)Math.ceil((double)change / 64.0)));
                    energyStorage.receiveEnergy(change, false);
                    builder.outputItems(output);
                    builder.inputItems(stack.m_41720_(), count);
                }
            }
        });
        if (((BigInteger)eu.value).compareTo(BigInteger.ZERO) > 0) {
            Recipe recipe;
            if (container != null) {
                if (storage.compareTo((BigInteger)eu.value) < 0) {
                    this.setIdleReason(IdleReason.NO_EU);
                    return null;
                }
                container.setStorage(storage.subtract((BigInteger)eu.value));
                recipe = builder.duration(1).buildRawRecipe();
            } else {
                recipe = builder.EUt(this.getOverclockVoltage()).duration(Math.max(1, ((BigInteger)eu.value).divide(BigInteger.valueOf(this.getOverclockVoltage())).intValue())).buildRawRecipe();
                if (!RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
                    return null;
                }
            }
            return recipe;
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }
}

