/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.part.SensorPartMachine;
import com.gtolib.api.machine.feature.multiblock.IStorageMultiblock;
import com.gtolib.api.machine.multiblock.CustomParallelMultiblockMachine;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.GTOUtils;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FastNeutronBreederReactor
extends CustomParallelMultiblockMachine
implements IStorageMultiblock,
IExplosionMachine {
    @Persisted
    private final NotifiableItemStackHandler machineStorage = this.createMachineStorage(i -> i.m_41720_() == GTItems.NEUTRON_REFLECTOR.m_5456_());
    @Persisted
    private float temperature = 298.0f;
    @Persisted
    private double neutronFluxkeV = 0.0;
    @Persisted
    private double recipeHeat = 0.0;
    private SensorPartMachine sensorMachineTemp;
    private SensorPartMachine sensorNeutronFlux;
    private static final int MAX_TEMPERATURE = 2098;
    @Nullable
    private TickableSubscription tickSubscription;

    public FastNeutronBreederReactor(MetaMachineBlockEntity holder) {
        super(holder, true, h -> 2048L);
    }

    public NotifiableItemStackHandler getMachineStorage() {
        return this.machineStorage;
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (recipe.data.m_128441_("neutron_flux")) {
            float neededNeutronFlux = recipe.data.m_128457_("neutron_flux");
            if (this.neutronFluxkeV < (double)neededNeutronFlux) {
                ((IEnhancedRecipeLogic)this.getRecipeLogic()).gtolib$setIdleReason((Component)Component.m_237115_((String)"gtocore.idle_reason.neutron_kinetic_energy_not_satisfies"));
                return null;
            }
            recipe.parallels = Math.min(recipe.parallels, 2048L);
            recipe.duration = this.getRecipeDuration(recipe, neededNeutronFlux);
            return recipe;
        }
        return super.getRealRecipe(recipe);
    }

    public boolean beforeWorking(@NotNull Recipe recipe) {
        this.recipeHeat = this.getRecipeHeat(recipe);
        return super.beforeWorking(recipe);
    }

    @NotNull
    public Widget createUIWidget() {
        return super.createUIWidget(super.createUIWidget());
    }

    public boolean onWorking() {
        if (this.getRecipeLogic().getLastRecipe() != null && this.getOffsetTimer() % 20 == 0) {
            GTRecipe recipe = this.getRecipeLogic().getLastRecipe();
            float change = recipe.data.m_128457_("neutron_flux_change");
            this.neutronFluxkeV = Math.max(0.0, this.neutronFluxkeV + (double)change);
            float neededNeutronFlux = recipe.data.m_128457_("neutron_flux");
            if (this.neutronFluxkeV < (double)neededNeutronFlux) {
                ((IEnhancedRecipeLogic)this.getRecipeLogic()).gtolib$setIdleReason((Component)Component.m_237115_((String)"gtocore.idle_reason.neutron_kinetic_energy_not_satisfies"));
                return false;
            }
            this.recipeHeat = this.getRecipeHeat((Recipe)recipe);
        }
        return super.onWorking();
    }

    public void afterWorking() {
        super.afterWorking();
        this.recipeHeat = 0.0;
    }

    public void onLoad() {
        super.onLoad();
        this.tickSubscription = this.subscribeServerTick(this.tickSubscription, this::tick, 20);
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubscription != null) {
            this.tickSubscription.unsubscribe();
            this.tickSubscription = null;
        }
    }

    public void onPartScan(@NotNull IMultiPart part) {
        super.onPartScan(part);
        if (part instanceof SensorPartMachine) {
            SensorPartMachine sensorPartMachine = (SensorPartMachine)part;
            if (sensorPartMachine.getHolder().m_58900_().m_60713_((Block)GTOMachines.HEAT_SENSOR.get())) {
                this.sensorMachineTemp = sensorPartMachine;
            } else if (sensorPartMachine.getHolder().m_58900_().m_60713_((Block)GTOMachines.NEUTRON_SENSOR.get())) {
                this.sensorNeutronFlux = sensorPartMachine;
            }
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.sensorMachineTemp = null;
        this.sensorNeutronFlux = null;
        this.recipeHeat = 0.0;
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.current_temperature", (Object[])new Object[]{FormattingUtil.formatNumber2Places((float)this.temperature)}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.neutron_flux", (Object[])new Object[]{FormattingUtil.formatNumber2Places((double)this.neutronFluxkeV)}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.temp.per_second", (Object[])new Object[]{FormattingUtil.formatNumber2Places((double)this.recipeHeat)}));
    }

    private double getRecipeHeat(Recipe recipe) {
        if (recipe.data.m_128441_("heat")) {
            return (double)recipe.data.m_128457_("heat") * 1.27 * Math.pow(this.neutronFluxkeV / 100.0, 1.88);
        }
        return 0.0;
    }

    private int getRecipeDuration(Recipe recipe, double neededNeutronFlux) {
        double k = Math.max(0.9 - (this.neutronFluxkeV - neededNeutronFlux) / 100000.0, 0.1);
        return Math.max((int)((double)recipe.duration * Math.pow(k, Math.sqrt(recipe.parallels))), 1);
    }

    private void tick() {
        if (this.isFormed()) {
            this.fastForEachInputItems((stack, amount) -> {
                Integer neutron_sources = Wrapper.NEUTRON_SOURCES.get(stack.m_41720_());
                if (neutron_sources != null) {
                    this.neutronFluxkeV += (double)((long)neutron_sources.intValue() * amount);
                    this.inputItem((ItemLike)stack.m_41720_(), amount);
                }
            });
            this.neutronFluxkeV = Math.max(0.0, this.neutronFluxkeV - 10.0);
            int reflectors = this.machineStorage.getStackInSlot(0).m_41613_();
            if (reflectors > 0 && this.neutronFluxkeV > 0.0) {
                this.neutronFluxkeV += (double)((long)Math.sqrt(this.neutronFluxkeV * (double)reflectors));
            }
            this.temperature += (float)this.recipeHeat;
            this.fastForEachInputFluids((stack, amount) -> {
                Fluid fluid = stack.getFluid();
                Integer coolants = Wrapper.COOLANTS.get(fluid);
                if (coolants != null && this.temperature > 298.0f) {
                    long processAmount = Math.min((long)Math.ceil((this.temperature - 298.0f) / (float)coolants.intValue()), amount);
                    this.temperature -= (float)(processAmount * (long)coolants.intValue());
                    this.inputFluid(fluid, processAmount);
                    long outputAmount = processAmount;
                    if (fluid == GTMaterials.DistilledWater.getFluid()) {
                        outputAmount *= 160L;
                    }
                    this.outputFluid(Wrapper.COOLANT_OUTPUTS.get(fluid), outputAmount);
                }
            });
            this.temperature = Math.max(298.0f, this.temperature);
            if (this.temperature > 2098.0f) {
                this.meltDown();
            }
            if (this.sensorMachineTemp != null) {
                this.sensorMachineTemp.update(this.temperature);
            }
            if (this.sensorNeutronFlux != null) {
                this.sensorNeutronFlux.update((float)(this.neutronFluxkeV / 1000.0));
            }
        }
    }

    private void meltDown() {
        this.outputItem((ItemLike)GTOItems.NUCLEAR_WASTE.m_5456_(), 1 + (int)(Math.random() * 4.0));
        MultiblockControllerMachine machine = this.self();
        Level level = machine.getLevel();
        BlockPos pos = machine.getPos().m_5484_(machine.getFrontFacing().m_122424_(), 6);
        if (level != null) {
            for (int x = -2; x <= 2; ++x) {
                for (int y = 0; y <= 20; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        GTOUtils.fastRemoveBlock((Level)level, (BlockPos)pos.m_7918_(x, y, z), (boolean)false, (boolean)false);
                    }
                }
            }
            GTOUtils.fastRemoveBlock((Level)level, (BlockPos)machine.getPos(), (boolean)false, (boolean)false);
            this.doExplosion(20.0f);
        }
    }

    private static class Wrapper {
        private static final Map<Item, Integer> NEUTRON_SOURCES;
        private static final Map<Fluid, Integer> COOLANTS;
        private static final Map<Fluid, Fluid> COOLANT_OUTPUTS;

        private Wrapper() {
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Graphite).m_41720_(), (Object)-1000);
            builder.put((Object)ChemicalHelper.get((TagPrefix)TagPrefix.dustSmall, (Material)GTMaterials.Graphite).m_41720_(), (Object)-250);
            builder.put((Object)ChemicalHelper.get((TagPrefix)TagPrefix.dustTiny, (Material)GTMaterials.Graphite).m_41720_(), (Object)-100);
            builder.put((Object)ChemicalHelper.get((TagPrefix)GTOTagPrefix.PARTICLE_SOURCE, (Material)GTOMaterials.AntinomyBerylliumSource).m_41720_(), (Object)10);
            builder.put((Object)ChemicalHelper.get((TagPrefix)GTOTagPrefix.PARTICLE_SOURCE, (Material)GTOMaterials.PlutoniumBerylliumSource).m_41720_(), (Object)100);
            builder.put((Object)ChemicalHelper.get((TagPrefix)GTOTagPrefix.PARTICLE_SOURCE, (Material)GTOMaterials.Californium252Source).m_41720_(), (Object)1000);
            NEUTRON_SOURCES = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            builder1.put((Object)GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID), (Object)80);
            builder1.put((Object)GTOMaterials.LiquidNitrogen.getFluid(), (Object)4);
            builder1.put((Object)GTMaterials.DistilledWater.getFluid(), (Object)1);
            COOLANTS = builder1.build();
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            builder2.put((Object)GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID), (Object)GTMaterials.Helium.getFluid(FluidStorageKeys.GAS));
            builder2.put((Object)GTOMaterials.LiquidNitrogen.getFluid(), (Object)GTMaterials.Nitrogen.getFluid());
            builder2.put((Object)GTMaterials.DistilledWater.getFluid(), (Object)GTMaterials.Steam.getFluid());
            COOLANT_OUTPUTS = builder2.build();
        }
    }
}

