/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gtocore.common.machine.multiblock.part.ScanningHolderMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.ItemUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ScanningStationMachine
extends ElectricMultiblockMachine {
    private ScanningHolderMachine objectHolder;

    public ScanningStationMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof ScanningHolderMachine)) continue;
            ScanningHolderMachine scanningHolder = (ScanningHolderMachine)part;
            if (scanningHolder.getFrontFacing() != this.getFrontFacing().m_122424_()) {
                this.onStructureInvalid();
                return;
            }
            this.objectHolder = scanningHolder;
            this.addHandlerList(RecipeHandlerList.of((IO)IO.IN, (IRecipeHandler[])new IRecipeHandler[]{scanningHolder.getAsHandler(), scanningHolder.getCatalystFluidTank()}));
        }
        if (this.objectHolder == null) {
            this.onStructureInvalid();
        }
    }

    public boolean checkPattern() {
        boolean isFormed = super.checkPattern();
        if (isFormed && this.objectHolder != null && this.objectHolder.getFrontFacing() != this.getFrontFacing().m_122424_()) {
            this.onStructureInvalid();
        }
        return isFormed;
    }

    public void onStructureInvalid() {
        if (this.objectHolder != null) {
            this.objectHolder.setLocked(false);
            this.objectHolder = null;
        }
        super.onStructureInvalid();
    }

    public boolean regressWhenWaiting() {
        return false;
    }

    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.work_paused", "gtocore.machine.analysis").addEnergyUsageLine((IEnergyContainer)this.energyContainer).addEnergyTierLine(this.tier).addWorkingStatusLine().addProgressLineOnlyPercent(this.recipeLogic.getProgressPercent());
    }

    public boolean matchRecipe(Recipe recipe) {
        return RecipeRunner.matchRecipeInput((IRecipeCapabilityHolder)this, (Recipe)recipe);
    }

    public boolean handleRecipeIO(Recipe originalRecipe, IO io) {
        if (io == IO.IN) {
            this.objectHolder.setLocked(true);
            return true;
        }
        GTRecipe lastRecipe = this.getRecipeLogic().getLastRecipe();
        if (lastRecipe == null) {
            this.objectHolder.setLocked(false);
            return true;
        }
        List catalyst = lastRecipe.getInputContents((RecipeCapability)ItemRecipeCapability.CAP);
        if (ItemUtils.getFirstSized((Ingredient)((Ingredient)ItemRecipeCapability.CAP.of(((Content)catalyst.getFirst()).content))).m_41720_() != this.objectHolder.getCatalystItem(false).m_41720_()) {
            ItemStack hold = this.objectHolder.getHeldItem(true);
            this.objectHolder.setHeldItem(this.objectHolder.getCatalystItem(true));
            this.objectHolder.setCatalystItem(hold);
            this.objectHolder.setLocked(false);
            return true;
        }
        List fluidInputs = lastRecipe.getInputContents((RecipeCapability)FluidRecipeCapability.CAP);
        if (!fluidInputs.isEmpty()) {
            FluidStack requiredFluid = ((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidInputs.getFirst()).content)).getStacks()[0];
            FluidStack currentFluid = this.objectHolder.getCatalystFluidTank().getFluidInTank(0);
            if (currentFluid.isEmpty() || !requiredFluid.isFluidEqual(currentFluid) || currentFluid.getAmount() < requiredFluid.getAmount()) {
                this.objectHolder.setLocked(false);
                return true;
            }
        }
        this.objectHolder.setHeldItem(ItemStack.f_41583_);
        ItemStack outputItem = ItemStack.f_41583_;
        List contents = lastRecipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP);
        if (!contents.isEmpty()) {
            outputItem = ItemUtils.getFirstSized((Ingredient)((Ingredient)((Content)contents.getFirst()).content)).m_41777_();
        }
        if (!outputItem.m_41619_()) {
            this.objectHolder.setDataItem(outputItem);
        }
        this.objectHolder.getCatalystFluidTank().setFluidInTank(0, FluidStack.EMPTY);
        this.objectHolder.setLocked(false);
        return true;
    }
}

