/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCABridgePartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCAComponentPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCAComputationPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCACoolerPartMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.part.ThermalConductorHatchPartMachine;
import com.gtocore.common.machine.multiblock.part.research.ExResearchBasePartMachine;
import com.gtocore.common.machine.multiblock.part.research.ExResearchBridgePartMachine;
import com.gtocore.common.machine.multiblock.part.research.ExResearchComputationPartMachine;
import com.gtocore.common.machine.multiblock.part.research.ExResearchCoolerPartMachine;
import com.gtolib.IItem;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.common.registry.ModItems;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SupercomputingCenterMachine
extends StorageMultiblockMachine
implements IOpticalComputationProvider {
    private static final Map<Item, Integer> MAINFRAME = Map.of(GTOItems.BIOWARE_MAINFRAME.m_5456_(), 2, GTOItems.SUPRACAUSAL_MAINFRAME.m_5456_(), 3);
    private static final Map<Integer, Integer> GLASS_MAP = Map.of(1, 5, 2, 9, 3, 11);
    private static final Map<Item, Item> MFPCs;
    private static final Map<Item, Integer> ITEM_INDEX_MAP;
    private ThermalConductorHatchPartMachine ThermalConductorHatchPart;
    private final ConditionalSubscriptionHandler maxCWUtModificationSubs;
    @Persisted
    private int machineTier = 1;
    @Persisted
    private int maxCWUtModification;
    private boolean incompatible;
    private boolean canBridge;
    private int maxCWUt;
    private int coolingAmountRequired;
    private int coolingAmountProvided;
    private int coolantAmount;
    private final Reference2IntOpenHashMap<IItem> componentsMap = new Reference2IntOpenHashMap();
    private long allocatedCWUt;
    private long cacheCWUt;
    private long maxEUt;
    private Recipe runRecipe;
    @Nullable
    private TickableSubscription tickSubs;
    private final int[] N_MFPCs = new int[]{5400, 1800, 600, 200, 66, 22, 1};

    public SupercomputingCenterMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, stack -> MAINFRAME.containsKey(stack.m_41720_()));
        this.maxCWUtModificationSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::maxCWUtModificationUpdate, 10, () -> this.isFormed);
    }

    private void clean(boolean scanOnly) {
        this.canBridge = false;
        this.incompatible = false;
        this.runRecipe = null;
        this.allocatedCWUt = scanOnly ? this.allocatedCWUt : 0L;
        this.cacheCWUt = scanOnly ? this.cacheCWUt : 0L;
        this.maxCWUt = 0;
        this.coolingAmountRequired = 0;
        this.coolingAmountProvided = 0;
        this.coolantAmount = 0;
        this.maxEUt = 0L;
        this.componentsMap.clear();
    }

    private void changed(boolean scanOnly) {
        int maxCoolantAmount = 0;
        int hpcaPassiveCoolingAmount = 0;
        this.clean(scanOnly);
        if (!this.isFormed) {
            return;
        }
        Integer computerTier = (Integer)this.getMultiblockState().getMatchContext().get((Object)"c_c");
        if (computerTier == null || this.machineTier != computerTier) {
            this.incompatible = true;
            return;
        }
        Integer heatTier = (Integer)this.getMultiblockState().getMatchContext().get((Object)"c_h");
        if (heatTier == null || this.machineTier != heatTier) {
            this.incompatible = true;
            return;
        }
        Integer glassTier = (Integer)this.getMultiblockState().getMatchContext().get((Object)"g_b");
        if (glassTier == null || glassTier < GLASS_MAP.get(this.machineTier)) {
            this.incompatible = true;
            return;
        }
        if (this.machineTier == 3) {
            this.canBridge = true;
        }
        block13: for (IMultiPart part : this.getParts()) {
            HPCAComponentPartMachine hPCAComponentPartMachine;
            if (this.incompatible) {
                return;
            }
            if (!(part instanceof HPCAComponentPartMachine)) continue;
            HPCAComponentPartMachine componentPartMachine = (HPCAComponentPartMachine)part;
            this.maxEUt += (long)componentPartMachine.getMaxEUt();
            this.addToComponentsMap(componentPartMachine);
            Objects.requireNonNull(componentPartMachine);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExResearchBasePartMachine.class, HPCAComponentPartMachine.class}, (Object)hPCAComponentPartMachine, n)) {
                case 0: {
                    Object c;
                    ExResearchBasePartMachine exPart = (ExResearchBasePartMachine)hPCAComponentPartMachine;
                    if (exPart.getTier() - 1 != this.machineTier) {
                        this.incompatible = true;
                        return;
                    }
                    Objects.requireNonNull(exPart);
                    int n2 = 0;
                    block14: while (true) {
                        ExResearchBasePartMachine exResearchBasePartMachine;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExResearchBridgePartMachine.class, ExResearchComputationPartMachine.class, ExResearchCoolerPartMachine.class}, (Object)((Object)exResearchBasePartMachine), n2)) {
                            case 0: {
                                ExResearchBridgePartMachine b2 = (ExResearchBridgePartMachine)exResearchBasePartMachine;
                                this.canBridge = true;
                                continue block13;
                            }
                            case 1: {
                                ExResearchComputationPartMachine c2 = (ExResearchComputationPartMachine)exResearchBasePartMachine;
                                if (c2.isDamaged()) {
                                    n2 = 2;
                                    continue block14;
                                }
                                this.maxCWUt += c2.getCWUPerTick();
                                this.coolingAmountRequired += c2.getCoolingPerTick();
                                continue block13;
                            }
                            case 2: {
                                c = (ExResearchCoolerPartMachine)exResearchBasePartMachine;
                                this.coolingAmountProvided += ((ExResearchCoolerPartMachine)((Object)c)).getCoolingAmount();
                                maxCoolantAmount += ((ExResearchCoolerPartMachine)((Object)c)).getMaxCoolantPerTick();
                                continue block13;
                            }
                        }
                        break;
                    }
                    continue block13;
                }
                default: {
                    Object c;
                    HPCAComponentPartMachine hpcaPart = hPCAComponentPartMachine;
                    if (this.machineTier > 1) {
                        this.incompatible = true;
                        return;
                    }
                    Objects.requireNonNull(hpcaPart);
                    int n3 = 0;
                    block15: while (true) {
                        HPCAComponentPartMachine hPCAComponentPartMachine2;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HPCABridgePartMachine.class, HPCAComputationPartMachine.class, HPCACoolerPartMachine.class}, (Object)hPCAComponentPartMachine2, n3)) {
                            case 0: {
                                HPCABridgePartMachine b3 = (HPCABridgePartMachine)hPCAComponentPartMachine2;
                                this.canBridge = true;
                                continue block13;
                            }
                            case 1: {
                                c = (HPCAComputationPartMachine)hPCAComponentPartMachine2;
                                if (c.isDamaged()) {
                                    n3 = 2;
                                    continue block15;
                                }
                                this.maxCWUt += c.getCWUPerTick();
                                this.coolingAmountRequired += c.getCoolingPerTick();
                                continue block13;
                            }
                            case 2: {
                                HPCACoolerPartMachine c3 = (HPCACoolerPartMachine)hPCAComponentPartMachine2;
                                this.coolingAmountProvided += c3.getCoolingAmount();
                                if (!c3.isActiveCooler()) {
                                    hpcaPassiveCoolingAmount += c3.getCoolingAmount();
                                }
                                maxCoolantAmount += c3.getMaxCoolantPerTick();
                                continue block13;
                            }
                        }
                        break;
                    }
                    continue block13;
                }
            }
        }
        if (this.coolingAmountProvided > 0 && this.coolingAmountProvided > hpcaPassiveCoolingAmount) {
            double coolantRatio = (double)maxCoolantAmount / (double)(this.coolingAmountProvided - hpcaPassiveCoolingAmount);
            int activeCoolingNeeded = Math.max(0, this.coolingAmountRequired - hpcaPassiveCoolingAmount);
            this.coolantAmount = (int)Math.ceil((double)activeCoolingNeeded * coolantRatio);
        }
        if (this.maxEUt > 0L) {
            this.runRecipe = this.machineTier == 1 ? RecipeBuilder.ofRaw().inputFluids(GTMaterials.PCBCoolant.getFluid(FluidStorageKeys.LIQUID, this.coolantAmount)).EUt(this.maxEUt / 4L).duration(20).buildRawRecipe() : RecipeBuilder.ofRaw().inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, this.coolantAmount)).outputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.GAS, this.coolantAmount)).EUt(this.maxEUt).duration(20).buildRawRecipe();
        }
        this.maxCWUtModificationSubs.initialize(this.getLevel());
        this.updateTickSubscription();
    }

    private static int getIndexForItem(Item item) {
        return ITEM_INDEX_MAP.getOrDefault(item, -1);
    }

    private void addToComponentsMap(HPCAComponentPartMachine partMachine) {
        HPCAComponentPartMachine p;
        if (partMachine instanceof HPCAComponentPartMachine && ((p = partMachine) instanceof HPCAComputationPartMachine || p instanceof HPCACoolerPartMachine || p instanceof ExResearchComputationPartMachine || p instanceof ExResearchCoolerPartMachine)) {
            if (partMachine.isDamaged()) {
                return;
            }
        } else {
            return;
        }
        this.componentsMap.addTo((Object)((IItem)partMachine.getDefinition().asItem()), 1);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (this.ThermalConductorHatchPart == null && part instanceof ThermalConductorHatchPartMachine) {
            ThermalConductorHatchPartMachine thermalConductorHatchPart;
            this.ThermalConductorHatchPart = thermalConductorHatchPart = (ThermalConductorHatchPartMachine)part;
        }
    }

    public void onMachineChanged() {
        this.machineTier = 1;
        Integer integer = MAINFRAME.get(this.getStorageStack().m_41720_());
        if (integer != null) {
            this.machineTier = integer;
        }
        this.changed(false);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.changed(false);
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.ThermalConductorHatchPart = null;
        this.maxCWUtModification = 10000;
        this.clean(false);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTickSubscription));
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    private void updateTickSubscription() {
        if (this.isFormed && !this.incompatible) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tick);
        } else if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    private void tick() {
        this.cacheCWUt = this.allocatedCWUt;
        this.allocatedCWUt = 0L;
    }

    public void afterWorking() {
        boolean dirty = false;
        if (this.coolingAmountRequired > this.coolingAmountProvided) {
            int damaged = this.coolingAmountRequired - this.coolingAmountProvided;
            for (IMultiPart part : this.getParts()) {
                HPCAComponentPartMachine componentPartMachine;
                if (part instanceof HPCAComponentPartMachine && (componentPartMachine = (HPCAComponentPartMachine)part).canBeDamaged() && !componentPartMachine.isDamaged()) {
                    damaged -= GTValues.RNG.m_188503_(256);
                    componentPartMachine.setDamaged(true);
                    dirty = true;
                }
                if (damaged <= 0) break;
            }
        }
        super.afterWorking();
        if (dirty) {
            this.changed(true);
        }
    }

    public Recipe fullModifyRecipe(Recipe recipe) {
        return recipe;
    }

    private long requestCWUt(boolean simulate, long cwu) {
        long toAllocate = Math.min(cwu, this.getAdjustedMaxCWU() - this.allocatedCWUt);
        if (!simulate) {
            this.allocatedCWUt += toAllocate;
        }
        return toAllocate;
    }

    public long requestCWU(long cwu, boolean simulate) {
        if (this.incompatible) {
            return 0L;
        }
        if (this.runRecipe != null && this.isFormed) {
            if (simulate) {
                return this.requestCWUt(true, cwu);
            }
            if (this.getRecipeLogic().isWorking()) {
                return this.requestCWUt(false, cwu);
            }
            if (!this.getRecipeLogic().isSuspend() && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)this.runRecipe) && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.runRecipe) && this.getRecipeLogic().checkMatchedRecipeAvailable((GTRecipe)this.runRecipe) && this.getRecipeLogic().isWorking()) {
                return this.requestCWUt(false, cwu);
            }
        }
        return 0L;
    }

    public long getMaxCWU() {
        return this.getAdjustedMaxCWU() - this.cacheCWUt;
    }

    private long getAdjustedMaxCWU() {
        return this.getMaxCWUt() * (long)this.maxCWUtModification / 10000L;
    }

    private void maxCWUtModificationUpdate() {
        if (this.isFormed) {
            if (this.machineTier > 1) {
                int max = this.machineTier == 2 ? 40000 : 160000;
                this.maxCWUtModification -= (int)(Math.pow(this.maxCWUtModification - 4000, 2.0) / 500000.0 * (0.8 / (Math.log(this.maxCWUtModification + 600000) - Math.log(10000.0))));
                if (this.maxCWUtModification <= max && this.ThermalConductorHatchPart != null) {
                    CustomItemStackHandler stackTransfer = this.ThermalConductorHatchPart.getInventory().storage;
                    for (int i = 0; i < stackTransfer.getSlots(); ++i) {
                        ItemStack itemStack = stackTransfer.getStackInSlot(i);
                        Item valueItem = MFPCs.get(itemStack.m_41720_());
                        if (valueItem != null) {
                            int count = itemStack.m_41613_();
                            int index = SupercomputingCenterMachine.getIndexForItem(itemStack.m_41720_());
                            int consumption = Math.min(count, (max - this.maxCWUtModification) / this.N_MFPCs[index] + 1);
                            stackTransfer.setStackInSlot(i, itemStack.m_255036_(count - consumption));
                            this.maxCWUtModification += this.N_MFPCs[index] * consumption;
                            for (int j = 0; j < stackTransfer.getSlots(); ++j) {
                                int count2;
                                if (stackTransfer.getStackInSlot(j).m_41720_() == valueItem && (count2 = stackTransfer.getStackInSlot(j).m_41613_()) + consumption <= 64) {
                                    stackTransfer.setStackInSlot(j, new ItemStack((ItemLike)valueItem, count2 + consumption));
                                    break;
                                }
                                if (!stackTransfer.getStackInSlot(j).m_41619_()) continue;
                                ItemStack convertedStack = new ItemStack((ItemLike)valueItem, consumption);
                                stackTransfer.setStackInSlot(j, convertedStack);
                                break;
                            }
                        }
                        if (this.maxCWUtModification >= max) break;
                    }
                }
                if (this.maxCWUtModification < 8000) {
                    this.maxCWUtModification = 8000;
                }
            } else {
                this.maxCWUtModification = 10000;
            }
        }
        this.maxCWUtModificationSubs.updateSubscription();
    }

    public long getMaxCWUt() {
        if (this.incompatible) {
            return 0L;
        }
        return this.maxCWUt;
    }

    public boolean canBridge() {
        if (this.incompatible) {
            return false;
        }
        return this.canBridge;
    }

    public void addDisplayText(@NotNull List<Component> textList) {
        if (this.incompatible) {
            textList.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{this.machineTier}));
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.invalid_structure").m_130940_(ChatFormatting.RED));
        } else {
            super.addDisplayText(textList);
        }
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{this.machineTier}));
        textList.add((Component)Component.m_237115_((String)(this.canBridge ? "gtceu.multiblock.hpca.info_bridging_enabled" : "gtceu.multiblock.hpca.info_bridging_disabled")).m_130940_(this.canBridge ? ChatFormatting.GREEN : ChatFormatting.RED));
        textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.energy_consumption", (Object[])new Object[]{FormattingUtil.formatNumbers((long)this.maxEUt), GTValues.VNF[GTUtil.getTierByVoltage((long)this.maxEUt)]}).m_130940_(ChatFormatting.YELLOW));
        textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.hpca.computation", (Object[])new Object[]{Component.m_237113_((String)(this.cacheCWUt + " / " + this.getAdjustedMaxCWU())).m_7220_((Component)Component.m_237113_((String)" CWU/t")).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.cwut_modification", (Object[])new Object[]{(double)this.maxCWUtModification / 10000.0}).m_130940_(ChatFormatting.AQUA));
        textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.hpca.info_max_coolant_required", (Object[])new Object[]{Component.m_237113_((String)(this.coolingAmountRequired + " / " + this.coolingAmountProvided + "  " + this.coolantAmount)).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)Component.m_237115_((String)"gtocore.machine.components_list").m_130940_(ChatFormatting.YELLOW));
        for (Reference2IntMap.Entry entries : this.componentsMap.reference2IntEntrySet()) {
            textList.add((Component)Component.m_237113_((String)" - ").m_7220_(((IItem)entries.getKey()).gtolib$getReadOnlyStack().m_41611_()).m_7220_((Component)Component.m_237113_((String)(" x" + entries.getIntValue()))).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Generated
    public void setThermalConductorHatchPart(ThermalConductorHatchPartMachine ThermalConductorHatchPart) {
        this.ThermalConductorHatchPart = ThermalConductorHatchPart;
    }

    static {
        ImmutableMap.Builder mfpcRecipe = ImmutableMap.builder();
        mfpcRecipe.put((Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.block, (Material)GTOMaterials.CascadeMFPC), (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.block, (Material)GTOMaterials.InvalidationCascadeMFPC));
        mfpcRecipe.put((Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.block, (Material)GTOMaterials.BasicMFPC), (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.block, (Material)GTOMaterials.InvalidationBasicMFPC));
        mfpcRecipe.put((Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.CascadeMFPC), (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.InvalidationCascadeMFPC));
        mfpcRecipe.put((Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.BasicMFPC), (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.InvalidationBasicMFPC));
        mfpcRecipe.put((Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.nugget, (Material)GTOMaterials.CascadeMFPC), (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.nugget, (Material)GTOMaterials.InvalidationCascadeMFPC));
        mfpcRecipe.put((Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.nugget, (Material)GTOMaterials.BasicMFPC), (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.nugget, (Material)GTOMaterials.InvalidationBasicMFPC));
        mfpcRecipe.put((Object)((Item)ModItems.ICE_SHARD.get()).m_5456_(), (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.dustTiny, (Material)GTMaterials.Ice));
        MFPCs = mfpcRecipe.build();
        ITEM_INDEX_MAP = Map.of(ChemicalHelper.getItem((TagPrefix)TagPrefix.block, (Material)GTOMaterials.CascadeMFPC), 0, ChemicalHelper.getItem((TagPrefix)TagPrefix.block, (Material)GTOMaterials.BasicMFPC), 1, ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.CascadeMFPC), 2, ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.BasicMFPC), 3, ChemicalHelper.getItem((TagPrefix)TagPrefix.nugget, (Material)GTOMaterials.CascadeMFPC), 4, ChemicalHelper.getItem((TagPrefix)TagPrefix.nugget, (Material)GTOMaterials.BasicMFPC), 5, ((Item)ModItems.ICE_SHARD.get()).m_5456_(), 6);
    }
}

