/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gtocore.common.machine.multiblock.part.DataGenerateHolderMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.ItemUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SyntheticDataAssemblyPlantMachine
extends ElectricMultiblockMachine {
    private DataGenerateHolderMachine objectHolder;

    public SyntheticDataAssemblyPlantMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof DataGenerateHolderMachine)) continue;
            DataGenerateHolderMachine scanningHolder = (DataGenerateHolderMachine)part;
            if (scanningHolder.getFrontFacing() != this.getFrontFacing().m_122424_()) {
                this.onStructureInvalid();
                return;
            }
            this.objectHolder = scanningHolder;
            this.addHandlerList(RecipeHandlerList.of((IO)IO.IN, (IRecipeHandler[])new IRecipeHandler[]{scanningHolder.getAsHandler()}));
        }
        if (this.objectHolder == null) {
            this.onStructureInvalid();
        }
    }

    public boolean checkPattern() {
        boolean isFormed = super.checkPattern();
        if (isFormed && this.objectHolder != null && this.objectHolder.getFrontFacing() != this.getFrontFacing().m_122424_()) {
            this.onStructureInvalid();
        }
        return isFormed;
    }

    public void onStructureInvalid() {
        if (this.objectHolder != null) {
            this.objectHolder.setLocked(false);
            this.objectHolder = null;
        }
        super.onStructureInvalid();
    }

    public boolean regressWhenWaiting() {
        return false;
    }

    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.work_paused", "gtocore.machine.assembling").addEnergyUsageLine((IEnergyContainer)this.energyContainer).addEnergyTierLine(this.tier).addWorkingStatusLine().addProgressLineOnlyPercent(this.recipeLogic.getProgressPercent());
    }

    public boolean matchRecipe(Recipe recipe) {
        if (this.objectHolder.getDataItem(false).m_41782_()) {
            return false;
        }
        return RecipeRunner.matchRecipeInput((IRecipeCapabilityHolder)this, (Recipe)recipe);
    }

    public boolean handleRecipeIO(Recipe originalRecipe, IO io) {
        if (io == IO.IN) {
            this.objectHolder.setLocked(true);
            return true;
        }
        if (this.getRecipeLogic().getLastRecipe() == null) {
            this.objectHolder.setLocked(false);
            return true;
        }
        ItemStack outputItem = ItemStack.f_41583_;
        List contents = this.getRecipeLogic().getLastRecipe().getOutputContents((RecipeCapability)ItemRecipeCapability.CAP);
        if (!contents.isEmpty()) {
            outputItem = ItemUtils.getFirstSized((Ingredient)((Ingredient)((Content)contents.getFirst()).content)).m_41777_();
        }
        if (!outputItem.m_41619_()) {
            this.objectHolder.setDataItem(outputItem);
        }
        this.objectHolder.setLocked(false);
        return true;
    }
}

