/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.adventure;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.MachineUtils;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public final class BossSummonerMachine
extends ElectricMultiblockMachine {
    public BossSummonerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public boolean hasOverclockConfig() {
        return false;
    }

    public boolean hasBatchConfig() {
        return false;
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        Level world = this.getLevel();
        if (world == null || world.f_46443_) {
            return;
        }
        ApothBoss item = (ApothBoss)BossRegistry.INSTANCE.getRandomItem(world.m_213780_(), (float)(this.getTier() << 2), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)world)});
        if (item == null) {
            return;
        }
        BlockPos pos = MachineUtils.getOffsetPos((int)2, (int)2, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
        if (!world.m_45772_(item.getSize().m_82338_(pos))) {
            pos = pos.m_7494_();
            if (!world.m_45772_(item.getSize().m_82338_(pos))) {
                return;
            }
        }
        Mob boss = item.createBoss((ServerLevelAccessor)((ServerLevel)world), pos, world.m_213780_(), (float)(this.getTier() << 2));
        ((ServerLevel)world).m_47205_((Entity)boss);
    }

    @Nullable
    private Recipe getRecipe() {
        Recipe recipe = this.getRecipeBuilder().duration(Math.max(5, 400 / (this.getTier() + 1))).EUt(this.getOverclockVoltage()).buildRawRecipe();
        if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }
}

