/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.assembly;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gtocore.common.machine.multiblock.part.HugeBusPartMachine;
import com.gtocore.data.IdleReason;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.MathUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdvancedAssemblyLineMachine
extends ElectricMultiblockMachine {
    private List<CustomItemStackHandler> itemStackTransfers = new ArrayList<CustomItemStackHandler>();

    public AdvancedAssemblyLineMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        FastSizedIngredient[] recipeIngredients = AdvancedAssemblyLineMachine.getRecipeIngredients((GTRecipe)recipe);
        int size = recipeIngredients.length;
        if (this.itemStackTransfers.size() < size) {
            return null;
        }
        if (!AdvancedAssemblyLineMachine.validateIngredientStacks(this, size, recipeIngredients)) {
            this.setIdleReason(IdleReason.ORDERED);
            return null;
        }
        return RecipeModifierFunction.laserLossOverclocking((MetaMachine)this, (Recipe)RecipeModifierFunction.hatchParallel((MetaMachine)this, (Recipe)recipe));
    }

    private static FastSizedIngredient[] getRecipeIngredients(GTRecipe recipe) {
        List inputs = (List)recipe.inputs.get(ItemRecipeCapability.CAP);
        FastSizedIngredient[] ingredients = new FastSizedIngredient[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            FastSizedIngredient ingredient;
            Object object = ((Content)inputs.get(i)).getContent();
            ingredients[i] = object instanceof FastSizedIngredient && !(ingredient = (FastSizedIngredient)object).m_43947_() ? ingredient : null;
        }
        return ingredients;
    }

    private static boolean validateIngredientStacks(AdvancedAssemblyLineMachine lineMachine, int size, FastSizedIngredient[] recipeIngredients) {
        ReferenceOpenHashSet itemSet = new ReferenceOpenHashSet();
        for (int i = 0; i < size; ++i) {
            FastSizedIngredient currentIngredient = recipeIngredients[i];
            if (currentIngredient == null || AdvancedAssemblyLineMachine.isValidStorage((Set<Item>)itemSet, lineMachine.itemStackTransfers.get(i), currentIngredient)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidStorage(Set<Item> itemSet, CustomItemStackHandler storage, FastSizedIngredient currentIngredient) {
        Item item = Items.f_41852_;
        itemSet.clear();
        int slots = storage.getSlots();
        for (int j = 0; j < slots; ++j) {
            Item i = storage.getStackInSlot(j).m_41720_();
            if (i == Items.f_41852_) continue;
            itemSet.add(item);
            item = i;
        }
        return itemSet.size() == 1 && currentIngredient.testItem(item);
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new AssemblyLineLogic((IRecipeLogicMachine)this);
    }

    public Comparator<IMultiPart> getPartSorter() {
        return Comparator.comparing(p -> p.self().getPos(), RelativeDirection.RIGHT.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped()));
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.itemStackTransfers = new ArrayList<CustomItemStackHandler>();
        for (IMultiPart part : this.getParts()) {
            if (part instanceof ItemBusPartMachine) {
                ItemBusPartMachine itemBusPart = (ItemBusPartMachine)part;
                this.itemStackTransfers.add(itemBusPart.getInventory().storage);
                continue;
            }
            if (!(part instanceof HugeBusPartMachine)) continue;
            HugeBusPartMachine hugeBusPartMachine = (HugeBusPartMachine)part;
            this.itemStackTransfers.add(hugeBusPartMachine.getInventory().storage);
        }
    }

    private static class AssemblyLineLogic
    extends RecipeLogic {
        private AssemblyLineLogic(IRecipeLogicMachine machine) {
            super(machine);
        }

        @NotNull
        public AdvancedAssemblyLineMachine getMachine() {
            return (AdvancedAssemblyLineMachine)super.getMachine();
        }

        protected boolean handleRecipeIO(GTRecipe recipe, IO io) {
            if (io == IO.IN) {
                if (!this.consumeOrderedItemInputs(recipe)) {
                    return false;
                }
                return RecipeRunner.handleRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)((Recipe)recipe), (IO)io, Map.of(FluidRecipeCapability.CAP, recipe.getInputContents((RecipeCapability)FluidRecipeCapability.CAP)), (Map)this.chanceCaches, (boolean)false);
            }
            return super.handleRecipeIO(recipe, io);
        }

        private boolean consumeOrderedItemInputs(GTRecipe recipe) {
            List itemInputs = recipe.inputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList());
            if (itemInputs.isEmpty()) {
                return true;
            }
            List<CustomItemStackHandler> machineInputs = this.getMachine().itemStackTransfers;
            if (machineInputs.size() < itemInputs.size()) {
                return false;
            }
            for (int i = 0; i < itemInputs.size(); ++i) {
                CustomItemStackHandler inputSlot = machineInputs.get(i);
                Ingredient recipeInput = (Ingredient)ItemRecipeCapability.CAP.of(((Content)itemInputs.get((int)i)).content);
                boolean tested = false;
                long amount = ItemUtils.getSizedAmount((Ingredient)recipeInput);
                for (int j = 0; j < inputSlot.size; ++j) {
                    ItemStack stack = inputSlot.getStackInSlot(j);
                    if (stack.m_41619_() || !tested && !recipeInput.test(stack)) continue;
                    tested = true;
                    if ((amount -= (long)inputSlot.extractItem(0, MathUtil.saturatedCast((long)amount), false).m_41613_()) <= 0L) break;
                }
                if (amount <= 0L) continue;
                return false;
            }
            return true;
        }
    }
}

