/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.bioengineering;

import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gtocore.common.machine.trait.RadioactivityTrait;
import com.gtolib.api.machine.feature.multiblock.IMultiblockTraitHolder;
import com.gtolib.api.machine.multiblock.TierCasingMultiblockMachine;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class IncubatorMachine
extends TierCasingMultiblockMachine {
    @Persisted
    private final RadioactivityTrait radioactivityTrait = new RadioactivityTrait((IMultiblockTraitHolder)this);
    private int cleanroomTier = 1;

    public IncubatorMachine(MetaMachineBlockEntity holder) {
        super(holder, new String[]{"g_b"});
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tier = Math.min(this.getCasingTier("g_b"), this.tier);
        IFilterType filterType = (IFilterType)this.getMultiblockState().getMatchContext().get((Object)"FilterType");
        if (filterType != null) {
            switch (filterType.getCleanroomType().getName()) {
                case "cleanroom": {
                    this.cleanroomTier = 1;
                    break;
                }
                case "sterile_cleanroom": {
                    this.cleanroomTier = 2;
                    break;
                }
                case "law_cleanroom": {
                    this.cleanroomTier = 3;
                }
            }
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.cleanroomTier = 1;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{this.cleanroomTier}));
    }

    protected boolean beforeWorking(Recipe recipe) {
        if (recipe.data.m_128441_("filter_casing") && recipe.data.m_128451_("filter_casing") > this.cleanroomTier) {
            this.setIdleReason(IdleReason.BLOCK_TIER_NOT_SATISFIES);
            return false;
        }
        return super.beforeWorking(recipe);
    }
}

