/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.miner;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.cover.filter.Filter;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.gui.widget.ProspectingMapWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.ItemFilterBehaviour;
import com.gtocore.integration.jade.provider.RecipeLogicProvider;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.NewDataAttributes;
import com.gtolib.api.machine.feature.IDigitalMiner;
import com.gtolib.api.machine.impl.DigitalMinerLogic;
import com.gtolib.api.machine.multiblock.TierCasingMultiblockMachine;
import com.hepdd.gtmthings.api.gui.widget.SimpleNumberInputWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Align;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@DataGeneratorScanned
public class DigitalMiner
extends TierCasingMultiblockMachine
implements IDigitalMiner {
    private static final int BORDER_WIDTH = 3;
    @Persisted
    protected final CustomItemStackHandler filterInventory;
    @Persisted
    public IDigitalMiner.FluidMode fluidMode = IDigitalMiner.FluidMode.Harvest;
    @Nullable
    protected ISubscription energySubs;
    protected Filter<?, ?> itemFilter;
    protected Filter<?, ?> fluidFilter;
    protected SlotWidget filterSlot;
    protected ButtonWidget resetButton;
    protected ButtonWidget silkButton;
    protected ButtonWidget fluidModeButton;
    protected DraggableScrollableWidgetGroup mapArea;
    @Persisted
    @DescSynced
    private int xRadialLength = 1;
    @Persisted
    @DescSynced
    private int zRadialLength = 1;
    @Persisted
    @DescSynced
    private int xOffset = 0;
    @Persisted
    @DescSynced
    private int zOffset = 0;
    @Persisted
    @DescSynced
    private int minHeight = 0;
    @Persisted
    @DescSynced
    private int maxHeight = 64;
    @Persisted
    private int silkLevel = 0;
    @DescSynced
    private long energyPerTickBase = 0L;
    @DescSynced
    private int parallelMining = 0;
    @DescSynced
    private int prospectorRadius;
    @DescSynced
    @Persisted
    private int maxRadius = 1;
    @DescSynced
    @Persisted
    private boolean showRange = false;
    private long energyPerTick;
    private ButtonWidget showRangeButton;

    public DigitalMiner(MetaMachineBlockEntity holder) {
        super(holder, new String[]{"i_f"});
        this.filterInventory = this.createFilterItemHandler();
    }

    protected CustomItemStackHandler createFilterItemHandler() {
        CustomItemStackHandler transfer = new CustomItemStackHandler();
        transfer.setFilter(item -> {
            ComponentItem componentItem;
            Item patt0$temp = item.m_41720_();
            return patt0$temp instanceof ComponentItem && (componentItem = (ComponentItem)patt0$temp).getComponents().stream().anyMatch(c -> c instanceof ItemFilterBehaviour);
        });
        return transfer;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new DigitalMinerLogic((IRecipeLogicMachine)this);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.filterChange();
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tier = Math.min(this.getCasingTier("i_f"), this.tier);
        this.energyPerTickBase = (long)((int)Math.pow(4.0, this.getTier())) * 2L;
        this.energyPerTick = this.energyPerTickBase * (long)(this.silkLevel == 0 ? 1 : 4);
        this.parallelMining = (int)Math.min(4096.0, 4.0 * Math.pow(2.0, this.getTier()));
        this.maxRadius = (int)Math.min(8.0 * Math.pow(2.0, this.getTier()), 128.0);
        this.prospectorRadius = Math.min(this.getTier() / 2 + 1, 6);
        this.resetRecipe();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.parallelMining = 0;
        this.resetRecipe();
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.filterInventory);
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (isWorkingAllowed && this.getRecipeLogic().isDone()) {
            this.getRecipeLogic().resetRecipeLogic();
        }
        super.setWorkingEnabled(isWorkingAllowed);
    }

    public IDigitalMiner.MinerConfig getMinerConfig() {
        return new IDigitalMiner.MinerConfig(this.getMinerArea(), this.energyPerTick, this.getSpeed(), this.parallelMining, this.silkLevel, this.itemFilter, this.fluidFilter, this.fluidMode);
    }

    private void resetRecipe() {
        this.setWorkingEnabled(false);
        this.getRecipeLogic().resetRecipeLogic();
    }

    private void filterChange() {
        this.itemFilter = null;
        this.fluidFilter = null;
        ItemStack stack = this.filterInventory.getStackInSlot(0);
        if (!stack.m_41619_()) {
            if (stack.m_150930_(GTItems.TAG_FLUID_FILTER.m_5456_()) || stack.m_150930_(GTItems.FLUID_FILTER.m_5456_())) {
                this.fluidFilter = FluidFilter.loadFilter((ItemStack)stack);
            } else {
                this.itemFilter = ItemFilter.loadFilter((ItemStack)this.filterInventory.getStackInSlot(0));
            }
        }
        this.resetRecipe();
    }

    private void reset(ClickData clickData) {
        this.resetRecipe();
    }

    private void setSilk(ClickData clickData) {
        if (this.silkLevel == 0) {
            this.silkLevel = 1;
            this.silkButton.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(Component.m_237115_((String)"gtocore.digital_miner.silk").getString()).setDropShadow(false).setColor(ChatFormatting.GREEN.m_126665_().intValue())});
            this.energyPerTick = this.energyPerTickBase * 4L;
        } else {
            this.silkLevel = 0;
            this.silkButton.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(Component.m_237115_((String)"gtocore.digital_miner.silk").getString()).setDropShadow(false).setColor(ChatFormatting.GRAY.m_126665_().intValue())});
            this.energyPerTick = this.energyPerTickBase;
        }
        this.resetRecipe();
    }

    public boolean drainInput(boolean simulate) {
        EnergyContainerList energyContainer = this.getEnergyContainer();
        long resultEnergy = energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    public Widget createUIWidget() {
        int rowSize = 3;
        int colSize = 9;
        int width = colSize * 18 + 16 + 90 + 54;
        int height = rowSize * 18 + 76 + 4;
        WidgetGroup group = new WidgetGroup(0, 0, width, height);
        WidgetGroup container = new WidgetGroup(8, 66, 87, 76);
        DraggableScrollableWidgetGroup componentPanel = new DraggableScrollableWidgetGroup();
        container.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, container.getSize().width - 8, container.getSize().height - 8).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)componentPanel));
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        WidgetGroup slots = new WidgetGroup(8, 78, colSize * 18, rowSize * 18);
        group.addWidget((Widget)slots);
        ComponentPanelWidget componentPanel2 = new ComponentPanelWidget(4, 5, this::addDisplayText);
        DraggableScrollableWidgetGroup container2 = new DraggableScrollableWidgetGroup(8, 0, 87, 60);
        container2.addWidget(new WidgetGroup(4, 4, 160, 80).addWidget((Widget)componentPanel2).setBackground(new IGuiTexture[]{GuiTextures.DISPLAY}));
        container2.setBackground((IGuiTexture)GuiTextures.BACKGROUND_INVERSE);
        container2.setYScrollBarWidth(3).setYBarStyle((IGuiTexture)GuiTextures.BACKGROUND_INVERSE, (IGuiTexture)GuiTextures.BUTTON);
        container2.setXScrollBarHeight(3).setXBarStyle((IGuiTexture)GuiTextures.BACKGROUND_INVERSE, (IGuiTexture)GuiTextures.BUTTON);
        group.addWidget((Widget)container2);
        this.filterSlot = new SlotWidget((IItemHandlerModifiable)this.filterInventory, 0, 152, 0, true, true);
        this.filterSlot.setChangeListener(this::filterChange).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY});
        group.addWidget((Widget)this.filterSlot);
        group.addWidget(new LabelWidget(103, 4, (Component)Component.m_237115_((String)"gtocore.machine.monitor.ae.set_filter")).setClientSideWidget());
        int x1 = 103;
        int x2 = x1 + 41;
        int i = 0;
        group.addWidget(new LabelWidget(x1, 26 + i * 18, (Component)Component.m_237115_((String)"gtocore.digital_miner.x_radial_length")).setClientSideWidget());
        group.addWidget((Widget)new SimpleNumberInputWidget(x2, 24 + i++ * 18, 32, 12, this::getMinerXRadius, this::setMinerXRadius).setMin(0).setMax(this.maxRadius * 2 + 1));
        group.addWidget(new LabelWidget(x1, 26 + i * 18, (Component)Component.m_237115_((String)"gtocore.digital_miner.z_radial_length")).setClientSideWidget());
        group.addWidget((Widget)new SimpleNumberInputWidget(x2, 24 + i++ * 18, 32, 12, this::getMinerZRadius, this::setMinerZRadius).setMin(0).setMax(this.maxRadius * 2 + 1));
        group.addWidget(new LabelWidget(x1, 26 + i * 18, (Component)Component.m_237115_((String)"gtocore.digital_miner.x_offset")).setClientSideWidget());
        group.addWidget((Widget)new SimpleNumberInputWidget(x2, 24 + i++ * 18, 32, 12, this::getXOffset, v -> {
            this.xOffset = Math.abs(v) <= this.maxRadius ? v : (v > 0 ? this.maxRadius : -this.maxRadius);
        }).setMin(-this.maxRadius).setMax(this.maxRadius));
        group.addWidget(new LabelWidget(x1, 26 + i * 18, (Component)Component.m_237115_((String)"gtocore.digital_miner.z_offset")).setClientSideWidget());
        group.addWidget((Widget)new SimpleNumberInputWidget(x2, 24 + i++ * 18, 32, 12, this::getZOffset, v -> {
            this.zOffset = Math.abs(v) <= this.maxRadius ? v : (v > 0 ? this.maxRadius : -this.maxRadius);
        }).setMin(-this.maxRadius).setMax(this.maxRadius));
        group.addWidget(new LabelWidget(x1, 26 + i * 18, (Component)Component.m_237115_((String)"gtocore.digital_miner.min_height")).setClientSideWidget());
        group.addWidget((Widget)new SimpleNumberInputWidget(x2, 24 + i++ * 18, 32, 12, this::getMinHeight, this::setMinHeight).setMin(this.getLevel().m_141937_()).setMax(this.getLevel().m_151558_()));
        group.addWidget(new LabelWidget(x1, 26 + i * 18, (Component)Component.m_237115_((String)"gtocore.digital_miner.max_height")).setClientSideWidget());
        group.addWidget((Widget)new SimpleNumberInputWidget(x2, 24 + i * 18, 32, 12, this::getMaxHeight, this::setMaxHeight).setMin(this.getLevel().m_141937_()).setMax(this.getLevel().m_151558_()));
        this.silkButton = new ButtonWidget(7, 8, 72, 13, this::setSilk);
        this.silkButton.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.digital_miner.silk.tooltip")});
        container.addWidget(this.silkButton.setBackground(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(Component.m_237115_((String)"gtocore.digital_miner.silk").getString()).setDropShadow(false).setColor((this.silkLevel == 0 ? ChatFormatting.GRAY.m_126665_() : ChatFormatting.GREEN.m_126665_()).intValue())}));
        this.fluidModeButton = new ButtonWidget(7, 23, 72, 13, cd -> {
            this.fluidMode = this.fluidMode.next();
            this.fluidModeButton.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(this.fluidMode.getTitle()).setDropShadow(false).setColor(this.fluidMode.color.m_126665_().intValue())}).setHoverTooltips(new String[]{this.fluidMode.getTooltip()});
            this.resetRecipe();
        });
        this.fluidModeButton.setHoverTooltips(new String[]{this.fluidMode.getTooltip()});
        container.addWidget(this.fluidModeButton.setBackground(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(this.fluidMode.getTitle()).setDropShadow(false).setColor(this.fluidMode.color.m_126665_().intValue())}));
        this.resetButton = new ButtonWidget(7, 38, 72, 13, this::reset);
        this.resetButton.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.digital_miner.reset.tooltip")});
        container.addWidget(this.resetButton.setBackground(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(Component.m_237115_((String)"gtocore.digital_miner.reset").getString()).setDropShadow(false).setColor(ChatFormatting.GRAY.m_126665_().intValue())}));
        this.showRangeButton = new ButtonWidget(7, 53, 72, 13, cd -> {
            this.showRange = !this.showRange;
            this.showRangeButton.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(Component.m_237115_((String)"gtocore.digital_miner.show_range").getString()).setDropShadow(false).setColor((this.showRange ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.GRAY.m_126665_()).intValue())});
        });
        this.showRangeButton.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.digital_miner.show_range.tooltip")});
        container.addWidget(this.showRangeButton.setBackground(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture(Component.m_237115_((String)"gtocore.digital_miner.show_range").getString()).setDropShadow(false).setColor((this.showRange ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.GRAY.m_126665_()).intValue())}));
        this.mapArea = new DraggableScrollableWidgetGroup(180, 4, 134, 134).setBackground((IGuiTexture)GuiTextures.PRIMITIVE_BACKGROUND);
        if (this.isFormed()) {
            group.addWidget((Widget)this.mapArea.addWidget((Widget)new WidgetGroup(1, 1, (this.prospectorRadius * 2 - 1) * 16 + 13, (this.prospectorRadius * 2 - 1) * 16 + 21).addWidget((Widget)new ProspectorMap(4, 4, (this.prospectorRadius * 2 - 1) * 16 + 12, (this.prospectorRadius * 2 - 1) * 16 + 20, this.prospectorRadius, ProspectorMode.ORE, 1, (Widget)group))));
            this.mapArea.setYScrollBarWidth(3).setYBarStyle((IGuiTexture)GuiTextures.BACKGROUND_INVERSE, (IGuiTexture)GuiTextures.BUTTON);
            this.mapArea.setXScrollBarHeight(3).setXBarStyle((IGuiTexture)GuiTextures.BACKGROUND_INVERSE, (IGuiTexture)GuiTextures.BUTTON);
        } else {
            group.addWidget((Widget)this.mapArea);
            this.mapArea.addWidget(new LabelWidget(0, 0, (Component)Component.m_237115_((String)"gtceu.top.invalid_structure").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))).setClientSideWidget().setAlign(Align.CENTER));
        }
        return group;
    }

    public void addDisplayText(List<Component> textList) {
        textList.add((Component)Component.m_237115_((String)"gtocore.digital_miner.to_be_mined").m_130946_(String.valueOf(this.getRecipeLogic().getOreAmount())));
        if (!this.isFormed()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.top.invalid_structure").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        if (this.getRecipeLogic().isDone()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.done").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        } else if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.working").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        } else if (!this.isWorkingEnabled()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
        }
        if (this.getRecipeLogic().isInventoryFull()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.invfull").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        if (!this.drainInput(true)) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.needspower").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        textList.addAll(NewDataAttributes.LEVEL.create((Object)this.tier).get());
        RecipeLogicProvider.getEUtTooltip(textList, this.energyPerTick, false);
        textList.add((Component)Component.m_237110_((String)"gtocore.miner.parallel", (Object[])new Object[]{this.parallelMining}));
    }

    public boolean canConnectRedstone(Direction side) {
        return side == this.getFrontFacing() || side == Direction.DOWN || super.canConnectRedstone(side);
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        if (this.getLevel().m_276867_(fromPos)) {
            this.setWorkingEnabled(true);
        }
    }

    public int getMinerXRadius() {
        return this.xRadialLength;
    }

    public void setMinerXRadius(int minerRadius) {
        this.xRadialLength = minerRadius;
    }

    public int getMinerZRadius() {
        return this.zRadialLength;
    }

    public void setMinerZRadius(int minerRadius) {
        this.zRadialLength = minerRadius;
    }

    public DigitalMinerLogic getRecipeLogic() {
        return (DigitalMinerLogic)super.getRecipeLogic();
    }

    public int getSpeed() {
        return 40;
    }

    public AABB getMinerArea() {
        if (this.xRadialLength > this.maxRadius * 2 + 1) {
            this.xRadialLength = this.maxRadius * 2 + 1;
        }
        if (this.zRadialLength > this.maxRadius * 2 + 1) {
            this.zRadialLength = this.maxRadius * 2 + 1;
        }
        if (this.minHeight > this.maxHeight) {
            int temp = this.minHeight;
            this.minHeight = this.maxHeight;
            this.maxHeight = temp;
        }
        BlockPos pos = this.getPos();
        BlockPos pos1 = pos.m_7918_(this.xOffset, 0, this.zOffset).m_175288_(this.minHeight);
        BlockPos pos2 = pos1.m_7918_(this.xRadialLength, 0, this.zRadialLength).m_175288_(this.maxHeight);
        return new AABB(pos1, pos2);
    }

    @Generated
    public int getXOffset() {
        return this.xOffset;
    }

    @Generated
    public int getZOffset() {
        return this.zOffset;
    }

    @Generated
    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    @Generated
    public int getMinHeight() {
        return this.minHeight;
    }

    @Generated
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Generated
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Generated
    public int getSilkLevel() {
        return this.silkLevel;
    }

    @Generated
    public int getParallelMining() {
        return this.parallelMining;
    }

    @Generated
    public boolean isShowRange() {
        return this.showRange;
    }

    @Generated
    public long getEnergyPerTick() {
        return this.energyPerTick;
    }

    private class ProspectorMap
    extends ProspectingMapWidget {
        final Widget parent;
        boolean isDragging;
        double startX;
        double startY;
        double lastX;
        double lastY;
        ProspectingMapWidget.WaypointItem startWaypoint;

        ProspectorMap(int x, int y, int width, int height, int radius, ProspectorMode mode, int scale, Widget parent) {
            super(x, y, width, height, radius, mode, scale);
            this.isDragging = false;
            this.startX = 0.0;
            this.startY = 0.0;
            this.lastX = 0.0;
            this.lastY = 0.0;
            this.startWaypoint = null;
            this.parent = parent;
            this.itemList.setVisible(false).setActive(false);
            this.getContainedWidgets(false).stream().filter(w -> !(w instanceof ImageWidget)).forEach(w -> w.setVisible(false).setActive(false));
            this.getContainedWidgets(false).stream().filter(w -> w instanceof ImageWidget).forEach(w -> {
                w.setSelfPosition(0, 0);
                w.setSize((radius * 2 - 1) * 16 + 8, (radius * 2 - 1) * 16 + 16);
            });
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button2) {
            ProspectingMapWidget.WaypointItem clickedItem = this.getClickedVein(mouseX, mouseY);
            if (clickedItem == null) {
                return super.mouseClicked(mouseX, mouseY, button2);
            }
            this.startWaypoint = clickedItem;
            this.isDragging = true;
            this.startX = mouseX;
            this.startY = mouseY;
            this.lastX = mouseX;
            this.lastY = mouseY;
            return true;
        }

        public void drawInForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            graphics.m_280509_((int)this.startX, (int)this.startY, (int)this.lastX, (int)this.lastY, -2130706433);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button2, double dragX, double dragY) {
            if (this.isDragging && this.startWaypoint != null) {
                this.lastX = mouseX;
                this.lastY = mouseY;
            }
            return super.mouseDragged(mouseX, mouseY, button2, dragX, dragY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button2) {
            if (this.isDragging && this.startWaypoint != null) {
                this.isDragging = false;
                ProspectingMapWidget.WaypointItem endWaypoint = this.getClickedVein(mouseX, mouseY);
                if (endWaypoint != null && endWaypoint != this.startWaypoint) {
                    BlockPos startBlockPos = this.startWaypoint.position();
                    BlockPos endBlockPos = endWaypoint.position();
                    int xOffset = Math.min(startBlockPos.m_123341_(), endBlockPos.m_123341_()) - DigitalMiner.this.getPos().m_123341_();
                    int zOffset = Math.min(startBlockPos.m_123343_(), endBlockPos.m_123343_()) - DigitalMiner.this.getPos().m_123343_();
                    int xRadialLength = Math.abs(startBlockPos.m_123341_() - endBlockPos.m_123341_());
                    int zRadialLength = Math.abs(startBlockPos.m_123343_() - endBlockPos.m_123343_());
                    if (xRadialLength > DigitalMiner.this.maxRadius * 2 + 1) {
                        xRadialLength = DigitalMiner.this.maxRadius * 2 + 1;
                    }
                    if (zRadialLength > DigitalMiner.this.maxRadius * 2 + 1) {
                        zRadialLength = DigitalMiner.this.maxRadius * 2 + 1;
                    }
                    if (Math.abs(xOffset) > DigitalMiner.this.maxRadius) {
                        int n = xOffset = xOffset > 0 ? DigitalMiner.this.maxRadius : -DigitalMiner.this.maxRadius;
                    }
                    if (Math.abs(zOffset) > DigitalMiner.this.maxRadius) {
                        zOffset = zOffset > 0 ? DigitalMiner.this.maxRadius : -DigitalMiner.this.maxRadius;
                    }
                    int finalXOffset = xOffset;
                    int finalZOffset = zOffset;
                    int finalXRadialLength = xRadialLength;
                    int finalZRadialLength = zRadialLength;
                    this.writeClientAction(16, buf -> {
                        buf.writeInt(finalXOffset);
                        buf.writeInt(finalZOffset);
                        buf.writeInt(finalXRadialLength);
                        buf.writeInt(finalZRadialLength);
                    });
                    this.startWaypoint = null;
                    return true;
                }
            }
            return super.mouseReleased(mouseX, mouseY, button2);
        }

        public void handleClientAction(int id, FriendlyByteBuf buffer) {
            if (id == 16) {
                DigitalMiner.this.xOffset = buffer.readInt();
                DigitalMiner.this.zOffset = buffer.readInt();
                DigitalMiner.this.xRadialLength = buffer.readInt();
                DigitalMiner.this.zRadialLength = buffer.readInt();
                DigitalMiner.this.resetRecipe();
                this.parent.detectAndSendChanges();
                return;
            }
            super.readUpdateInfo(id, buffer);
        }
    }
}

