/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.nano;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.machines.MultiBlockC;
import com.gtolib.api.machine.feature.multiblock.IStorageMultiblock;
import com.gtolib.api.machine.multiblock.CoilCrossRecipeMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public final class NanitesIntegratedMachine
extends CoilCrossRecipeMultiblockMachine
implements IStorageMultiblock {
    private static final Int2ObjectOpenHashMap<MachineDefinition> MODULE_MAP = new Int2ObjectOpenHashMap();
    private static final Map<Material, Float> MATERIAL_MAP;
    private static final Map<Material, Integer> MATERIAL_TIER_MAP;
    int chance;
    final IntOpenHashSet module = new IntOpenHashSet();
    @DescSynced
    @Persisted
    private final NotifiableItemStackHandler machineStorage = this.createMachineStorage(i -> {
        MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)i.m_41720_());
        return entry.tagPrefix() == GTOTagPrefix.NANITES && MATERIAL_MAP.containsKey(entry.material());
    });

    public NanitesIntegratedMachine(MetaMachineBlockEntity holder) {
        super(holder, false, true, false, true, MachineUtils::getHatchParallel);
    }

    public void onMachineChanged() {
        if (this.isEmpty()) {
            this.chance = 0;
            return;
        }
        Material material = ChemicalHelper.getMaterialEntry((ItemLike)this.getStorageStack().m_41720_()).material();
        if (MATERIAL_TIER_MAP.get(material) > this.getTier()) {
            return;
        }
        this.chance = (int)((float)this.getStorageStack().m_41613_() * MATERIAL_MAP.get(material).floatValue());
    }

    static void trimRecipe(GTRecipe recipe, int chance) {
        if (GTValues.RNG.m_188503_(100) < chance) {
            ArrayList input = new ArrayList((Collection)recipe.inputs.get(ItemRecipeCapability.CAP));
            input.removeFirst();
            ArrayList output = new ArrayList((Collection)recipe.outputs.get(ItemRecipeCapability.CAP));
            output.removeFirst();
            recipe.inputs.put(ItemRecipeCapability.CAP, input);
            recipe.outputs.put(ItemRecipeCapability.CAP, output);
        }
    }

    public Recipe fullModifyRecipe(@NotNull Recipe recipe) {
        if (this.module.contains(recipe.data.m_128451_("module")) && (recipe = super.fullModifyRecipe(recipe)) != null) {
            NanitesIntegratedMachine.trimRecipe((GTRecipe)recipe, this.chance);
            return recipe;
        }
        return null;
    }

    public void onStructureFormed() {
        this.module.clear();
        super.onStructureFormed();
        this.onMachineChanged();
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"tooltip.emi.chance.consume", (Object[])new Object[]{Math.max(100 - this.chance, 0)}));
        textList.add((Component)Component.m_237110_((String)"gui.ae2.AttachedTo", (Object[])new Object[]{""}));
        this.module.forEach(i -> textList.add((Component)Component.m_237115_((String)((MachineDefinition)MODULE_MAP.get(i)).getDescriptionId())));
    }

    @NotNull
    public Widget createUIWidget() {
        return this.createUIWidget(super.createUIWidget());
    }

    public NotifiableItemStackHandler getMachineStorage() {
        return this.machineStorage;
    }

    static {
        MODULE_MAP.put(1, (Object)MultiBlockC.ORE_EXTRACTION_MODULE);
        MODULE_MAP.put(2, (Object)MultiBlockC.BIOENGINEERING_MODULE);
        MODULE_MAP.put(3, (Object)MultiBlockC.POLYMER_TWISTING_MODULE);
        MATERIAL_MAP = Map.of(GTMaterials.Iron, Float.valueOf(1.0f), GTMaterials.Iridium, Float.valueOf(1.1f), GTOMaterials.Orichalcum, Float.valueOf(1.2f), GTOMaterials.Infuscolium, Float.valueOf(1.3f), GTOMaterials.Draconium, Float.valueOf(1.4f), GTOMaterials.CosmicNeutronium, Float.valueOf(1.5f), GTOMaterials.Eternity, Float.valueOf(1.6f));
        MATERIAL_TIER_MAP = Map.of(GTMaterials.Iron, 7, GTMaterials.Iridium, 8, GTOMaterials.Orichalcum, 9, GTOMaterials.Infuscolium, 10, GTOMaterials.Draconium, 11, GTOMaterials.CosmicNeutronium, 12, GTOMaterials.Eternity, 13);
    }
}

