/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.nano;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiModule;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.machine.multiblock.electric.nano.NanitesIntegratedMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public final class NanitesModuleMachine
extends ElectricMultiblockMachine
implements IMultiModule<NanitesIntegratedMachine> {
    private NanitesIntegratedMachine controller;
    private final int type;

    public NanitesModuleMachine(MetaMachineBlockEntity holder, int type) {
        super(holder);
        this.type = type;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        if (this.controller != null) {
            this.controller.module.add(this.type);
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        if (this.controller != null) {
            this.controller.module.remove(this.type);
        }
    }

    public Recipe fullModifyRecipe(@NotNull Recipe recipe) {
        if (this.controller == null) {
            return null;
        }
        if ((recipe = super.fullModifyRecipe(recipe)) != null) {
            NanitesIntegratedMachine.trimRecipe((GTRecipe)recipe, this.controller.chance);
            return recipe;
        }
        return null;
    }

    public boolean beforeWorking(@NotNull Recipe recipe) {
        if (this.controller == null || recipe.data.m_128451_("ebf_temp") > this.controller.getTemperature() || recipe.data.m_128451_("module") != this.type) {
            return false;
        }
        return super.beforeWorking(recipe);
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        if (this.controller != null) {
            textList.add((Component)Component.m_237110_((String)"tooltip.emi.chance.consume", (Object[])new Object[]{100 - this.controller.chance}));
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{Component.m_237115_((String)(FormattingUtil.formatNumbers((int)this.controller.getTemperature()) + "K")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))}));
        }
    }

    public void setController(NanitesIntegratedMachine controller) {
        this.controller = controller;
        if (this.isFormed && controller != null) {
            controller.module.add(this.type);
        }
    }

    @Generated
    public NanitesIntegratedMachine getController() {
        return this.controller;
    }
}

