/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.processing;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gtolib.api.item.MachineItemStackHandler;
import com.gtolib.api.machine.feature.multiblock.IArrayMachine;
import com.gtolib.api.machine.feature.multiblock.IParallelMachine;
import com.gtolib.api.machine.multiblock.TierCasingMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ProcessingArrayMachine
extends TierCasingMultiblockMachine
implements IParallelMachine,
IArrayMachine {
    private MachineDefinition machineDefinitionCache;
    private GTRecipeType[] RecipeTypeCache;
    @DescSynced
    @Persisted
    private final NotifiableItemStackHandler inventory;
    private final int arrayTier;

    public ProcessingArrayMachine(MetaMachineBlockEntity holder, int tier) {
        super(holder, new String[]{"g_b"});
        this.arrayTier = tier;
        this.inventory = this.createMachineStorage();
    }

    private NotifiableItemStackHandler createMachineStorage() {
        NotifiableItemStackHandler storage = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.BOTH, slots -> new MachineItemStackHandler(() -> ProcessingArrayMachine.getMachineLimit(this.arrayTier)));
        storage.setFilter(i -> ProcessingArrayMachine.storageFilter(i, this.getCasingTier("g_b")));
        storage.addChangedListener(() -> ((ProcessingArrayMachine)this).onStorageChanged());
        return storage;
    }

    static boolean storageFilter(ItemStack itemStack, int tier) {
        Item item = itemStack.m_41720_();
        if (item instanceof MetaMachineItem) {
            MetaMachineItem metaMachineItem = (MetaMachineItem)item;
            MachineDefinition definition = metaMachineItem.getDefinition();
            if (definition instanceof MultiblockMachineDefinition) {
                return false;
            }
            if (definition.getTier() > tier) {
                return false;
            }
            GTRecipeType[] recipeTypes = definition.getRecipeTypes();
            if (recipeTypes != null && recipeTypes.length == 1) {
                return "electric".equals(recipeTypes[0].group);
            }
        }
        return false;
    }

    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes();
    }

    public RecipeType getRecipeType() {
        return (RecipeType)this.recipeTypes()[this.getActiveRecipeType()];
    }

    public int getTier() {
        MachineDefinition definition = this.getMachineDefinition();
        return Math.min(definition == null ? 0 : definition.getTier(), this.tier);
    }

    protected boolean beforeWorking(Recipe recipe) {
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            return false;
        }
        return super.beforeWorking(recipe);
    }

    @Nullable
    public Recipe getRealRecipe(Recipe recipe) {
        if (!this.inventory.getStackInSlot(0).m_41619_()) {
            return RecipeModifierFunction.laserLossOverclocking((MetaMachine)this, (Recipe)ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)this.getMaxParallel()));
        }
        return null;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        MachineUtils.addRecipeTypeText(textList, (IRecipeLogicMachine)this);
    }

    public static Block getCasingState(int tier) {
        return tier == 5 ? (Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get() : (Block)GTBlocks.CASING_HSSE_STURDY.get();
    }

    public static int getMachineLimit(Integer tier) {
        return tier == 5 ? 16 : 64;
    }

    public long getMaxParallel() {
        return Math.min(ProcessingArrayMachine.getMachineLimit(this.arrayTier), Math.max(1, this.inventory.getStackInSlot(0).m_41613_()));
    }

    public Item getStorageItem() {
        return this.inventory.getStackInSlot(0).m_41720_();
    }

    public void setMachineDefinitionCache(MachineDefinition machineDefinitionCache) {
        this.machineDefinitionCache = machineDefinitionCache;
    }

    public MachineDefinition getMachineDefinitionCache() {
        return this.machineDefinitionCache;
    }

    public void setRecipeTypeCache(GTRecipeType[] RecipeTypeCache) {
        this.RecipeTypeCache = RecipeTypeCache;
    }

    public GTRecipeType[] getRecipeTypeCache() {
        return this.RecipeTypeCache;
    }

    @Generated
    public NotifiableItemStackHandler getInventory() {
        return this.inventory;
    }
}

