/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.smelter;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.block.CoilType;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.machine.multiblock.CoilCrossRecipeMultiblockMachine;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.MachineUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public final class DimensionallyTranscendentPlasmaForgeMachine
extends CoilCrossRecipeMultiblockMachine {
    public DimensionallyTranscendentPlasmaForgeMachine(MetaMachineBlockEntity holder) {
        super(holder, false, true, false, false, MachineUtils::getHatchParallel);
    }

    public int getTemperature() {
        return this.getCoilType() == CoilType.URUIUM ? 32000 : super.getTemperature();
    }

    public Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (recipe.getType() == GTORecipeTypes.STELLAR_FORGE_RECIPES) {
            if (this.getCoilType() != CoilType.URUIUM) {
                this.getEnhancedRecipeLogic().gtolib$setIdleReason((Component)Component.m_237115_((String)"gtocore.machine.dimensionally_transcendent_plasma_forge.coil"));
                return null;
            }
        } else if (recipe.data.m_128451_("ebf_temp") > this.getTemperature()) {
            this.setIdleReason(IdleReason.INSUFFICIENT_TEMPERATURE);
            return null;
        }
        return super.getRealRecipe(recipe);
    }

    public void customText(@NotNull List<Component> textList) {
        textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{Component.m_237113_((String)(FormattingUtil.formatNumbers((int)this.getTemperature()) + "K")).m_130940_(ChatFormatting.BLUE)}));
        if (this.getRecipeType() == GTORecipeTypes.STELLAR_FORGE_RECIPES && this.getCoilType() != CoilType.URUIUM) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.dimensionally_transcendent_plasma_forge.coil").m_130940_(ChatFormatting.RED));
        }
    }
}

