/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion;

import com.fast.fastcollection.O2IOpenCacheHashMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.machine.multiblock.electric.space.SpaceElevatorMachine;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.Extension;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.ISpaceServiceMachine;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.capability.IIWirelessInteractor;
import com.gtolib.utils.MathUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public class SpaceElevatorConnectorModule
extends Extension
implements ISpaceServiceMachine,
IIWirelessInteractor.IWirelessProvider {
    private final Map<SpaceElevatorMachine, Integer> elevatorTiers = new O2IOpenCacheHashMap();
    @DescSynced
    private int maxTier = 0;
    @DescSynced
    protected double high = 15.0;
    @RegisterLanguage(cn="\u5df2\u8fde\u63a5\u5230\u592a\u7a7a\u7535\u68af\uff0c\u52a8\u529b\u6a21\u5757\u6700\u9ad8\u7b49\u7ea7: %s", en="Connected to Space Elevator, Max Power Module Tier: %s")
    public static final String SPACE_ELEVATOR_CONNECTED_TEXT = "spacestation.space_elevator.connected";
    @RegisterLanguage(cn="\u5df2\u8fde\u63a5\u5230\u5f53\u524d\u661f\u7403\u7684\u7a7a\u95f4\u7ad9\uff0c\u53ef\u4f7f\u7528\u8017\u65f6\u500d\u7387: x%s", en="Connected to Space Station of Current Planet, Usable Time Cost Multiplier: x%s")
    public static final String SPACE_ELEVATOR_CONNECTED_CURRENT_PLANET_TEXT = "spacestation.space_elevator.connected_current_planet";
    @RegisterLanguage(cn="\u53ef\u83b7\u5f97\u7684\u8017\u65f6\u500d\u7387\u589e\u76ca: x%s", en="Time Cost Multiplier Gain: x%s")
    public static final String SPACE_ELEVATOR_TIME_COST_MULTIPLIER_TEXT = "spacestation.space_elevator.time_cost_multiplier";
    @RegisterLanguage(cn="\u672a\u8fde\u63a5\u5230\u592a\u7a7a\u7535\u68af", en="Not Connected to Space Elevator")
    public static final String SPACE_ELEVATOR_NOT_CONNECTED_TEXT = "spacestation.space_elevator.not_connected";
    @RegisterLanguage(cn="\u672a\u8fde\u63a5\u5230\u5f53\u524d\u661f\u7403\u7684\u7a7a\u95f4\u7ad9", en="Not Connected to Space Station of Current Planet")
    public static final String SPACE_ELEVATOR_NOT_CONNECTED_CURRENT_PLANET_TEXT = "spacestation.space_elevator.not_connected_current_planet";

    public SpaceElevatorConnectorModule(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity);
    }

    @Override
    public Set<BlockPos> getModulePositions() {
        BlockPos pos = this.getPos();
        Direction fFacing = this.getFrontFacing();
        BlockPos hallwayCenter = pos.m_5484_(fFacing, 2).m_5484_(Direction.DOWN, 15);
        return Set.of(hallwayCenter.m_5484_(Direction.EAST, 2), hallwayCenter.m_5484_(Direction.WEST, 2), hallwayCenter.m_5484_(Direction.SOUTH, 2), hallwayCenter.m_5484_(Direction.NORTH, 2));
    }

    public void registerElevator(SpaceElevatorMachine elevatorMachine, int tier) {
        this.elevatorTiers.put(elevatorMachine, tier);
        if (tier > this.maxTier) {
            this.maxTier = tier;
        }
        this.requestSync();
    }

    public void unregisterElevator(SpaceElevatorMachine elevatorMachine) {
        Integer removedTier = this.elevatorTiers.remove((Object)elevatorMachine);
        if (removedTier != null && removedTier == this.maxTier) {
            this.maxTier = this.elevatorTiers.values().stream().max(Integer::compareTo).orElse(0);
        }
        this.requestSync();
    }

    public double getDurationMultiplier() {
        if (!this.isWorkspaceReady()) {
            return 1.0;
        }
        if (this.maxTier <= 0) {
            return 1.0;
        }
        return Math.pow(0.8f, this.maxTier);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        IIWirelessInteractor.removeFromNet((Object)this);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        IIWirelessInteractor.addToNet((Object)this);
    }

    @Override
    public void onStructureInvalid() {
        IIWirelessInteractor.removeFromNet((Object)this);
        this.elevatorTiers.clear();
        this.maxTier = 0;
        super.onStructureInvalid();
        IIWirelessInteractor.removeFromNet((Object)this);
    }

    @Override
    public void customText(@NotNull List<Component> list) {
        super.customText(list);
        if (this.maxTier > 0) {
            list.add((Component)Component.m_237110_((String)SPACE_ELEVATOR_CONNECTED_TEXT, (Object[])new Object[]{this.maxTier}));
            list.add((Component)Component.m_237110_((String)SPACE_ELEVATOR_TIME_COST_MULTIPLIER_TEXT, (Object[])new Object[]{FormattingUtil.formatNumber2Places((double)this.getDurationMultiplier())}));
        } else {
            list.add((Component)Component.m_237115_((String)SPACE_ELEVATOR_NOT_CONNECTED_TEXT));
        }
    }

    @Override
    public long getEUt() {
        return GTValues.VA[9];
    }

    public void clientTick() {
        super.clientTick();
        if (this.maxTier > 0) {
            this.high = 480.0f + 480.0f * MathUtil.sin((float)((float)((double)((float)this.getOffsetTimer() / 240.0f) + Math.PI))) + 15.0f;
        }
    }

    @Generated
    public int getMaxTier() {
        return this.maxTier;
    }

    @Generated
    public double getHigh() {
        return this.high;
    }
}

