/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.LaserHatchPartMachine;
import com.gtolib.api.machine.impl.part.WirelessEnergyHatchPartMachine;
import com.gtolib.api.machine.multiblock.TierCasingMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MagneticFluidGeneratorMachine
extends TierCasingMultiblockMachine {
    private int outputTier = 0;
    private boolean laser;
    private int base = 2;

    public MagneticFluidGeneratorMachine(MetaMachineBlockEntity holder) {
        super(holder, new String[]{"g_b"});
    }

    public void onPartScan(@NotNull IMultiPart part) {
        super.onPartScan(part);
        if (this.outputTier > 0) {
            return;
        }
        if (part instanceof LaserHatchPartMachine) {
            LaserHatchPartMachine laserHatchPartMachine = (LaserHatchPartMachine)part;
            this.outputTier = laserHatchPartMachine.getTier();
            this.laser = true;
        } else if (part instanceof EnergyHatchPartMachine || part instanceof WirelessEnergyHatchPartMachine) {
            this.outputTier = ((ITieredMachine)part).getTier();
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        int tier = this.getCasingTier("g_b");
        if (tier < this.outputTier) {
            this.outputTier = 0;
        }
        if (this.getSubFormedAmount() > 0) {
            this.base = 4;
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.outputTier = 0;
        this.laser = false;
        this.base = 2;
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (this.outputTier < 1) {
            return null;
        }
        return RecipeModifierFunction.generatorOverclocking((MetaMachine)this, (Recipe)ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)(this.laser ? (long)Math.pow(this.base, this.outputTier - 1) : 1L)));
    }
}

