/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.fast.fastcollection.OpenCacheHashSet;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.ICoilMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiPart;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.common.machine.multiblock.part.RotorHolderPartMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.part.ItemPartMachine;
import com.gtolib.api.machine.trait.CoilTrait;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.hepdd.gtmthings.utils.FormatUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Scanned
public class TurbineMachine
extends ElectricMultiblockMachine {
    @DynamicInitialValue(key="gtocore.machine.mega_turbine.high_speed_mode_output_multiplier", typeKey="multiplier", easyValue="4.0F", normalValue="3.0F", expertValue="2.5F", cn="\u9ad8\u901f\u6a21\u5f0f\u8f93\u51fa\u500d\u7387 : %s \u500d", en="High Speed Mode Output Multiplier : %s Multiplier")
    private static float highSpeedModeOutputMultiplier = 3.0f;
    @DynamicInitialValue(key="gtocore.machine.mega_turbine.high_speed_mode_rotor_damage_multiplier", typeKey="multiplier", easyValue="4", normalValue="10", expertValue="12", cn="\u9ad8\u901f\u6a21\u5f0f\u8f6c\u5b50\u635f\u574f\u500d\u7387 : %s \u500d", en="High Speed Mode Rotor Damage Multiplier : %s Multiplier")
    private static int highSpeedModeRotorDamageMultiplier = 10;
    @DynamicInitialValue(key="gtocore.machine.mega_turbine.high_speed_mode_machine_fault", typeKey="multiplier", easyValue="4F", normalValue="8F", expertValue="10F", cn="\u9ad8\u901f\u6a21\u5f0f\u673a\u5668\u6545\u969c\u500d\u7387 : %s \u500d", en="High Speed Mode Machine Fault Multiplier : %s Multiplier")
    private static float highSpeedModeMachineFault = 8.0f;
    private final long baseEUOutput;
    private final int tier;
    private final boolean mega;
    private long energyPerTick;
    @Persisted
    private boolean highSpeedMode;
    @Persisted
    private float highSpeedFactor = 1.0f;
    final List<RotorHolderPartMachine> rotorHolderMachines = new ArrayList<RotorHolderPartMachine>();
    private ItemPartMachine rotorHatchPartMachine;
    private final ConditionalSubscriptionHandler rotorSubs;
    private double extraOutput = 1.0;
    private double extraDamage = 1.0;
    private double extraEfficiency = 1.0;
    double damageBase = 2.2;
    private float accumulatedDamage = 0.0f;
    @RegisterLanguage(cn="\u7ebf\u5708\u7b49\u7ea7: %s\uff0c\u8f6c\u5b50\u542f\u52a8\u589e\u901f %s%%", en="Coil Tier: %s, Rotor Launch Speed Bonus %s%%")
    public static final String COIL_BONUS = "gtocore.machine.mega_turbine.coil_tier";
    @RegisterLanguage(cn="\u73bb\u7483\u7b49\u7ea7: %s\uff0c\u8f6c\u5b50\u635f\u574f\u500d\u7387\u4e58\u6570\uff1a%s", en="Glass Tier: %s, Rotor Damage Multiplier Bonus: %s")
    public static final String GLASS_BONUS = "gtocore.machine.mega_turbine.glass_tier";
    @RegisterLanguage(cn="\u9ad8\u901f\u6a21\u5f0f\u500d\u7387\u8c03\u8282\uff1a", en="High Speed Mode Multiplier Adjustment:")
    public static final String ADJUSTMENT1 = "gtocore.machine.mega_turbine.expert.adjustment.1";
    @RegisterLanguage(cn="\u8f93\u51fa\uff1a%sx", en="Output EU: %sx")
    public static final String ADJUSTMENT2 = "gtocore.machine.mega_turbine.expert.adjustment.2";
    @RegisterLanguage(cn="\u635f\u574f\uff1a%sx", en="Damage: %sx")
    public static final String ADJUSTMENT3 = "gtocore.machine.mega_turbine.expert.adjustment.3";
    @RegisterLanguage(cn="\u9884\u8ba1\u6700\u5927\u8f93\u51fa\uff1a%s EU/t", en="Estimated Max Output: %s EU/t")
    public static final String ESTIMATED_MAX_OUTPUT = "gtocore.machine.mega_turbine.expert.estimated_max_output";
    @RegisterLanguage(cn="\u4e13\u5bb6\u6a21\u5f0f\u4e0b\uff0c\u5141\u8bb8\u8c03\u8282\u9ad8\u901f\u6a21\u5f0f\u4e0b\u7684\u8f93\u51fa\u500d\u7387\u3002", en="In Expert Mode, allows adjustment of the output multiplier in High Speed Mode.")
    public static final String DESC1 = "gtocore.machine.mega_turbine.expert.desc.1";
    @RegisterLanguage(cn="\u4e0d\u8fc7\uff0c\u8c03\u8282\u8f93\u51fa\u500d\u7387\u4f1a\u540c\u65f6\u5927\u5e45\u727a\u7272\u8f6c\u5b50\u5bff\u547d\u3002", en="However, adjusting the output multiplier will also significantly sacrifice rotor durability.")
    public static final String DESC2 = "gtocore.machine.mega_turbine.expert.desc.2";
    @RegisterLanguage(cn="\u8c03\u8282\u8303\u56f4\uff1a0.1 \u500d - 5 \u500d\u3002", en="Adjustment Range: 0.1x - 5x.")
    public static final String DESC3 = "gtocore.machine.mega_turbine.expert.desc.3";
    @RegisterLanguage(cn="\u516c\u5f0f\uff1a\u8f93\u51fa\u500d\u7387 = \u57fa\u7840\u500d\u7387 x \u8c03\u8282\u500d\u7387", en="Formula: Output Multiplier = Base Multiplier x Adjustment Multiplier")
    public static final String DESC4 = "gtocore.machine.mega_turbine.expert.desc.4";
    @RegisterLanguage(cn="\u8f6c\u5b50\u635f\u574f\u500d\u7387 = \u57fa\u7840\u500d\u7387 x max(2.2 - 0.08 * \u73bb\u7483\u7b49\u7ea7, 1.2) ^ (\u8c03\u8282\u500d\u7387 - 1)", en="Rotor Damage Multiplier = Base Multiplier x max(2.2 - 0.08 * Coil Tier, 1.2) ^ (Adjustment Multiplier - 1)")
    public static final String DESC5 = "gtocore.machine.mega_turbine.expert.desc.5";
    @RegisterLanguage(cn="\u8c03\u8282\uff1a", en="Adjustment: ")
    public static final String ADJUST = "gtocore.machine.mega_turbine.expert.adjust";

    public TurbineMachine(MetaMachineBlockEntity holder, int tier, boolean special, boolean mega) {
        super(holder);
        this.mega = mega;
        this.tier = tier;
        this.baseEUOutput = (long)((double)(GTValues.V[tier] * (long)(mega ? 4 : 1)) * (special ? 2.5 : 2.0));
        this.rotorSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::rotorUpdate, 20, () -> this.rotorHatchPartMachine != null);
    }

    private void rotorUpdate() {
        if (!this.isActive()) {
            this.rotorSubs.updateSubscription();
            if (this.rotorHatchPartMachine == null || this.rotorHatchPartMachine.getInventory().isEmpty()) {
                return;
            }
            boolean full = true;
            for (RotorHolderPartMachine part : this.rotorHolderMachines) {
                if (!part.getRotorStack().m_41619_()) continue;
                full = false;
                part.setRotorStack(this.rotorHatchPartMachine.getInventory().getStackInSlot(0));
                this.rotorHatchPartMachine.getInventory().setStackInSlot(0, ItemStack.f_41583_);
                break;
            }
            if (full) {
                this.rotorSubs.unsubscribe();
            }
        }
    }

    public boolean matchRecipe(Recipe recipe) {
        for (RotorHolderPartMachine part : this.rotorHolderMachines) {
            if (!part.getRotorStack().m_41619_()) continue;
            return false;
        }
        return super.matchRecipe(recipe);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (part instanceof RotorHolderPartMachine) {
            RotorHolderPartMachine rotorHolderMachine = (RotorHolderPartMachine)part;
            this.rotorHolderMachines.add(rotorHolderMachine);
            this.traitSubscriptions.add(rotorHolderMachine.inventory.addChangedListener(() -> ((ConditionalSubscriptionHandler)this.rotorSubs).updateSubscription()));
        } else if (this.rotorHatchPartMachine == null && part instanceof ItemPartMachine) {
            ItemPartMachine rotorHatchPart;
            this.rotorHatchPartMachine = rotorHatchPart = (ItemPartMachine)part;
            this.traitSubscriptions.add(this.rotorHatchPartMachine.getInventory().addChangedListener(() -> ((ConditionalSubscriptionHandler)this.rotorSubs).updateSubscription()));
        }
    }

    public void onStructureFormed() {
        this.rotorHolderMachines.clear();
        super.onStructureFormed();
        if (this.mega) {
            this.rotorSubs.initialize(this.getLevel());
            if (GTOCore.isExpert() && this instanceof MegaTurbine) {
                this.damageBase = Math.max(2.2 - 0.08 * (double)((MegaTurbine)this).getCasingTier("g_b"), 1.2);
            }
        }
        if (this.formedAmount > 0) {
            if (this.mega) {
                this.extraOutput = 3.0;
                this.extraDamage = 3.0;
                this.extraEfficiency = 1.3;
            } else {
                this.extraOutput = 2.0;
                this.extraDamage = 2.0;
                this.extraEfficiency = 1.2;
            }
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.rotorHolderMachines.clear();
        this.rotorHatchPartMachine = null;
        this.extraOutput = 1.0;
        this.extraDamage = 1.0;
        this.extraEfficiency = 1.0;
        this.damageBase = 2.0;
    }

    public boolean onWorking() {
        if (this.highSpeedMode && this.getOffsetTimer() % 20 == 0) {
            this.accumulatedDamage += this.getHighSpeedModeDamageMultiplier();
            if (this.accumulatedDamage >= 1.0f) {
                int damageToApply = (int)this.accumulatedDamage;
                this.accumulatedDamage -= (float)damageToApply;
                for (RotorHolderPartMachine part : this.rotorHolderMachines) {
                    part.damageRotor(damageToApply);
                }
            }
        }
        return super.onWorking();
    }

    public void afterWorking() {
        this.energyPerTick = 0L;
        GTRecipe recipe = this.getRecipeLogic().getLastRecipe();
        for (IMultiPart part : this.getParts()) {
            if (this.highSpeedMode && recipe != null && part instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)part;
                maintenanceMachine.calculateMaintenance(maintenanceMachine, (int)((double)(highSpeedModeMachineFault * (float)recipe.duration) * this.extraDamage));
                continue;
            }
            if (!(part instanceof IWorkableMultiPart)) continue;
            IWorkableMultiPart workableMultiPart = (IWorkableMultiPart)part;
            workableMultiPart.afterWorking((IWorkableMultiController)this);
        }
    }

    @Nullable
    private RotorHolderPartMachine getRotorHolder() {
        Iterator<RotorHolderPartMachine> iterator = this.rotorHolderMachines.iterator();
        if (iterator.hasNext()) {
            RotorHolderPartMachine part = iterator.next();
            return part;
        }
        return null;
    }

    private int getRotorSpeed() {
        if (this.mega) {
            OpenCacheHashSet material = new OpenCacheHashSet(2);
            int speed = 0;
            for (RotorHolderPartMachine part : this.rotorHolderMachines) {
                ItemStack stack = part.getRotorStack();
                TurbineRotorBehaviour rotorBehaviour = TurbineRotorBehaviour.getBehaviour((ItemStack)stack);
                if (rotorBehaviour == null) {
                    return -1;
                }
                material.add(rotorBehaviour.getPartMaterial(stack));
                speed += part.getRotorSpeed();
            }
            return material.size() == 1 ? speed / 12 : -1;
        }
        RotorHolderPartMachine rotor = this.getRotorHolder();
        if (rotor != null) {
            return rotor.getRotorSpeed();
        }
        return 0;
    }

    private long getVoltage() {
        RotorHolderPartMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return (long)((double)((float)(this.baseEUOutput * (long)rotorHolder.getTotalPower()) * (this.highSpeedMode ? this.getHighSpeedModeOutputMultiplier() : 1.0f) / 100.0f) * this.extraOutput);
        }
        return 0L;
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        long eut;
        RotorHolderPartMachine rotorHolder = this.getRotorHolder();
        long EUt = recipe.getOutputEUt();
        if (rotorHolder == null || EUt <= 0L) {
            return null;
        }
        int rotorSpeed = this.getRotorSpeed();
        if (rotorSpeed < 0) {
            return null;
        }
        int maxSpeed = rotorHolder.getMaxRotorHolderSpeed();
        long turbineMaxVoltage = Math.min(this.getOverclockVoltage(), (long)((double)this.getVoltage() * Math.pow((double)Math.min(maxSpeed, rotorSpeed) / (double)maxSpeed, 2.0)));
        if ((recipe = ParallelLogic.accurateContentParallel((MetaMachine)this, (Recipe)recipe, (long)(turbineMaxVoltage / EUt))) == null) {
            return null;
        }
        this.energyPerTick = eut = Math.min(turbineMaxVoltage, recipe.parallels * EUt);
        recipe.duration = (int)((double)(recipe.duration * rotorHolder.getTotalEfficiency()) * this.extraEfficiency / 100.0);
        recipe.setOutputEUt(eut);
        return recipe;
    }

    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return true;
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfiguratorButton.Toggle((IGuiTexture)GTOGuiTextures.HIGH_SPEED_MODE.getSubTexture(0.0, 0.5, 1.0, 0.5), (IGuiTexture)GTOGuiTextures.HIGH_SPEED_MODE.getSubTexture(0.0, 0.0, 1.0, 0.5), () -> this.highSpeedMode, (clickData, pressed) -> {
            for (RotorHolderPartMachine part : this.rotorHolderMachines) {
                part.setRotorSpeed(0);
            }
            this.highSpeedMode = pressed;
        }).setTooltipsSupplier(pressed -> List.of(Component.m_237115_((String)"gtocore.machine.mega_turbine.high_speed_mode").m_130946_("[").m_7220_((Component)Component.m_237115_((String)(pressed != false ? "gtocore.machine.on" : "gtocore.machine.off"))).m_130946_("]")))});
        if (this.mega && GTOCore.isExpert()) {
            configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfigurator(){

                public Component getTitle() {
                    return Component.m_237115_((String)TurbineMachine.ADJUSTMENT1);
                }

                public List<Component> getTooltips() {
                    return List.of(Component.m_237115_((String)TurbineMachine.DESC1), Component.m_237115_((String)TurbineMachine.DESC2), Component.m_237115_((String)TurbineMachine.DESC3), Component.m_237115_((String)TurbineMachine.DESC4), Component.m_237115_((String)TurbineMachine.DESC5));
                }

                public IGuiTexture getIcon() {
                    return GTOGuiTextures.PARALLEL_CONFIG;
                }

                public Widget createConfigurator() {
                    return TurbineMachine.this.gtolib$configPanelWidget();
                }
            }});
        }
    }

    private Widget gtolib$configPanelWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 100, 20);
        ComponentPanelWidget panelWidget = new ComponentPanelWidget(0, 0, list -> {
            MutableComponent buttonText = Component.m_237115_((String)ADJUST);
            buttonText.m_130946_(" ");
            if (this.getRotorSpeed() == 0) {
                buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]").m_130940_(ChatFormatting.RED), (String)"sub"));
                buttonText.m_130946_(" ");
                buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]").m_130940_(ChatFormatting.GREEN), (String)"add"));
                buttonText.m_130946_(" ");
                buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[o]").m_130940_(ChatFormatting.GREEN), (String)"reset"));
            } else {
                buttonText.m_7220_((Component)Component.m_237115_((String)"ars_nouveau.locked").m_130940_(ChatFormatting.RED));
            }
            list.add(buttonText.m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)ADJUSTMENT2, (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getHighSpeedModeOutputMultiplier()))}).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)ADJUSTMENT3, (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getHighSpeedModeDamageMultiplier()))}))))));
        }).setMaxWidthLimit(130).clickHandler((componentData, clickData) -> {
            if (!clickData.isRemote) {
                if ("reset".equals(componentData)) {
                    this.highSpeedFactor = 1.0f;
                    return;
                }
                float multiplier = 0.01f;
                multiplier *= clickData.isShiftClick ? 10.0f : 1.0f;
                multiplier *= clickData.isCtrlClick ? 100.0f : 1.0f;
                if ("sub".equals(componentData)) {
                    this.onSub(multiplier);
                } else if ("add".equals(componentData)) {
                    this.onAdd(multiplier);
                }
            }
        });
        return group.addWidget((Widget)panelWidget);
    }

    private void onSub(float multiplier) {
        this.highSpeedFactor = Math.max(0.1f, this.highSpeedFactor - multiplier);
    }

    private void onAdd(float multiplier) {
        this.highSpeedFactor = Math.min(5.0f, this.highSpeedFactor + multiplier);
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        long v = this.getVoltage();
        textList.add((Component)Component.m_237110_((String)ESTIMATED_MAX_OUTPUT, (Object[])new Object[]{FormattingUtil.formatNumbers((long)v)}).m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237119_().m_7220_((Component)Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)BigDecimal.valueOf(v)).toEngineeringString()).m_130946_("A ")).m_7220_(FormatUtil.voltageName((BigDecimal)BigDecimal.valueOf(v)))))));
        RotorHolderPartMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.getRotorEfficiency() > 0) {
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_speed", (Object[])new Object[]{FormattingUtil.formatNumbers((double)((double)((float)this.getRotorSpeed() * (this.highSpeedMode ? highSpeedModeOutputMultiplier : 1.0f)) * this.extraOutput)), FormattingUtil.formatNumbers((double)((double)((float)rotorHolder.getMaxRotorHolderSpeed() * (this.highSpeedMode ? highSpeedModeOutputMultiplier : 1.0f)) * this.extraOutput))}));
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.efficiency", (Object[])new Object[]{(double)rotorHolder.getTotalEfficiency() * this.extraEfficiency}));
            if (this.isActive()) {
                String voltageName = GTValues.VNF[GTUtil.getTierByVoltage((long)this.energyPerTick)];
                textList.add(3, (Component)Component.m_237110_((String)"gtceu.multiblock.turbine.energy_per_tick", (Object[])new Object[]{FormattingUtil.formatNumbers((long)this.energyPerTick), voltageName}));
            }
            if (!this.mega) {
                int rotorDurability = rotorHolder.getRotorDurabilityPercent();
                if (rotorDurability > 10) {
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}));
                } else {
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                }
            }
        }
    }

    public int getTier() {
        return this.tier;
    }

    private float getHighSpeedModeOutputMultiplier() {
        if (!GTOCore.isExpert()) {
            return highSpeedModeOutputMultiplier;
        }
        return highSpeedModeOutputMultiplier * this.highSpeedFactor;
    }

    private float getHighSpeedModeDamageMultiplier() {
        if (!GTOCore.isExpert()) {
            return highSpeedModeRotorDamageMultiplier;
        }
        return Math.max(1.0f, (float)((double)highSpeedModeRotorDamageMultiplier * Math.pow(this.damageBase, this.highSpeedFactor - 1.0f)));
    }

    public static class MegaTurbine
    extends TurbineMachine
    implements ICoilMachine,
    ITierCasingMachine {
        private final CoilTrait coilTrait = new CoilTrait((ICoilMachine)this, false, false);
        private final TierCasingTrait tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"g_b"});
        private float workAccumulation = 0.0f;

        public MegaTurbine(MetaMachineBlockEntity holder, int tier, boolean special) {
            super(holder, tier, special, true);
        }

        @Override
        public boolean onWorking() {
            if (this.getCoilTier() > 0) {
                this.workAccumulation += (float)this.getCoilTier() * 1.25f + 4.0f;
                int addition = (int)Math.floor(this.workAccumulation);
                this.workAccumulation -= (float)addition;
                for (RotorHolderPartMachine part : this.rotorHolderMachines) {
                    part.setRotorSpeed(Math.min(part.getRotorSpeed() + addition, part.getMaxRotorHolderSpeed()));
                }
            }
            return super.onWorking();
        }

        public ICoilType getCoilType() {
            return this.coilTrait.getCoilType();
        }

        @Override
        public void customText(List<Component> textList) {
            super.customText(textList);
            textList.add((Component)Component.m_237110_((String)TurbineMachine.COIL_BONUS, (Object[])new Object[]{this.getCoilTier(), this.getCoilTier() * 20}));
            if (GTOCore.isExpert()) {
                textList.add((Component)Component.m_237110_((String)TurbineMachine.GLASS_BONUS, (Object[])new Object[]{this.getCasingTier("g_b"), FormattingUtil.formatNumber2Places((double)this.damageBase)}));
            }
        }

        public Object2IntMap<String> getCasingTiers() {
            return this.tierCasingTrait.getCasingTiers();
        }
    }
}

