/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.machine.multiblock.part.NeutronAcceleratorPartMachine;
import com.gtocore.common.machine.multiblock.part.SensorPartMachine;
import com.gtolib.api.gui.MagicProgressBarProWidget;
import com.gtolib.api.machine.multiblock.NoEnergyMultiblockMachine;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.FunctionContainer;
import com.gtolib.utils.MachineUtils;
import com.gtolib.utils.NumberUtils;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class NeutronActivatorMachine
extends NoEnergyMultiblockMachine
implements IExplosionMachine {
    private static final Item dustBeryllium = ChemicalHelper.getItem((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Beryllium);
    private static final Item dustGraphite = ChemicalHelper.getItem((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Graphite);
    int height;
    @Persisted
    protected int eV;
    private final ConditionalSubscriptionHandler neutronEnergySubs;
    private SensorPartMachine sensorMachine;
    private final List<ItemBusPartMachine> busMachines = new ArrayList<ItemBusPartMachine>(2);
    private final List<NeutronAcceleratorPartMachine> acceleratorMachines = new ArrayList<NeutronAcceleratorPartMachine>(2);
    private final MagicProgressBarProWidget progressBarPro = new MagicProgressBarProWidget(0, 1400000000).addStartColor(-16711936).addMilestone(1200000000, -65536, (Component)Component.m_237115_((String)"gtocore.bar.exploration")).setLeftLabel("eV");

    public NeutronActivatorMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.neutronEnergySubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::neutronEnergyUpdate, 0, () -> this.isFormed || this.eV > 0);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        IMultiPart iMultiPart = part;
        Objects.requireNonNull(iMultiPart);
        IMultiPart iMultiPart2 = iMultiPart;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemBusPartMachine.class, NeutronAcceleratorPartMachine.class, SensorPartMachine.class}, (Object)iMultiPart2, n)) {
            case 0: {
                ItemBusPartMachine itemBusPart = (ItemBusPartMachine)iMultiPart2;
                IO io = itemBusPart.getInventory().getHandlerIO();
                if (io != IO.IN && io != IO.BOTH) break;
                this.busMachines.add(itemBusPart);
                for (RecipeHandlerList handler : itemBusPart.getRecipeHandlers()) {
                    this.traitSubscriptions.add(handler.subscribe(this::absorptionUpdate));
                }
                break;
            }
            case 1: {
                NeutronAcceleratorPartMachine neutronAccelerator = (NeutronAcceleratorPartMachine)iMultiPart2;
                this.acceleratorMachines.add(neutronAccelerator);
                break;
            }
            case 2: {
                SensorPartMachine sensorPartMachine;
                this.sensorMachine = sensorPartMachine = (SensorPartMachine)iMultiPart2;
                break;
            }
        }
    }

    public void onStructureFormed() {
        this.acceleratorMachines.clear();
        this.busMachines.clear();
        super.onStructureFormed();
        FunctionContainer container = (FunctionContainer)this.getMultiblockState().getMatchContext().get((Object)"SpeedPipe");
        if (container != null) {
            this.height = (Integer)container.getValue();
        }
        this.neutronEnergySubs.initialize(this.getLevel());
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.height = 0;
        this.sensorMachine = null;
        this.busMachines.clear();
        this.acceleratorMachines.clear();
    }

    private double getEfficiencyFactor() {
        return Math.pow(0.95, Math.max(this.height - 4, 0));
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (this.eV > recipe.data.m_128451_("ev_min") * 1000000 && this.eV < recipe.data.m_128451_("ev_max") * 1000000) {
            if ((recipe = RecipeModifierFunction.hatchParallel((MetaMachine)this, (Recipe)recipe)) == null) {
                return null;
            }
            recipe.duration = (int)Math.round(Math.max((double)recipe.duration * this.getEfficiencyFactor(), 1.0));
            return recipe;
        }
        this.setIdleReason(IdleReason.NEUTRON_KINETIC_ENERGY_NOT_SATISFIES);
        return null;
    }

    public boolean onWorking() {
        return super.onWorking() && this.working();
    }

    boolean working() {
        if (this.getRecipeLogic().getLastRecipe() != null) {
            int evt = (int)((double)(this.getRecipeLogic().getLastRecipe().data.m_128451_("evt") * 1000) * this.getEVtMultiplier());
            if (this.eV < evt) {
                this.setIdleReason(IdleReason.NEUTRON_KINETIC_ENERGY_NOT_SATISFIES);
                return false;
            }
            this.eV -= evt;
        }
        return true;
    }

    double getEVtMultiplier() {
        return Math.max(1.0, Math.pow(MachineUtils.getHatchParallel((MetaMachine)this), 1.2) * this.getEfficiencyFactor());
    }

    void neutronEnergyUpdate() {
        boolean active = false;
        if (this.isFormed) {
            for (NeutronAcceleratorPartMachine accelerator : this.acceleratorMachines) {
                long increase = accelerator.consumeEnergy();
                if (increase <= 0L) continue;
                active = true;
                this.eV += (int)Math.round(Math.max((double)increase * this.getEfficiencyFactor(), 1.0));
            }
            if (this.eV > 1200000000) {
                this.doExplosion(6.0f);
            }
        }
        if (this.getOffsetTimer() % 20 == 0) {
            this.getRecipeLogic().updateTickSubscription();
            if (!active) {
                this.eV = Math.max(this.eV - 72000, 0);
            }
        }
        if (this.eV < 0) {
            this.eV = 0;
        }
        if (this.sensorMachine == null) {
            return;
        }
        this.sensorMachine.update((float)this.eV / 1000000.0f);
        this.neutronEnergySubs.updateSubscription();
    }

    private void absorptionUpdate() {
        for (ItemBusPartMachine bus : this.busMachines) {
            NotifiableItemStackHandler inv = bus.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!stack.m_150930_(dustBeryllium) && !stack.m_150930_(dustGraphite)) continue;
                int consume = Math.min(Math.max(this.eV / 10000000, 1), stack.m_41613_());
                inv.extractItemInternal(i, consume, false);
                this.eV -= 10000000 * consume;
            }
        }
    }

    public ModularUI createUI(Player entityPlayer) {
        return super.createUI(entityPlayer).widget((Widget)this.progressBarPro);
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.neutron_activator.ev", (Object[])new Object[]{NumberUtils.formatLong((long)this.eV)}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.neutron_activator.efficiency", (Object[])new Object[]{FormattingUtil.formatNumbers((double)this.getEVtMultiplier())}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.height", (Object[])new Object[]{this.height}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.duration_multiplier.tooltip", (Object[])new Object[]{FormattingUtil.formatNumbers((double)(this.getEfficiencyFactor() * 100.0))}).m_130946_("%"));
        this.progressBarPro.setProgressSupplier(() -> this.eV);
    }

    @Generated
    public int getEV() {
        return this.eV;
    }
}

