/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gtolib.api.machine.trait.NotifiableCatalystHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class CatalystHatchPartMachine
extends WorkableTieredIOPartMachine {
    @Persisted
    private final NotifiableItemStackHandler inventory;

    public CatalystHatchPartMachine(MetaMachineBlockEntity holder, int tier) {
        super(holder, tier, IO.IN);
        this.inventory = new NotifiableCatalystHandler((MetaMachine)this, tier == 2 ? 4 : 36, true);
    }

    public void onPaintingColorChanged(int color) {
        this.getHandlerList().setColor(color, true);
    }

    public Widget createUIWidget() {
        int rowSize = this.tier == 2 ? 2 : 6;
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * rowSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * rowSize + 8);
        int index = 0;
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory.storage, index++, 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setIngredientIO(this.io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    public boolean canShared() {
        return false;
    }
}

