/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.function.ObjectLongConsumer;
import com.gregtechceu.gtceu.utils.function.ObjectLongPredicate;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.utils.MathUtil;
import com.hepdd.gtmthings.api.machine.fancyconfigurator.ButtonConfigurator;
import com.hepdd.gtmthings.api.transfer.UnlimitItemTransferHelper;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class HugeBusPartMachine
extends WorkableTieredIOPartMachine
implements IMachineLife {
    @Persisted
    private final HugeNotifiableItemStackHandler inventory = new HugeNotifiableItemStackHandler((MetaMachine)this);
    @Nullable
    private TickableSubscription autoIOSubs;
    @Nullable
    private ISubscription inventorySubs;

    public HugeBusPartMachine(MetaMachineBlockEntity holder) {
        super(holder, 5, IO.IN);
        this.workingEnabled = false;
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateInventorySubscription));
        }
        this.inventorySubs = this.inventory.addChangedListener(this::updateInventorySubscription);
    }

    public void onUnload() {
        super.onUnload();
        if (this.inventorySubs != null) {
            this.inventorySubs.unsubscribe();
            this.inventorySubs = null;
        }
    }

    private void refundAll(ClickData clickData) {
        if (clickData.isRemote) {
            return;
        }
        this.setWorkingEnabled(false);
        this.exportToNearby(this.inventory, this.getFrontFacing());
    }

    public void onPaintingColorChanged(int color) {
        this.getHandlerList().setColor(color, true);
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateInventorySubscription();
    }

    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateInventorySubscription();
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    private void updateInventorySubscription() {
        if (this.isWorkingEnabled() && ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getFrontFacing()), (Direction)this.getFrontFacing().m_122424_()) != null) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO, 40);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    private void autoIO() {
        if (this.isWorkingEnabled()) {
            this.inventory.importFromNearby(new Direction[]{this.getFrontFacing()});
        }
        this.updateInventorySubscription();
    }

    private void exportToNearby(HugeNotifiableItemStackHandler handler, @NotNull Direction facing) {
        if (handler.getCount() < 1L) {
            return;
        }
        Level level = this.getLevel();
        BlockPos pos = this.getPos();
        UnlimitItemTransferHelper.exportToTarget((IItemHandler)handler.storage, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateInventorySubscription();
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new ButtonConfigurator((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("\ud83d\udd19")}), this::refundAll).setTooltips(List.of(Component.m_237115_((String)"gtmthings.machine.huge_item_bus.tooltip.1")))});
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 109, 63);
        CustomItemStackHandler importItems = this.createImportItems();
        group.addWidget((Widget)new ImageWidget(4, 4, 82, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.machine.quantum_chest.items_stored")).addWidget((Widget)new LabelWidget(8, 18, () -> FormattingUtil.formatNumbers((long)this.inventory.getCount()))).addWidget((Widget)new SlotWidget((IItemHandlerModifiable)importItems, 0, 87, 4, false, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY}))).addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory, 0, 87, 22, false, false).setItemHook(s -> s.m_255036_((int)Math.min(this.inventory.getCount(), (long)s.m_41741_()))).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT)).addWidget((Widget)new ButtonWidget(87, 41, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, Icons.DOWN.scale(0.7f)}), cd -> {
            ItemStack extracted;
            if (!(cd.isRemote || this.inventory.isEmpty() || group.getGui().entityPlayer.m_36356_(extracted = this.inventory.extractItemInternal(0, (int)Math.min(this.inventory.getCount(), (long)this.inventory.getStackInSlot(0).m_41741_()), false)))) {
                Block.m_49840_((Level)group.getGui().entityPlayer.m_9236_(), (BlockPos)group.getGui().entityPlayer.m_20097_(), (ItemStack)extracted);
            }
        }));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private CustomItemStackHandler createImportItems() {
        CustomItemStackHandler importItems = new CustomItemStackHandler();
        importItems.setFilter(itemStack -> this.inventory.canCapInput() && this.inventory.insertItem(0, (ItemStack)itemStack, true).m_41613_() != itemStack.m_41613_());
        importItems.setOnContentsChanged(() -> {
            ItemStack item = importItems.getStackInSlot(0).m_41777_();
            if (!item.m_41619_()) {
                importItems.setStackInSlot(0, ItemStack.f_41583_);
                importItems.onContentsChanged(0);
                this.inventory.insertItem(0, item.m_41777_(), false);
            }
        });
        return importItems;
    }

    public NotifiableItemStackHandler getInventory() {
        return this.inventory;
    }

    private static final class HugeNotifiableItemStackHandler
    extends NotifiableItemStackHandler {
        private HugeNotifiableItemStackHandler(MetaMachine machine) {
            super(machine, 1, IO.IN, IO.BOTH, i -> new HugeCustomItemStackHandler());
        }

        private long getCount() {
            return ((HugeCustomItemStackHandler)this.storage).count;
        }

        public ItemStack getStackInSlot(int i) {
            return ((HugeCustomItemStackHandler)this.storage).stack;
        }

        public boolean forEachItems(ObjectLongPredicate<ItemStack> function) {
            long amount = ((HugeCustomItemStackHandler)this.storage).count;
            if (amount > 0L) {
                return function.test((Object)this.getStackInSlot(0), amount);
            }
            return false;
        }

        public void fastForEachItems(ObjectLongConsumer<ItemStack> function) {
            long amount = ((HugeCustomItemStackHandler)this.storage).count;
            if (amount > 0L) {
                function.accept((Object)this.getStackInSlot(0), amount);
            }
        }

        public boolean isEmpty() {
            if (this.isEmpty == null) {
                this.isEmpty = ((HugeCustomItemStackHandler)this.storage).stack.m_41619_();
            }
            return this.isEmpty;
        }

        public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
            if (this.changed) {
                this.changed = false;
                this.intIngredientMap.clear();
                long amount = ((HugeCustomItemStackHandler)this.storage).count;
                if (amount > 0L) {
                    type.convertItem(this.getStackInSlot(0), amount, this.intIngredientMap);
                }
            }
            return this.intIngredientMap;
        }

        public boolean canCapOutput() {
            return true;
        }

        @Nullable
        public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
            if (io != IO.IN && ((HugeCustomItemStackHandler)this.storage).count > 0L) {
                return left.isEmpty() ? null : left;
            }
            Iterator<Ingredient> it = left.iterator();
            while (it.hasNext()) {
                long amount;
                Ingredient ingredient = it.next();
                if (ingredient.m_43947_()) {
                    it.remove();
                    continue;
                }
                if (ingredient instanceof FastSizedIngredient) {
                    FastSizedIngredient si = (FastSizedIngredient)ingredient;
                    amount = si.getAmount();
                } else {
                    amount = 1L;
                }
                if (amount < 1L) {
                    it.remove();
                    continue;
                }
                long count = Math.min(amount, this.getCount());
                if (count == 0L) continue;
                if (ingredient.test(this.getStackInSlot(0))) {
                    if (!simulate) {
                        ((HugeCustomItemStackHandler)this.storage).count -= count;
                        this.getStackInSlot(0).m_41764_(MathUtil.saturatedCast((long)((HugeCustomItemStackHandler)this.storage).count));
                        this.storage.onContentsChanged(0);
                    }
                    amount -= count;
                }
                if (amount <= 0L) {
                    it.remove();
                    continue;
                }
                if (!(ingredient instanceof FastSizedIngredient)) continue;
                FastSizedIngredient si = (FastSizedIngredient)ingredient;
                si.setAmount(amount);
            }
            return left.isEmpty() ? null : left;
        }
    }

    private static final class HugeCustomItemStackHandler
    extends CustomItemStackHandler {
        @NotNull
        private ItemStack stack = ItemStack.f_41583_;
        private long count;

        private HugeCustomItemStackHandler() {
            super(1);
        }

        public int getSlots() {
            return 1;
        }

        public void setStackInSlot(int index, @NotNull ItemStack stack) {
            this.stack = stack;
            this.count = stack.m_41613_();
            this.onContentsChanged(index);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.stack;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (this.count < 1L || this.stack.m_41619_()) {
                if (!simulate) {
                    this.stack = stack.m_41777_();
                    this.count = stack.m_41613_();
                    this.onContentsChanged(0);
                }
                return ItemStack.f_41583_;
            }
            if (this.stack.m_41720_() == stack.m_41720_()) {
                CompoundTag tag = this.stack.getShareTag();
                if (tag == null) {
                    if (stack.getShareTag() == null) {
                        if (!simulate) {
                            this.count += (long)stack.m_41613_();
                            this.stack.m_41764_(MathUtil.saturatedCast((long)this.count));
                            this.onContentsChanged(0);
                        }
                        return ItemStack.f_41583_;
                    }
                } else if (tag.equals((Object)stack.getShareTag())) {
                    if (!simulate) {
                        this.count += (long)stack.m_41613_();
                        this.stack.m_41764_(MathUtil.saturatedCast((long)this.count));
                        this.onContentsChanged(0);
                    }
                    return ItemStack.f_41583_;
                }
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0 || this.count < 1L || this.stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if ((long)amount >= this.count) {
                if (simulate) {
                    return this.stack;
                }
                this.count = 0L;
                ItemStack stack = this.stack;
                this.stack = ItemStack.f_41583_;
                this.onContentsChanged(0);
                return stack;
            }
            if (!simulate) {
                this.count -= (long)amount;
                this.stack.m_41764_(MathUtil.saturatedCast((long)this.count));
                this.onContentsChanged(0);
            }
            return this.stack.m_255036_(amount);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("stack", (Tag)this.stack.serializeNBT());
            nbt.m_128356_("count", this.count);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            Tag stack = nbt.m_128423_("stack");
            if (stack instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)stack;
                this.stack = ItemStack.m_41712_((CompoundTag)tag);
            }
            this.count = nbt.m_128454_("count");
            this.stack.m_41764_(MathUtil.saturatedCast((long)this.count));
        }
    }
}

