/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.recipe.condition.DimensionCondition;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InfiniteIntakeHatchPartMachine
extends WorkableTieredIOPartMachine {
    public static final Map<ResourceLocation, Fluid> AIR_MAP = new O2OOpenCacheHashMap();
    private TickableSubscription intakeSubs;
    @Persisted
    private final NotifiableFluidTank tank = new NotifiableFluidTank((MetaMachine)this, 1, 256000, IO.IN, IO.NONE);
    @RequireRerender
    @DescSynced
    private boolean isWorking;

    public InfiniteIntakeHatchPartMachine(MetaMachineBlockEntity holder) {
        super(holder, 0, IO.IN);
        this.tank.addChangedListener(this::updateTankSubscription);
    }

    public static void init(GTRecipeBuilder recipeBuilder) {
        for (RecipeCondition condition : recipeBuilder.conditions) {
            if (!(condition instanceof DimensionCondition)) continue;
            DimensionCondition dimensionCondition = (DimensionCondition)condition;
            ResourceLocation dim = dimensionCondition.getDimension();
            List fluids = RecipeHelper.getOutputFluids((GTRecipeBuilder)recipeBuilder);
            if (fluids.isEmpty()) continue;
            AIR_MAP.put(dim, ((FluidStack)fluids.get(0)).getFluid());
            break;
        }
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTankSubscription));
        }
    }

    public void onUnload() {
        super.onUnload();
        this.unsubscribe();
    }

    public void onPaintingColorChanged(int color) {
        this.getHandlerList().setColor(color, true);
    }

    public void onNeighborChanged(@NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        if (this.getPos().m_121945_(this.getFrontFacing()).equals((Object)fromPos)) {
            this.updateTankSubscription();
        }
    }

    private boolean isFrontFaceFree() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_8055_(this.getPos().m_121945_(this.getFrontFacing())).m_60795_();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.isWorking && this.getOffsetTimer() % 5 == 0) {
            Direction facing = this.getFrontFacing();
            int stepX = facing.m_122429_();
            int stepY = facing.m_122430_();
            int stepZ = facing.m_122431_();
            double offset = 2.0 * GTValues.RNG.m_188500_() + 2.0;
            Vec3 pos = this.getPos().m_252807_().m_82520_((double)stepX * 0.5, (double)stepY * 0.5, (double)stepZ * 0.5);
            Vec3 center = pos.m_82520_((double)stepX * offset, (double)stepY * offset, (double)stepZ * offset);
            double theta = Math.PI * 2 * GTValues.RNG.m_188500_();
            double x = 1.5 * Math.cos(theta);
            double y = 1.5 * Math.sin(theta);
            Vec2 point = new Vec2((float)x, (float)y);
            Vec3 randPos = center.m_82520_((double)((float)stepY * point.f_82471_ + (float)stepZ * point.f_82470_), (double)((float)stepX * point.f_82470_ + (float)stepZ * point.f_82471_), (double)((float)stepX * point.f_82471_ + (float)stepY * point.f_82470_));
            Vec3 speed = pos.m_82546_(randPos).m_82490_(0.055);
            this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123796_, randPos.f_82479_, randPos.f_82480_, randPos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
    }

    private void updateTankSubscription() {
        if (this.isWorkingEnabled() && this.isFrontFaceFree()) {
            this.intakeSubs = this.subscribeServerTick(this.intakeSubs, this::intake, 20);
            this.isWorking = true;
        } else {
            this.unsubscribe();
        }
    }

    private void intake() {
        Fluid fluid = AIR_MAP.get(this.getLevel().m_46472_().m_135782_());
        if (fluid == null) {
            this.unsubscribe();
            return;
        }
        if (this.tank.fillInternal(new FluidStack(fluid, 8000), IFluidHandler.FluidAction.EXECUTE) == 0) {
            this.unsubscribe();
        } else {
            this.updateTankSubscription();
        }
    }

    private void unsubscribe() {
        if (this.intakeSubs != null) {
            this.intakeSubs.unsubscribe();
            this.intakeSubs = null;
        }
        this.isWorking = false;
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateTankSubscription();
    }
}

