/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.utils.function.ObjectLongConsumer;
import com.gregtechceu.gtceu.utils.function.ObjectLongPredicate;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InfiniteWaterHatchPartMachine
extends WorkableTieredIOPartMachine {
    public InfiniteWaterHatchPartMachine(MetaMachineBlockEntity holder) {
        super(holder, 5, IO.IN);
        new FluidTank((MetaMachine)this);
    }

    public void onPaintingColorChanged(int color) {
        this.getHandlerList().setColor(color, true);
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    private static final class FluidTank
    extends NotifiableRecipeHandlerTrait<FluidIngredient> {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.f_76193_, Integer.MAX_VALUE);
        private static final IntLongMap MAP = new IntLongMap();

        private FluidTank(MetaMachine machine) {
            super(machine);
        }

        public boolean hasCapability(@Nullable Direction side) {
            return false;
        }

        public int getSize() {
            return 1;
        }

        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
            if (io == IO.IN) {
                Iterator<FluidIngredient> it = left.iterator();
                while (it.hasNext()) {
                    Fluid f = FastFluidIngredient.getFluid((FluidIngredient)it.next());
                    if (f != Fluids.f_76193_) continue;
                    it.remove();
                    break;
                }
            }
            return left.isEmpty() ? null : left;
        }

        public RecipeCapability<FluidIngredient> getCapability() {
            return FluidRecipeCapability.CAP;
        }

        public List<FluidIngredient> handleRecipe(IO io, GTRecipe recipe, List<?> list, boolean simulate) {
            return this.handleRecipeInner(io, recipe, new ArrayList<FluidIngredient>(list), simulate);
        }

        public IO getHandlerIO() {
            return IO.IN;
        }

        public boolean forEachFluids(ObjectLongPredicate<FluidStack> function) {
            return function.test((Object)WATER, Long.MAX_VALUE);
        }

        public void fastForEachFluids(ObjectLongConsumer<FluidStack> function) {
            function.accept((Object)WATER, Long.MAX_VALUE);
        }

        public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
            return MAP;
        }

        static {
            GTORecipeTypes.DUMMY_RECIPES.convertFluid(WATER, Long.MAX_VALUE, MAP);
        }
    }
}

