/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gtolib.api.machine.feature.ISpaceWorkspaceMachine;
import com.gtolib.api.machine.feature.IWorkInSpaceMachine;
import com.gtolib.utils.holder.BooleanHolder;
import earth.terrarium.adastra.api.planets.PlanetApi;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SpaceShieldHatch
extends MultiblockPartMachine
implements ISpaceWorkspaceMachine {
    private BooleanHolder hasLaser;

    public SpaceShieldHatch(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void addedToController(@NotNull IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof IWorkInSpaceMachine) {
            IWorkInSpaceMachine machine = (IWorkInSpaceMachine)controller;
            machine.setWorkspaceProvider((ISpaceWorkspaceMachine)this);
        }
    }

    public boolean canShared() {
        return false;
    }

    public void addMultiText(List<Component> textList) {
        super.addMultiText(textList);
        if (!PlanetApi.API.isSpace(this.getLevel())) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.space_shield_hatch.not_in_space"));
            return;
        }
        if (this.isWorkspaceReady()) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.space_shield_hatch.info").m_130940_(ChatFormatting.GREEN));
        } else {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.space_shield_hatch.insufficient").m_130940_(ChatFormatting.RED));
        }
    }

    public void removedFromController(@NotNull IMultiController controller) {
        IWorkInSpaceMachine receiver;
        super.removedFromController(controller);
        if (controller instanceof IWorkInSpaceMachine && (receiver = (IWorkInSpaceMachine)controller).getWorkspaceProvider() == this) {
            receiver.setWorkspaceProvider(null);
        }
        this.hasLaser = null;
    }

    public boolean isWorkspaceReady() {
        if (this.hasLaser == null) {
            this.hasLaser = new BooleanHolder(Stream.of(this.getController().getParts()).anyMatch(p -> PartAbility.INPUT_LASER.isApplicable(p.self().getBlockState().m_60734_())));
        }
        return this.hasLaser.value;
    }
}

