/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IWailaDisplayProvider;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableMultiblockPartMachine;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gtocore.integration.jade.GTOJadePlugin;
import com.gtolib.api.machine.trait.WirelessComputationContainerTrait;
import com.gtolib.api.wireless.WirelessComputationContainer;
import com.hepdd.gtmthings.api.capability.IBindable;
import com.hepdd.gtmthings.utils.TeamUtil;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;

public final class WirelessNetworkComputationHatchMachine
extends WorkableMultiblockPartMachine
implements IInteractedMachine,
IBindable,
IWailaDisplayProvider {
    private final WirelessComputationContainerTrait trait;

    public WirelessNetworkComputationHatchMachine(MetaMachineBlockEntity holder, boolean transmitter) {
        super(holder);
        this.trait = new WirelessComputationContainerTrait((MetaMachine)this, transmitter);
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    public boolean canShared() {
        return false;
    }

    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_150930_(GTItems.TOOL_DATA_STICK.m_5456_())) {
            this.setOwnerUUID(player.m_20148_());
            if (this.isRemote()) {
                player.m_213846_((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_hatch.tooltip.bind", (Object[])new Object[]{TeamUtil.GetName((Player)player)}));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean onLeftClick(Player player, Level world, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player.m_21120_(hand).m_150930_(GTItems.TOOL_DATA_STICK.m_5456_())) {
            this.setOwnerUUID(null);
            if (this.isRemote()) {
                player.m_213846_((Component)Component.m_237115_((String)"gtmthings.machine.wireless_energy_hatch.tooltip.unbind"));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public UUID getUUID() {
        return this.trait.getUUID();
    }

    public void appendWailaTooltip(CompoundTag data, ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        long capacity = data.m_128454_("capacity");
        if (capacity == 0L) {
            return;
        }
        long storage = data.m_128454_("storage");
        IElementHelper helper = iTooltip.getElementHelper();
        iTooltip.add(helper.progress(GTOJadePlugin.getProgress(storage, capacity), (Component)Component.m_237113_((String)(storage + " / " + capacity + " CWU")), iTooltip.getElementHelper().progressStyle().color(-16749206).textColor(-1), (IBoxStyle)Util.m_137469_((Object)BoxStyle.DEFAULT, style -> {
            style.borderColor = -11184811;
        }), true));
    }

    public void appendWailaData(CompoundTag data, BlockAccessor blockAccessor) {
        WirelessComputationContainer c = this.trait.getWirelessComputationContainer();
        if (c == null) {
            return;
        }
        data.m_128356_("capacity", c.getCapacity());
        data.m_128356_("storage", c.getStorage());
    }
}

