/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.slots;

import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public abstract class ExportOnlyAESlot
implements IConfigurableSlot,
ITagSerializable<CompoundTag>,
IContentChangeAware {
    private static final String CONFIG_TAG = "config";
    private static final String STOCK_TAG = "stock";
    private Runnable onContentsChanged = () -> {};
    @Nullable
    GenericStack config;
    @Nullable
    GenericStack stock;

    ExportOnlyAESlot(@Nullable GenericStack config, @Nullable GenericStack stock) {
        this.config = config;
        this.stock = stock;
    }

    ExportOnlyAESlot() {
        this(null, null);
    }

    @Nullable
    public GenericStack requestStack() {
        if (this.stock != null && this.stock.amount() <= 0L) {
            this.stock = null;
        }
        if (this.config == null || this.stock != null && !this.config.what().matches(this.stock)) {
            return null;
        }
        if (this.stock == null) {
            return ExportOnlyAESlot.copy(this.config);
        }
        if (this.stock.amount() <= this.config.amount()) {
            return ExportOnlyAESlot.copy(this.config, this.config.amount() - this.stock.amount());
        }
        return null;
    }

    @Nullable
    public GenericStack exceedStack() {
        if (this.stock != null && this.stock.amount() <= 0L) {
            this.stock = null;
        }
        if (this.config == null && this.stock != null) {
            return ExportOnlyAESlot.copy(this.stock);
        }
        if (this.config != null && this.stock != null) {
            if (this.config.what().matches(this.stock) && this.config.amount() < this.stock.amount()) {
                return ExportOnlyAESlot.copy(this.stock, this.stock.amount() - this.config.amount());
            }
            if (!this.config.what().matches(this.stock)) {
                return ExportOnlyAESlot.copy(this.stock);
            }
        }
        return null;
    }

    void onContentsChanged() {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    protected abstract void addStack(GenericStack var1);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.config != null) {
            CompoundTag configTag = GenericStack.writeTag((GenericStack)this.config);
            tag.m_128365_(CONFIG_TAG, (Tag)configTag);
        }
        if (this.stock != null) {
            CompoundTag stockTag = GenericStack.writeTag((GenericStack)this.stock);
            tag.m_128365_(STOCK_TAG, (Tag)stockTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_(CONFIG_TAG)) {
            this.config = GenericStack.readTag((CompoundTag)tag.m_128469_(CONFIG_TAG));
        }
        if (tag.m_128441_(STOCK_TAG)) {
            this.stock = GenericStack.readTag((CompoundTag)tag.m_128469_(STOCK_TAG));
        }
    }

    static GenericStack copy(GenericStack stack) {
        return new GenericStack(stack.what(), stack.amount());
    }

    public static GenericStack copy(GenericStack stack, long amount) {
        return new GenericStack(stack.what(), amount);
    }

    @Nullable
    public GenericStack getConfig() {
        return this.config;
    }

    public void setConfig(@Nullable GenericStack config) {
        this.config = config;
    }

    @Nullable
    public GenericStack getStock() {
        return this.stock;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }
}

