/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.widget.slot;

import appeng.api.stacks.GenericStack;
import appeng.integration.modules.emi.EmiStackHelper;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gtocore.common.machine.multiblock.part.ae.widget.ConfigWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AEConfigSlotWidget
extends Widget
implements IIngredientSlot {
    final ConfigWidget parentWidget;
    final int index;
    static final int REMOVE_ID = 1000;
    static final int UPDATE_ID = 1001;
    static final int AMOUNT_CHANGE_ID = 1002;
    static final int SLOT_CLICK_ID = 1003;
    static final int SLOT_DROP_ID = 1004;
    boolean select = false;

    AEConfigSlotWidget(Position pos, Size size, ConfigWidget widget2, int index) {
        super(pos, size);
        this.parentWidget = widget2;
        this.index = index;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (slot.getConfig() == null) {
            if (this.mouseOverConfig(mouseX, mouseY)) {
                ArrayList<MutableComponent> hoverStringList = new ArrayList<MutableComponent>();
                hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot"));
                if (this.parentWidget.isAutoPull()) {
                    hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.auto_pull_managed"));
                } else {
                    if (!this.parentWidget.isStocking()) {
                        hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.set"));
                        hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.scroll"));
                    } else {
                        hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.set_only"));
                    }
                    hoverStringList.add(Component.m_237115_((String)"gtceu.gui.config_slot.remove"));
                }
                this.setHoverTooltips(hoverStringList);
            }
        } else {
            GenericStack item = null;
            if (this.mouseOverConfig(mouseX, mouseY)) {
                item = slot.getConfig();
            } else if (this.mouseOverStock(mouseX, mouseY)) {
                item = slot.getStock();
            }
            if (item != null) {
                this.setHoverTooltips(Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)GenericStack.wrapInItemStack((GenericStack)item)));
            }
        }
    }

    boolean mouseOverConfig(double mouseX, double mouseY) {
        Position position = this.getPosition();
        return AEConfigSlotWidget.isMouseOver((int)position.x, (int)position.y, (int)18, (int)18, (double)mouseX, (double)mouseY);
    }

    boolean mouseOverStock(double mouseX, double mouseY) {
        Position position = this.getPosition();
        return AEConfigSlotWidget.isMouseOver((int)position.x, (int)(position.y + 18), (int)18, (int)18, (double)mouseX, (double)mouseY);
    }

    boolean isStackValidForSlot(GenericStack stack) {
        if (stack == null || stack.amount() < 0L) {
            return true;
        }
        if (!this.parentWidget.isStocking()) {
            return true;
        }
        return !this.parentWidget.hasStackInConfig(stack);
    }

    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (slot == null) {
            return null;
        }
        GenericStack stack = null;
        if (this.mouseOverConfig(mouseX, mouseY)) {
            stack = slot.getConfig();
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            stack = slot.getStock();
        }
        if (stack == null || stack.what() == null) {
            return null;
        }
        EmiStack emiStack = EmiStackHelper.toEmiStack((GenericStack)stack);
        if (emiStack != null) {
            if (emiStack.getAmount() == 0L) {
                emiStack.setAmount(1L);
            }
            return new EmiStackInteraction((EmiIngredient)emiStack, null, false);
        }
        return null;
    }

    @Generated
    public void setSelect(boolean select) {
        this.select = select;
    }
}

