/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.widget.slot;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.IGhostItemTarget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAESlot;
import com.gtocore.common.machine.multiblock.part.ae.widget.ConfigWidget;
import com.gtocore.common.machine.multiblock.part.ae.widget.slot.AEConfigSlotWidget;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AEItemConfigSlotWidget
extends AEConfigSlotWidget
implements IGhostItemTarget {
    public AEItemConfigSlotWidget(int x, int y, ConfigWidget widget2, int index) {
        super(new Position(x, y), new Size(18, 36), widget2, index);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String amountStr;
        ItemStack stack;
        AEItemKey key;
        AEKey aEKey;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        GenericStack config = slot.getConfig();
        GenericStack stock = slot.getStock();
        AEItemConfigSlotWidget.drawSlots(graphics, mouseX, mouseY, position.x, position.y, this.parentWidget.isAutoPull());
        if (this.select) {
            GuiTextures.SELECT_BOX.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        }
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (config != null) {
            ItemStack itemStack;
            aEKey = config.what();
            if (aEKey instanceof AEItemKey) {
                key = (AEItemKey)aEKey;
                itemStack = new ItemStack((ItemLike)key.getItem());
            } else {
                itemStack = ItemStack.f_41583_;
            }
            stack = itemStack;
            DrawerHelper.drawItemStack((GuiGraphics)graphics, (ItemStack)stack, (int)stackX, (int)stackY, (int)-1, null);
            if (!this.parentWidget.isStocking()) {
                amountStr = TextFormattingUtil.formatLongToCompactString((long)config.amount(), (int)4);
                DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
            }
        }
        if (stock != null) {
            ItemStack itemStack;
            aEKey = stock.what();
            if (aEKey instanceof AEItemKey) {
                key = (AEItemKey)aEKey;
                itemStack = new ItemStack((ItemLike)key.getItem());
            } else {
                itemStack = ItemStack.f_41583_;
            }
            stack = itemStack;
            DrawerHelper.drawItemStack((GuiGraphics)graphics, (ItemStack)stack, (int)stackX, (int)(stackY + 18), (int)-1, null);
            amountStr = TextFormattingUtil.formatLongToCompactString((long)stock.amount(), (int)4);
            DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 18 + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            AEListGridWidget.drawSelectionOverlay((GuiGraphics)graphics, (int)stackX, (int)stackY, (int)16, (int)16);
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            AEListGridWidget.drawSelectionOverlay((GuiGraphics)graphics, (int)stackX, (int)(stackY + 18), (int)16, (int)16);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawSlots(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, boolean autoPull) {
        if (autoPull) {
            GuiTextures.SLOT_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
            GuiTextures.CONFIG_ARROW.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
        } else {
            GuiTextures.SLOT.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
            GuiTextures.CONFIG_ARROW_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
        }
        GuiTextures.SLOT_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)(y + 18), 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button2) {
        if (this.mouseOverConfig(mouseX, mouseY)) {
            if (this.parentWidget.isAutoPull()) {
                return false;
            }
            if (button2 == 1) {
                this.writeClientAction(1000, buf -> {});
                if (!this.parentWidget.isStocking()) {
                    this.parentWidget.disableAmountClient();
                }
            } else if (button2 == 0) {
                ItemStack item = this.gui.getModularUIContainer().m_142621_();
                if (!item.m_41619_()) {
                    this.writeClientAction(1001, buf -> buf.m_130055_(item));
                }
                if (!this.parentWidget.isStocking()) {
                    this.parentWidget.enableAmountClient(this.index);
                    this.select = true;
                }
            }
            return true;
        }
        if (this.mouseOverStock(mouseX, mouseY)) {
            if (this.parentWidget.isStocking()) {
                return false;
            }
            GenericStack stack = this.parentWidget.getDisplay(this.index).getStock();
            if (stack != null) {
                this.writeClientAction(1003, buf -> {
                    buf.writeInt(button2);
                    buf.writeBoolean(AEItemConfigSlotWidget.isShiftDown());
                });
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.parentWidget.getDisplay(this.index).getStock() == null) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.f_92094_.m_90832_(keyCode, scanCode)) {
            double mouseY;
            if (this.parentWidget.isStocking()) {
                return false;
            }
            double mouseX = minecraft.f_91067_.m_91589_() * (double)minecraft.m_91268_().m_85445_() / (double)minecraft.m_91268_().m_85443_();
            if (this.isMouseOverElement(mouseX, mouseY = minecraft.f_91067_.m_91594_() * (double)minecraft.m_91268_().m_85446_() / (double)minecraft.m_91268_().m_85444_()) && this.mouseOverStock(mouseX, mouseY)) {
                this.writeClientAction(1004, buf -> buf.writeBoolean(AEItemConfigSlotWidget.isCtrlDown()));
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        super.handleClientAction(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
        switch (id) {
            case 1000: {
                slot.setConfig(null);
                this.parentWidget.disableAmount();
                this.writeUpdateInfo(1000, buf -> {});
                break;
            }
            case 1001: {
                ItemStack itemStack = buffer.m_130267_();
                GenericStack stack = GenericStack.fromItemStack((ItemStack)itemStack);
                if (!this.isStackValidForSlot(stack)) {
                    return;
                }
                slot.setConfig(stack);
                this.parentWidget.enableAmount(this.index);
                if (itemStack.m_41619_()) break;
                this.writeUpdateInfo(1001, buf -> buf.m_130055_(itemStack));
                break;
            }
            case 1002: {
                if (slot.getConfig() == null) {
                    return;
                }
                long amt = buffer.m_130258_();
                slot.setConfig(new GenericStack(slot.getConfig().what(), amt));
                this.writeUpdateInfo(1002, buf -> buf.m_130103_(amt));
                break;
            }
            case 1003: {
                int clickResult;
                AEKey aEKey;
                int mouseButton = buffer.readInt();
                boolean isShiftDown = buffer.readBoolean();
                if (slot.getStock() == null || !((aEKey = slot.getStock().what()) instanceof AEItemKey)) {
                    return;
                }
                AEItemKey key = (AEItemKey)aEKey;
                long amount = slot.getStock().amount();
                int maxStackSize = key.getMaxStackSize();
                if (mouseButton == 0 && isShiftDown) {
                    Player player = this.gui.entityPlayer;
                    if (player == null) {
                        return;
                    }
                    int moveCount = (int)Math.min(amount, (long)maxStackSize);
                    ItemStack moveStack = key.toStack(moveCount);
                    this.transferToPlayerInventory(player, moveStack);
                    GenericStack newStock = ExportOnlyAESlot.copy(slot.getStock(), amount - (long)(moveCount - moveStack.m_41613_()));
                    slot.setStock(newStock.amount() == 0L ? null : newStock);
                    clickResult = this.gui.getModularUIContainer().m_142621_().m_41613_();
                } else {
                    ModularUIContainer container = this.gui.getModularUIContainer();
                    ItemStack carried = container.m_142621_();
                    int pickUpCount = (int)Math.min(amount, (long)maxStackSize);
                    if (mouseButton == 1) {
                        pickUpCount = (pickUpCount + 1) / 2;
                    }
                    ItemStack pickUpStack = key.toStack(pickUpCount);
                    if (carried.m_41619_()) {
                        container.m_142503_(pickUpStack);
                        GenericStack newStock = ExportOnlyAESlot.copy(slot.getStock(), amount - (long)pickUpCount);
                        slot.setStock(newStock.amount() == 0L ? null : newStock);
                        clickResult = pickUpStack.m_41613_();
                    } else if (ItemStack.m_150942_((ItemStack)carried, (ItemStack)pickUpStack)) {
                        int canAdd = Math.min(pickUpCount, carried.m_41741_() - carried.m_41613_());
                        if (canAdd <= 0) {
                            return;
                        }
                        carried.m_41769_(canAdd);
                        GenericStack newStock = ExportOnlyAESlot.copy(slot.getStock(), amount - (long)canAdd);
                        slot.setStock(newStock.amount() == 0L ? null : newStock);
                        clickResult = carried.m_41613_();
                    } else {
                        clickResult = -1;
                    }
                }
                if (clickResult < 0) break;
                this.writeUpdateInfo(1003, buf -> buf.m_130130_(clickResult));
                break;
            }
            case 1004: {
                AEKey key;
                boolean isCtrlDown = buffer.readBoolean();
                if (slot.getStock() == null || !((key = slot.getStock().what()) instanceof AEItemKey)) {
                    return;
                }
                AEItemKey key2 = (AEItemKey)key;
                Player player = this.gui.entityPlayer;
                if (player == null) {
                    return;
                }
                long amount = slot.getStock().amount();
                int maxStackSize = key2.getMaxStackSize();
                int dropCount = isCtrlDown ? (int)Math.min(amount, (long)maxStackSize) : 1;
                ItemStack dropStack = key2.toStack(dropCount);
                player.m_36176_(dropStack, true);
                GenericStack newStock = ExportOnlyAESlot.copy(slot.getStock(), amount - (long)dropCount);
                slot.setStock(newStock.amount() == 0L ? null : newStock);
                this.writeUpdateInfo(1004, buf -> buf.m_130103_(newStock.amount() == 0L ? 0L : newStock.amount()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        super.readUpdateInfo(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        switch (id) {
            case 1000: {
                slot.setConfig(null);
                break;
            }
            case 1001: {
                ItemStack item = buffer.m_130267_();
                slot.setConfig(new GenericStack((AEKey)AEItemKey.of((ItemStack)item), (long)item.m_41613_()));
                break;
            }
            case 1002: {
                if (slot.getConfig() == null) break;
                long amt = buffer.m_130258_();
                slot.setConfig(new GenericStack(slot.getConfig().what(), amt));
                break;
            }
            case 1003: {
                if (slot.getStock() == null || !(slot.getStock().what() instanceof AEItemKey)) break;
                ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
                int newStackSize = buffer.m_130242_();
                currentStack.m_41764_(newStackSize);
                this.gui.getModularUIContainer().m_142503_(currentStack);
                long amount = buffer.m_130258_();
                slot.setStock(ExportOnlyAESlot.copy(slot.getStock(), amount));
                break;
            }
            case 1004: {
                if (slot.getStock() == null || !(slot.getStock().what() instanceof AEItemKey)) break;
                long amt = buffer.m_130258_();
                slot.setStock(ExportOnlyAESlot.copy(slot.getStock(), amt));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rect2i getRectangleBox() {
        Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        return rectangle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void acceptItem(ItemStack itemStack) {
        this.writeClientAction(1001, buf -> buf.m_130055_(itemStack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        long amt;
        if (this.parentWidget.isStocking()) {
            return false;
        }
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        if (slot.getConfig() == null || wheelDelta == 0.0 || !rectangle.m_110087_((int)mouseX, (int)mouseY)) {
            return false;
        }
        GenericStack stack = slot.getConfig();
        if (AEItemConfigSlotWidget.isCtrlDown()) {
            amt = wheelDelta > 0.0 ? stack.amount() << 1 : stack.amount() / 2L;
        } else {
            long l = amt = wheelDelta > 0.0 ? stack.amount() + 1L : stack.amount() - 1L;
        }
        if (amt > 0L && amt < 0x80000000L) {
            this.writeClientAction(1002, buf -> buf.m_130103_(amt));
            return true;
        }
        return false;
    }

    private void transferToPlayerInventory(Player player, ItemStack stack) {
        Inventory playerInv = player.m_150109_();
        while (!stack.m_41619_()) {
            int slotIndex = playerInv.m_36050_(stack);
            if (slotIndex != -1) {
                ItemStack itemInSlot = playerInv.m_8020_(slotIndex);
                int spaceAvailable = itemInSlot.m_41741_() - itemInSlot.m_41613_();
                int moveCount = Math.min(stack.m_41613_(), spaceAvailable);
                itemInSlot.m_41769_(moveCount);
                stack.m_41774_(moveCount);
                continue;
            }
            slotIndex = playerInv.m_36062_();
            if (slotIndex == -1) break;
            int moveCount = Math.min(stack.m_41613_(), stack.m_41741_());
            ItemStack moveStack = stack.m_41777_();
            moveStack.m_41764_(moveCount);
            playerInv.m_6836_(slotIndex, moveStack);
            stack.m_41774_(moveCount);
        }
    }
}

