/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.machine.multiblock.part.SensorPartMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.MathUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class PHNeutralizationPurificationUnitMachine
extends WaterPurificationUnitMachine {
    private static final ItemStack SodiumHydroxide = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.SodiumHydroxide);
    private static final Fluid HydrochloricAcid = GTMaterials.HydrochloricAcid.getFluid();
    @Persisted
    private float ph = 7.0f;
    @Persisted
    private long inputCount;
    private final List<SensorPartMachine> sensorPartMachines = new ArrayList<SensorPartMachine>(2);

    public PHNeutralizationPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 8L);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (part instanceof SensorPartMachine) {
            SensorPartMachine sensorPartMachine = (SensorPartMachine)part;
            this.sensorPartMachines.add(sensorPartMachine);
        }
    }

    @Override
    public void onStructureFormed() {
        this.sensorPartMachines.clear();
        super.onStructureFormed();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.sensorPartMachines.clear();
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237113_((String)("pH: " + this.ph)));
        }
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (this.getOffsetTimer() % 20 == 0) {
            int hc;
            int sh = MathUtil.saturatedCast((long)this.getItemAmount(new Item[]{SodiumHydroxide.m_41720_()})[0]);
            if (this.inputItem((ItemLike)SodiumHydroxide.m_41720_(), sh)) {
                this.ph = Math.min(14.0f, this.ph + (float)sh * 0.01f);
            }
            if (this.inputFluid(HydrochloricAcid, hc = MathUtil.saturatedCast((long)this.getFluidAmount(new Fluid[]{HydrochloricAcid})[0]))) {
                this.ph = Math.max(0.01f, this.ph - (float)hc * 0.001f);
            }
            this.sensorPartMachines.forEach(s -> s.update(this.ph));
        }
        return true;
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        if ((double)this.ph >= 6.95 && (double)this.ph <= 7.05) {
            this.outputFluid(WaterPurificationPlantMachine.GradePurifiedWater4, this.inputCount * 9L / 10L);
        }
    }

    @Override
    long before() {
        this.eut = 0L;
        this.ph = (float)Math.random() * 5.0f + 4.5f;
        this.inputCount = Math.min(this.parallel(), this.getFluidAmount(new Fluid[]{WaterPurificationPlantMachine.GradePurifiedWater3})[0]);
        if (this.inputCount > 0L) {
            this.recipe = this.getRecipeBuilder().duration(2400).inputFluids(WaterPurificationPlantMachine.GradePurifiedWater3, this.inputCount).buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                this.calculateVoltage(this.inputCount);
            }
        }
        return this.eut;
    }
}

