/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy.tradingstation;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CombinedDirectionalFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputBoth;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtocore.api.gui.InteractiveImageWidget;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.translation.GTOMachineTooltips;
import com.gtocore.common.item.GregMembershipCardItem;
import com.gtocore.data.transaction.manager.TradeData;
import com.gtocore.data.transaction.manager.TradeEntry;
import com.gtocore.data.transaction.manager.TradingManager;
import com.gtocore.data.transaction.manager.UnlockManager;
import com.gtolib.utils.WalletUtils;
import com.hepdd.gtmthings.utils.TeamUtil;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradingStationMachine
extends MetaMachine
implements IFancyUIMachine,
IAutoOutputBoth,
IMachineLife,
IControllable {
    @Persisted
    @DescSynced
    private final NotifiableItemStackHandler inputItem;
    @Persisted
    @DescSynced
    private final NotifiableItemStackHandler outputItem;
    @Persisted
    @DescSynced
    private final NotifiableFluidTank inputFluid;
    @Persisted
    @DescSynced
    private final NotifiableFluidTank outputFluid;
    @Persisted
    private final CustomItemStackHandler cardHandler;
    private static final int Item_slots_in_a_row = 4;
    private static final int Fluid_slots_in_a_row = 4;
    @Persisted
    private UUID uuid;
    @Persisted
    List<UUID> sharedUUIDs = new ArrayList<UUID>();
    @Persisted
    private UUID teamUUID;
    @Persisted
    @DescSynced
    private int groupSelected = 0;
    private int shopSelected = -1;
    private static final int width = 336;
    private static final int height = 144;
    private static final String TEXT_HEADER = "gtocore.trading_station.textList.";
    @Persisted
    @DescSynced
    private Direction outputFacingItems = Direction.DOWN;
    @Persisted
    @DescSynced
    private Direction outputFacingFluids = Direction.DOWN;
    @Persisted
    @DescSynced
    private boolean autoOutputItems = false;
    @Persisted
    @DescSynced
    private boolean autoOutputFluids = false;
    @Nullable
    private TickableSubscription autoOutputSubs;
    @Nullable
    private ISubscription outputItemChangeSub;
    @Nullable
    private ISubscription outputFluidChangeSub;
    private boolean allowInputFromOutputSideItems;
    private boolean allowInputFromOutputSideFluids;
    @Persisted
    private boolean working = false;

    public TradingStationMachine(MetaMachineBlockEntity holder, int tier) {
        super(holder);
        this.cardHandler = new CustomItemStackHandler();
        this.cardHandler.setFilter(i -> i.m_41720_() == GTOItems.GREG_MEMBERSHIP_CARD.m_5456_());
        this.cardHandler.setOnContentsChanged(() -> this.initializationInformation(this.cardHandler.getStackInSlot(0)));
        this.inputItem = new NotifiableItemStackHandler((MetaMachine)this, 32 * tier, IO.IN, IO.BOTH);
        this.outputItem = new NotifiableItemStackHandler((MetaMachine)this, 32 * tier, IO.OUT, IO.OUT);
        this.inputFluid = new NotifiableFluidTank((MetaMachine)this, tier * 4, 1000 * (8000 << tier), IO.IN, IO.BOTH);
        this.outputFluid = new NotifiableFluidTank((MetaMachine)this, tier * 4, 1000 * (8000 << tier), IO.OUT, IO.OUT);
    }

    public void onLoad() {
        super.onLoad();
        this.initializationInformation(this.cardHandler.getStackInSlot(0));
        if (!this.isRemote()) {
            this.outputItemChangeSub = this.outputItem.addChangedListener(this::updateAutoOutputSubscription);
            this.outputFluidChangeSub = this.outputFluid.addChangedListener(this::updateAutoOutputSubscription);
            this.updateAutoOutputSubscription();
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
        if (this.outputItemChangeSub != null) {
            this.outputItemChangeSub.unsubscribe();
            this.outputItemChangeSub = null;
        }
        if (this.outputFluidChangeSub != null) {
            this.outputFluidChangeSub.unsubscribe();
            this.outputFluidChangeSub = null;
        }
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.cardHandler);
        this.clearInventory((IItemHandlerModifiable)this.inputItem.storage);
        this.clearInventory((IItemHandlerModifiable)this.outputItem.storage);
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 344, 152);
        WidgetGroup mainGroup = new WidgetGroup(4, 4, 336, 144);
        mainGroup.setBackground(new IGuiTexture[]{GuiTextures.DISPLAY});
        mainGroup.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 34, 246, 110).setYScrollBarWidth(2).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(1.0f)).addWidget((Widget)new ComponentPanelWidget(0, 0, (List)GTOMachineTooltips.INSTANCE.getPanGalaxyGregTechTradingStationIntroduction().get()).setMaxWidthLimit(246)));
        Level level = this.getLevel();
        ServerLevel serverLevel = this.getLevel() instanceof ServerLevel ? (ServerLevel)this.getLevel() : null;
        mainGroup.addWidget(new SlotWidget((IItemHandlerModifiable)this.cardHandler, 0, 10, 10).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setHoverTooltips(new Component[]{TradingStationMachine.trans(11, new Object[0])}));
        Object2ObjectMap WalletPlayers = WalletUtils.getAllWalletPlayers((Level)serverLevel);
        mainGroup.addWidget((Widget)new ComponentPanelWidget(34, 14, textList -> {
            if (this.uuid == null) {
                textList.add(TradingStationMachine.trans(2, new Object[0]));
                return;
            }
            String playerName = (String)WalletPlayers.getOrDefault((Object)this.uuid, (Object)"Unknown");
            boolean hasShared = !this.sharedUUIDs.isEmpty();
            boolean hasTeam = Optional.ofNullable(this.teamUUID).filter(t -> !t.equals(this.uuid)).isPresent();
            if (hasShared || hasTeam) {
                String sharedText = this.sharedUUIDs.stream().map(shareUuid -> (String)WalletPlayers.getOrDefault(shareUuid, (Object)"Unknown")).collect(Collectors.joining(", "));
                MutableComponent sharedComponent = Component.m_237113_((String)sharedText);
                Optional.ofNullable(this.teamUUID).filter(t -> !t.equals(this.uuid)).map(t -> TeamUtil.GetName((Level)level, (UUID)this.uuid)).ifPresent(arg_0 -> ((MutableComponent)sharedComponent).m_7220_(arg_0));
                if (sharedComponent.getString().isEmpty()) {
                    sharedComponent = TradingStationMachine.trans(4, new Object[0]);
                }
                textList.add(ComponentPanelWidget.withHoverTextTranslate((Component)TradingStationMachine.trans(3, playerName), (Component)sharedComponent));
            } else {
                textList.add(TradingStationMachine.trans(3, playerName));
            }
        }).setMaxWidthLimit(222));
        mainGroup.addWidget((Widget)new InteractiveImageWidget(237, 10, 9, 9, (IGuiTexture)GTOGuiTextures.REFRESH).textSupplier(texts -> texts.add(TradingStationMachine.trans(8, new Object[0]))).clickHandler((data, clickData) -> {
            this.initializationInformation(this.cardHandler.getStackInSlot(0));
            Player player = mainGroup.getGui().entityPlayer;
            if (!this.isRemote() && player != null && this.shouldOpenUI(player, InteractionHand.MAIN_HAND, null)) {
                this.tryToOpenUI(player, InteractionHand.MAIN_HAND, null);
            }
        }));
        mainGroup.addWidget((Widget)new ImageWidget(253, 2, 2, 140, (IGuiTexture)GuiTextures.SLOT));
        mainGroup.addWidget((Widget)this.ShopGroupSwitchWidget());
        group.addWidget((Widget)mainGroup);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    public IGuiTexture getTabIcon() {
        return GuiTextures.GREGTECH_LOGO;
    }

    public void attachSideTabs(TabsWidget sideTabs) {
        sideTabs.setId("fancy_side_tabs");
        sideTabs.clearSubTabs();
        sideTabs.setMainTab((IFancyUIProvider)this);
        ArrayList<Object> fixedTabs = new ArrayList<Object>();
        if (this.groupSelected == 0) {
            fixedTabs.add(this.ItemStorageUI());
            fixedTabs.add(this.FluidStorageUI());
            fixedTabs.add(this.TransactionUnlock());
            fixedTabs.add(CombinedDirectionalFancyConfigurator.of((MetaMachine)this, (MetaMachine)this));
        }
        List<IFancyUIProvider> originalShopTabs = this.shopGroup();
        ArrayList<IFancyUIProvider> displayShopTabs = new ArrayList<IFancyUIProvider>(originalShopTabs);
        fixedTabs.forEach(arg_0 -> ((TabsWidget)sideTabs).attachSubTab(arg_0));
        displayShopTabs.forEach(arg_0 -> ((TabsWidget)sideTabs).attachSubTab(arg_0));
        sideTabs.setOnTabSwitch((oldTab, newTab) -> {
            if (newTab instanceof ShopTabProvider) {
                ShopTabProvider newShopTab = (ShopTabProvider)newTab;
                if (newShopTab.groupIndex == this.groupSelected) {
                    this.shopSelected = originalShopTabs.indexOf(newShopTab);
                } else {
                    this.shopSelected = -1;
                    sideTabs.selectTab(sideTabs.getMainTab());
                }
            } else {
                this.shopSelected = -1;
            }
            sideTabs.detectAndSendChanges();
            ModularUI modularUI = sideTabs.getGui();
            if (modularUI != null && modularUI.getModularUIGui() != null) {
                modularUI.getModularUIGui().m_7856_();
            }
        });
        if (this.shopSelected != -1 && this.shopSelected < originalShopTabs.size()) {
            sideTabs.selectTab(originalShopTabs.get(this.shopSelected));
        } else {
            sideTabs.selectTab(sideTabs.getMainTab());
        }
        sideTabs.detectAndSendChanges();
    }

    private WidgetGroup ShopGroupSwitchWidget() {
        WidgetGroup mainGroup = new WidgetGroup(256, 0, 80, 136);
        mainGroup.setLayout(Layout.VERTICAL_CENTER);
        mainGroup.setLayoutPadding(10);
        TradingManager.TradingShopGroup SwitchedShopGroup = TradingManager.INSTANCE.getShopGroup(this.groupSelected);
        if (SwitchedShopGroup == null) {
            SwitchedShopGroup = TradingManager.INSTANCE.getShopGroup(0);
        }
        if (SwitchedShopGroup != null) {
            mainGroup.addWidget((Widget)new ImageWidget(0, 0, 80, 13, (IGuiTexture)new TextTexture(Component.m_237115_((String)SwitchedShopGroup.getName()).m_6881_().getString()).setDropShadow(false).setType(TextTexture.TextType.ROLL).setWidth(80)));
            mainGroup.addWidget((Widget)new ImageWidget(0, 10, 64, 64, SwitchedShopGroup.getTexture1()));
        }
        WidgetGroup SwitchWidget2 = new WidgetGroup(0, 80, 79, 39);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 8; ++x) {
                int index = y * 8 + x;
                TradingManager.TradingShopGroup shopGroup = TradingManager.INSTANCE.getShopGroup(index);
                if (shopGroup != null) {
                    SwitchWidget2.addWidget(new InteractiveImageWidget(x * 10, y * 10, 9, 9, shopGroup.getTexture2()).textSupplier(texts -> texts.add(Component.m_237115_((String)shopGroup.getName()))).clickHandler((data, clickData) -> {
                        if (this.groupSelected != index) {
                            this.groupSelected = index;
                            this.shopSelected = -1;
                            this.markAsDirty();
                            Player player = SwitchWidget2.getGui().entityPlayer;
                            if (!this.isRemote() && player != null && this.shouldOpenUI(player, InteractionHand.MAIN_HAND, null)) {
                                this.tryToOpenUI(player, InteractionHand.MAIN_HAND, null);
                            }
                        }
                    }).setBackground(new IGuiTexture[]{GTOGuiTextures.BOXED_BACKGROUND}));
                    continue;
                }
                SwitchWidget2.addWidget((Widget)new ImageWidget(x * 10, y * 10, 9, 9, (IGuiTexture)GTOGuiTextures.BOXED_BACKGROUND));
            }
        }
        mainGroup.addWidget((Widget)SwitchWidget2);
        return mainGroup;
    }

    @NotNull
    private IFancyUIProvider ItemStorageUI() {
        return new IFancyUIProvider(){

            public IGuiTexture getTabIcon() {
                return new ItemStackTexture(new Item[]{Blocks.f_50087_.m_5456_()});
            }

            public Component getTitle() {
                return Component.m_237115_((String)"gtocore.trading_station.item_storage");
            }

            public List<Component> getTabTooltips() {
                return Collections.singletonList(Component.m_237115_((String)"gtocore.trading_station.item_storage"));
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                WidgetGroup group = new WidgetGroup(0, 0, 176, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 169, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY).setYScrollBarWidth(2).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(1.0f));
                int itemHigh = TradingStationMachine.this.inputItem.getSize() / 4;
                WidgetGroup Item_slot = new WidgetGroup(2, 4, 168, itemHigh * 18 + 10);
                Item_slot.addWidget((Widget)new ComponentPanelWidget(0, 0, List.of(Component.m_237115_((String)"gtocore.trading_station.item_storage"))));
                block0: for (int y = 0; y < itemHigh; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        int slotIndex = y * 4 + x;
                        if (TradingStationMachine.this.inputItem.getSize() <= slotIndex) continue block0;
                        Item_slot.addWidget(new SlotWidget((IItemHandlerModifiable)TradingStationMachine.this.inputItem, slotIndex, x * 18, 10 + y * 18, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}));
                        Item_slot.addWidget(new SlotWidget((IItemHandlerModifiable)TradingStationMachine.this.outputItem, slotIndex, x * 18 + 72 + 18, 10 + y * 18, true, false).setBackground(new IGuiTexture[]{GuiTextures.SLOT}));
                    }
                }
                mainGroup.addWidget((Widget)Item_slot);
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }
        };
    }

    @NotNull
    private IFancyUIProvider FluidStorageUI() {
        return new IFancyUIProvider(){

            public IGuiTexture getTabIcon() {
                return new ItemStackTexture(new Item[]{Items.f_42446_});
            }

            public Component getTitle() {
                return Component.m_237115_((String)"gtocore.trading_station.fluid_storage");
            }

            public List<Component> getTabTooltips() {
                return Collections.singletonList(Component.m_237115_((String)"gtocore.trading_station.fluid_storage"));
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                WidgetGroup group = new WidgetGroup(0, 0, 176, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 169, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY).setYScrollBarWidth(2).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(1.0f));
                int fluidHigh = TradingStationMachine.this.inputFluid.getSize() / 4;
                WidgetGroup Fluid_slot = new WidgetGroup(2, 4, 168, fluidHigh * 18 + 10);
                Fluid_slot.addWidget((Widget)new ComponentPanelWidget(0, 0, List.of(Component.m_237115_((String)"gtocore.trading_station.fluid_storage"))));
                block0: for (int y = 0; y < fluidHigh; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        int slotIndex = y * 4 + x;
                        if (TradingStationMachine.this.inputFluid.getSize() <= slotIndex) continue block0;
                        Fluid_slot.addWidget((Widget)new TankWidget((IFluidHandler)TradingStationMachine.this.inputFluid, slotIndex, x * 18, 10 + y * 18, true, true).setBackground((IGuiTexture)GuiTextures.SLOT_DARK));
                        Fluid_slot.addWidget((Widget)new TankWidget((IFluidHandler)TradingStationMachine.this.outputFluid, slotIndex, x * 18 + 72 + 18, 10 + y * 18, true, true).setBackground((IGuiTexture)GuiTextures.SLOT_DARK));
                    }
                }
                mainGroup.addWidget((Widget)Fluid_slot);
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }
        };
    }

    @NotNull
    private IFancyUIProvider TransactionUnlock() {
        return new IFancyUIProvider(){
            @DescSynced
            private String upgradeSelect = null;
            private int internalPageSelected = 0;

            public IGuiTexture getTabIcon() {
                return GuiTextures.BUTTON_LOCK;
            }

            public Component getTitle() {
                return Component.m_237115_((String)"gtocore.trading_station.unlock_shop");
            }

            public List<Component> getTabTooltips() {
                return Collections.singletonList(Component.m_237115_((String)"gtocore.trading_station.unlock_shop"));
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                WidgetGroup group = new WidgetGroup(0, 0, 344, 152);
                WidgetGroup mainGroup = new WidgetGroup(4, 4, 336, 144);
                mainGroup.setBackground(new IGuiTexture[]{GuiTextures.DISPLAY});
                WidgetGroup tradeContainer = new WidgetGroup(0, 12, 204, 101);
                DraggableScrollableWidgetGroup leftPanel = new DraggableScrollableWidgetGroup(0, 5, 110, 134);
                leftPanel.setLayout(Layout.VERTICAL_CENTER);
                leftPanel.setLayoutPadding(8);
                leftPanel.addWidget((Widget)new ComponentPanelWidget(0, 0, textList -> textList.add(TradingStationMachine.trans(21, new Object[0]))).setSpace(8).setCenter(true));
                leftPanel.addWidget((Widget)new ComponentPanelWidget(0, 10, textList -> {
                    Set<String> keySet = UnlockManager.INSTANCE.getKeySet();
                    if (keySet == null) {
                        return;
                    }
                    for (String key : keySet) {
                        textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)key), (String)key).m_6881_().m_130940_(ChatFormatting.AQUA));
                    }
                }).clickHandler((upgrade, clickData) -> {
                    this.upgradeSelect = upgrade;
                    this.internalPageSelected = 0;
                    this.updateWidget(tradeContainer, widget2);
                }).setSpace(8).setCenter(true));
                DraggableScrollableWidgetGroup rightPanel = new DraggableScrollableWidgetGroup(110, 8, 226, 134);
                rightPanel.setLayout(Layout.VERTICAL_CENTER);
                rightPanel.setLayoutPadding(4);
                rightPanel.addWidget((Widget)new ComponentPanelWidget(0, 0, textList -> {
                    if (this.upgradeSelect != null) {
                        textList.add(Component.m_237115_((String)this.upgradeSelect));
                    }
                }));
                this.updateWidget(tradeContainer, widget2);
                rightPanel.addWidget((Widget)tradeContainer);
                rightPanel.addWidget((Widget)new ComponentPanelWidget(0, 5, textList -> {
                    int tradeCount = this.getCurrentTradeCount();
                    if (tradeCount <= 10) {
                        return;
                    }
                    int totalPage = tradeCount / 10 + (tradeCount % 10 == 0 ? 0 : 1);
                    textList.add(Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2190 ] "), (String)"previous_page")).m_7220_((Component)Component.m_237113_((String)(" " + (this.internalPageSelected + 1) + "/" + totalPage + " "))).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2192 ] "), (String)"next_page")));
                }).clickHandler((data, clickData) -> {
                    int tradeCount = this.getCurrentTradeCount();
                    int totalPage = tradeCount / 10 + (tradeCount % 10 == 0 ? 0 : 1);
                    if (totalPage <= 1) {
                        return;
                    }
                    switch (data) {
                        case "previous_page": {
                            this.internalPageSelected = Mth.m_14045_((int)(this.internalPageSelected - 1), (int)0, (int)(totalPage - 1));
                            break;
                        }
                        case "next_page": {
                            this.internalPageSelected = Mth.m_14045_((int)(this.internalPageSelected + 1), (int)0, (int)(totalPage - 1));
                        }
                    }
                    this.updateWidget(tradeContainer, widget2);
                    widget2.detectAndSendChanges();
                }));
                mainGroup.addWidget((Widget)leftPanel);
                mainGroup.addWidget((Widget)rightPanel);
                mainGroup.addWidget((Widget)new ImageWidget(109, 5, 2, 134, (IGuiTexture)GuiTextures.SLOT));
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }

            private int getCurrentTradeCount() {
                if (this.upgradeSelect == null) {
                    return 0;
                }
                return UnlockManager.INSTANCE.getEntryTradeCount(this.upgradeSelect);
            }

            private void updateWidget(WidgetGroup container, FancyMachineUIWidget widget2) {
                container.clearAllWidgets();
                if (this.upgradeSelect == null) {
                    return;
                }
                container.addWidget((Widget)this.tradeGroup_10(this.upgradeSelect, this.internalPageSelected));
                widget2.detectAndSendChanges();
            }

            private WidgetGroup tradeGroup_10(String key, int pageIndex) {
                WidgetGroup tradeGroup = new WidgetGroup(0, 0, 204, 101);
                int startIndex = pageIndex * 10;
                for (int row = 0; row < 2; ++row) {
                    for (int col = 0; col < 5; ++col) {
                        int X = col * 41;
                        int Y = row * 51;
                        int entryIndex = startIndex + row * 5 + col;
                        TradeEntry tradeEntry = UnlockManager.INSTANCE.getTradeEntry(key, entryIndex);
                        if (tradeEntry != null) {
                            tradeGroup.addWidget((Widget)TradingStationMachine.this.trade(X, Y, true, tradeEntry));
                            continue;
                        }
                        tradeGroup.addWidget((Widget)TradingStationMachine.this.emptyTrade(X, Y));
                    }
                }
                return tradeGroup;
            }
        };
    }

    private List<IFancyUIProvider> shopGroup() {
        ArrayList<IFancyUIProvider> shopGroupTabs = new ArrayList<IFancyUIProvider>();
        for (int shop = 0; shop < TradingManager.INSTANCE.getShopCount(this.groupSelected); ++shop) {
            TradingManager.TradingShop tradingShop = TradingManager.INSTANCE.getShopByIndices(this.groupSelected, shop);
            shopGroupTabs.add(new ShopTabProvider(this, this.groupSelected, shop, tradingShop));
        }
        return shopGroupTabs;
    }

    private WidgetGroup tradeGroup_16(int groupIndex, int shopIndex, int pageIndex, boolean unlockShop) {
        WidgetGroup tradeGroup = new WidgetGroup(0, 0, 327, 102);
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 8; ++col) {
                int X = col * 41;
                int Y = row * 51;
                int entryIndex = pageIndex * 16 + row * 8 + col;
                boolean isIndexValid = TradingManager.INSTANCE.isTradeIndexValid(groupIndex, shopIndex, entryIndex);
                if (isIndexValid) {
                    tradeGroup.addWidget((Widget)this.trade(X, Y, unlockShop, TradingManager.INSTANCE.getTradeEntryByIndices(groupIndex, shopIndex, entryIndex)));
                    continue;
                }
                tradeGroup.addWidget((Widget)this.emptyTrade(X, Y));
            }
        }
        return tradeGroup;
    }

    private WidgetGroup trade(int x, int y, boolean unlockShop, TradeEntry entry) {
        WidgetGroup trade = new WidgetGroup(x, y, 40, 50);
        trade.setBackground(new IGuiTexture[]{GTOGuiTextures.BOXED_BACKGROUND});
        ServerLevel serverLevel = this.getLevel() instanceof ServerLevel ? (ServerLevel)this.getLevel() : null;
        TradeData tradeData = new TradeData(this.getLevel(), this.getPos(), (IItemHandlerModifiable)this.inputItem, (IItemHandlerModifiable)this.outputItem, (IFluidHandlerModifiable)this.inputFluid, (IFluidHandlerModifiable)this.outputFluid, this.uuid, this.sharedUUIDs, this.teamUUID);
        boolean unlock = WalletUtils.containsTagValueInWallet((UUID)this.uuid, (Level)serverLevel, (String)"Unlock Trade", (String)entry.unlockCondition());
        boolean canExecute = entry.canExecuteCount(tradeData) != 0;
        trade.addWidget((Widget)new InteractiveImageWidget(2, 7, 36, 36, entry.texture()).textSupplier(texts -> {
            if (!unlock) {
                texts.add(Component.m_237110_((String)"gtocore.trade_group.unlock", (Object[])new Object[]{entry.unlockCondition()}).m_130940_(ChatFormatting.DARK_RED));
            }
            if (!canExecute) {
                texts.add(Component.m_237115_((String)"gtocore.trade_group.unsatisfied").m_130940_(ChatFormatting.DARK_RED));
            }
            int k = 0;
            if (unlock && canExecute) {
                k = entry.check(tradeData);
                texts.add(Component.m_237110_((String)"gtocore.trade_group.amount", (Object[])new Object[]{FormattingUtil.formatNumbers((int)k)}).m_130940_(ChatFormatting.GOLD));
            }
            texts.addAll(entry.getDescription());
            if (k >= 10) {
                texts.add(Component.m_237115_((String)"gtocore.trade_group.repeatedly1"));
            }
            if (k >= 100) {
                texts.add(Component.m_237115_((String)"gtocore.trade_group.repeatedly2"));
            }
        }).clickHandler((data, clickData) -> {
            if (!unlockShop) {
                return;
            }
            if (!unlock) {
                return;
            }
            int multiplier = clickData.isCtrlClick ? (clickData.isShiftClick ? 100 : 10) : 1;
            entry.executeTrade(tradeData, multiplier);
        }));
        return trade;
    }

    private ImageWidget emptyTrade(int x, int y) {
        return new ImageWidget(x, y, 40, 50, (IGuiTexture)GTOGuiTextures.BOXED_BACKGROUND);
    }

    @NotNull
    private static MutableComponent trans(int id, Object ... args) {
        if (args.length == 1 && args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        return Component.m_237110_((String)(TEXT_HEADER + id), (Object[])args);
    }

    private void initializationInformation(ItemStack card) {
        if (card.m_41720_() == GTOItems.GREG_MEMBERSHIP_CARD.m_5456_()) {
            this.uuid = GregMembershipCardItem.getSingleUuid(card);
            this.sharedUUIDs = GregMembershipCardItem.getSharedUuids(card);
            if (this.uuid != null) {
                this.teamUUID = TeamUtil.getTeamUUID((UUID)this.uuid);
            }
        } else {
            this.uuid = null;
            this.sharedUUIDs = new ArrayList<UUID>();
            this.teamUUID = null;
        }
    }

    public boolean hasAutoOutputItem() {
        return this.outputItem.getSlots() > 0;
    }

    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    public void setAutoOutputItems(boolean autoOutputItems) {
        if (this.hasAutoOutputItem()) {
            this.autoOutputItems = autoOutputItems;
            this.updateAutoOutputSubscription();
        }
    }

    @Nullable
    public Direction getOutputFacingItems() {
        return this.hasAutoOutputItem() ? this.outputFacingItems : null;
    }

    public void setOutputFacingItems(@Nullable Direction direction) {
        if (this.hasAutoOutputItem() && direction != null) {
            this.outputFacingItems = direction;
            this.clearDirectionCache();
            this.updateAutoOutputSubscription();
        }
    }

    public boolean hasAutoOutputFluid() {
        return this.outputFluid.getTanks() > 0;
    }

    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    public void setAutoOutputFluids(boolean autoOutputFluids) {
        if (this.hasAutoOutputFluid()) {
            this.autoOutputFluids = autoOutputFluids;
            this.updateAutoOutputSubscription();
        }
    }

    @Nullable
    public Direction getOutputFacingFluids() {
        return this.hasAutoOutputFluid() ? this.outputFacingFluids : null;
    }

    public void setOutputFacingFluids(@Nullable Direction direction) {
        if (this.hasAutoOutputFluid() && direction != null) {
            this.outputFacingFluids = direction;
            this.clearDirectionCache();
            this.updateAutoOutputSubscription();
        }
    }

    private void updateAutoOutputSubscription() {
        boolean canOutputFluids;
        if (this.getLevel() == null || this.isRemote()) {
            return;
        }
        boolean canOutputItems = this.autoOutputItems && !this.outputItem.isEmpty() && this.getOutputFacingItems() != null && this.blockEntityDirectionCache.hasAdjacentItemHandler(this.getLevel(), this.getPos().m_121945_(this.getOutputFacingItems()), this.getOutputFacingItems().m_122424_());
        boolean bl = canOutputFluids = this.autoOutputFluids && !this.outputFluid.isEmpty() && this.getOutputFacingFluids() != null && this.blockEntityDirectionCache.hasAdjacentFluidHandler(this.getLevel(), this.getPos().m_121945_(this.getOutputFacingFluids()), this.getOutputFacingFluids().m_122424_());
        if (canOutputItems || canOutputFluids) {
            if (this.autoOutputSubs == null || !this.autoOutputSubs.stillSubscribed) {
                this.autoOutputSubs = this.subscribeServerTick(this::autoOutput, 20);
            }
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    private void autoOutput() {
        if (this.autoOutputItems && this.getOutputFacingItems() != null) {
            this.outputItem.exportToNearby(new Direction[]{this.getOutputFacingItems()});
        }
        if (this.autoOutputFluids && this.getOutputFacingFluids() != null) {
            this.outputFluid.exportToNearby(new Direction[]{this.getOutputFacingFluids()});
        }
        this.updateAutoOutputSubscription();
    }

    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.clearDirectionCache();
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSideFluids) {
        this.clearDirectionCache();
        this.allowInputFromOutputSideFluids = allowInputFromOutputSideFluids;
    }

    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    public void onNeighborChanged(@NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    public boolean isWorkingEnabled() {
        return this.working;
    }

    public void setWorkingEnabled(boolean var1) {
        this.working = var1;
    }

    @Generated
    public NotifiableItemStackHandler getInputItem() {
        return this.inputItem;
    }

    @Generated
    public NotifiableItemStackHandler getOutputItem() {
        return this.outputItem;
    }

    @Generated
    public NotifiableFluidTank getInputFluid() {
        return this.inputFluid;
    }

    @Generated
    public NotifiableFluidTank getOutputFluid() {
        return this.outputFluid;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public List<UUID> getSharedUUIDs() {
        return this.sharedUUIDs;
    }

    @Generated
    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    private static class ShopTabProvider
    implements IFancyUIProvider {
        private final TradingStationMachine machine;
        private final int groupIndex;
        private final int shopIndex;
        private final TradingManager.TradingShop tradingShop;
        private int localPageSelected = 0;

        private ShopTabProvider(TradingStationMachine machine, int groupIndex, int shopIndex, TradingManager.TradingShop tradingShop) {
            this.machine = machine;
            this.groupIndex = groupIndex;
            this.shopIndex = shopIndex;
            this.tradingShop = tradingShop;
        }

        public IGuiTexture getTabIcon() {
            return this.tradingShop.getTexture();
        }

        public Component getTitle() {
            return Component.m_237115_((String)this.tradingShop.getName());
        }

        public List<Component> getTabTooltips() {
            return Collections.singletonList(Component.m_237115_((String)this.tradingShop.getName()));
        }

        public Widget createMainPage(FancyMachineUIWidget widget2) {
            WidgetGroup group = new WidgetGroup(0, 0, 344, 152);
            WidgetGroup mainGroup = new WidgetGroup(4, 4, 336, 144);
            mainGroup.setBackground(new IGuiTexture[]{GuiTextures.DISPLAY});
            int tradeCount = TradingManager.INSTANCE.getTradeCount(this.groupIndex, this.shopIndex);
            int totalPage = tradeCount / 16 + (tradeCount % 16 == 0 ? 0 : 1);
            WidgetGroup shopGroup = new WidgetGroup(0, 0, 336, 144);
            shopGroup.setLayout(Layout.VERTICAL_CENTER);
            shopGroup.setLayoutPadding(3);
            ServerLevel serverLevel = this.machine.getLevel() instanceof ServerLevel ? (ServerLevel)this.machine.getLevel() : null;
            boolean unlockShop = WalletUtils.containsTagValueInWallet((UUID)this.machine.getUuid(), (Level)serverLevel, (String)"Unlock Shop", (String)this.tradingShop.getUnlockCondition());
            shopGroup.addWidget((Widget)new LabelWidget(0, 0, (Component)Component.m_237115_((String)this.tradingShop.getName())));
            DraggableScrollableWidgetGroup componentGroup = new DraggableScrollableWidgetGroup(4, 12, 328, 10).setScrollWheelDirection(DraggableScrollableWidgetGroup.ScrollWheelDirection.HORIZONTAL);
            componentGroup.addWidget((Widget)new ComponentPanelWidget(0, 0, textList -> {
                MutableComponent component = Component.m_237119_();
                if (!unlockShop) {
                    component.m_7220_((Component)TradingStationMachine.trans(20, this.tradingShop.getUnlockCondition()).m_130940_(ChatFormatting.RED));
                }
                for (String string : this.tradingShop.getCurrencies()) {
                    component.m_7220_((Component)Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[")).m_7220_((Component)Component.m_237115_((String)("gtocore.currency." + string))).m_7220_((Component)Component.m_237113_((String)"-")).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers((long)WalletUtils.getCurrencyAmount((UUID)this.machine.getUuid(), (Level)serverLevel, (String)string)))).m_7220_((Component)Component.m_237113_((String)"]")));
                    textList.add(component);
                }
            }));
            shopGroup.addWidget((Widget)componentGroup);
            WidgetGroup tradeContainer = new WidgetGroup(0, 36, 327, 102);
            this.updateTradeContainer(tradeContainer, this.localPageSelected, unlockShop);
            shopGroup.addWidget((Widget)tradeContainer);
            shopGroup.addWidget((Widget)new ComponentPanelWidget(0, 140, textList -> textList.add(Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2190 ] "), (String)"previous_page")).m_7220_((Component)Component.m_237113_((String)("<" + (this.localPageSelected + 1) + "/" + totalPage + ">"))).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2192 ] "), (String)"next_page")))).clickHandler((data, clickData) -> {
                switch (data) {
                    case "previous_page": {
                        this.localPageSelected = Mth.m_14045_((int)(this.localPageSelected - 1), (int)0, (int)(totalPage - 1));
                        break;
                    }
                    case "next_page": {
                        this.localPageSelected = Mth.m_14045_((int)(this.localPageSelected + 1), (int)0, (int)(totalPage - 1));
                    }
                }
                this.updateTradeContainer(tradeContainer, this.localPageSelected, unlockShop);
                widget2.detectAndSendChanges();
            }));
            mainGroup.addWidget((Widget)shopGroup);
            group.addWidget((Widget)mainGroup);
            group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            return group;
        }

        private void updateTradeContainer(WidgetGroup container, int pageIndex, boolean unlockShop) {
            container.clearAllWidgets();
            container.addWidget((Widget)this.machine.tradeGroup_16(this.groupIndex, this.shopIndex, pageIndex, unlockShop));
        }

        @Generated
        public int getShopIndex() {
            return this.shopIndex;
        }
    }
}

