/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gtocore.common.recipe.condition.AbstractRecipeCondition;
import com.gtolib.GTOCore;
import com.gtolib.api.recipe.Recipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class RestrictedMachineCondition
extends AbstractRecipeCondition {
    private static final RestrictedMachineCondition MULTIBLOCK = new RestrictedMachineCondition(GTOCore.id((String)"multiblock"));
    private final ResourceLocation id;
    private MachineDefinition definition;

    public static RestrictedMachineCondition multiblock() {
        return MULTIBLOCK;
    }

    public RestrictedMachineCondition(ResourceLocation id) {
        this.id = id;
    }

    public RecipeConditionType<?> getType() {
        return RESTRICTED_MACHINE;
    }

    public Component getTooltips() {
        if (this.id.equals((Object)RestrictedMachineCondition.MULTIBLOCK.id)) {
            return Component.m_237110_((String)"gtocore.recipe.restricted_machine", (Object[])new Object[]{Component.m_237115_((String)"gtceu.multiblock.title")});
        }
        if (this.definition == null) {
            this.definition = (MachineDefinition)GTRegistries.MACHINES.get((Object)this.id);
        }
        MachineDefinition machineDefinition = this.definition;
        return Component.m_237110_((String)"gtocore.recipe.restricted_machine", (Object[])new Object[]{machineDefinition == null ? "null" : Component.m_237115_((String)machineDefinition.getDescriptionId())});
    }

    @Override
    public boolean test(@NotNull Recipe recipe, @NotNull RecipeLogic recipeLogic) {
        MachineDefinition machineDefinition = recipeLogic.getMachine().getDefinition();
        if (((Object)((Object)this)).equals((Object)MULTIBLOCK)) {
            return recipeLogic.getMachine() instanceof MultiblockControllerMachine;
        }
        return machineDefinition.getId().equals((Object)this.id);
    }
}

