/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gtocore.common.data.GTODamageTypes;
import com.gtocore.data.lang.LangHandler;
import com.gtocore.data.tag.TagsHandler;
import com.gtolib.api.lang.SimplifiedChineseLanguageProvider;
import com.gtolib.api.lang.TraditionalChineseLanguageProvider;
import com.gtolib.api.registries.GTORegistration;
import com.tterrag.registrate.providers.ProviderType;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class Datagen {
    public static void init() {
        if (GTCEu.isDataGen()) {
            GTORegistration.GTO.addDataGenerator(ProviderType.BLOCK_TAGS, TagsHandler::initBlock);
            GTORegistration.GTO.addDataGenerator(ProviderType.ITEM_TAGS, TagsHandler::initItem);
            GTORegistration.GTO.addDataGenerator(ProviderType.LANG, LangHandler::enInitialize);
            GTORegistration.GTO.addDataGenerator(SimplifiedChineseLanguageProvider.LANG, LangHandler::cnInitialize);
            GTORegistration.GTO.addDataGenerator(TraditionalChineseLanguageProvider.LANG, LangHandler::twInitialize);
        }
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture future = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(generator.getPackOutput(), future, GTODamageTypes.DAMAGE_TYPES_BUILDER, Set.of("minecraft", "gtocore")));
        }
    }
}

