/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.lootTables.GTOLootTool;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.gtocore.data.lootTables.GTOLootTool.GTONumberProviders;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomLogicNumberProvider
implements NumberProvider {
    public static final CustomLogicNumberProvider INSTANCE = new CustomLogicNumberProvider((thisEntity, lastDamagePlayer, damageSource, killerEntity, directKiller, origin, blockState, blockEntity, tool, explosionRadius, level) -> ConstantValue.m_165692_((float)0.0f));
    private final NumberLogic logic;

    public CustomLogicNumberProvider(NumberLogic logic) {
        this.logic = logic;
    }

    public int m_142683_(@NotNull LootContext context) {
        return this.getNumberProvider(context).m_142683_(context);
    }

    public float m_142688_(@NotNull LootContext context) {
        return this.getNumberProvider(context).m_142688_(context);
    }

    private NumberProvider getNumberProvider(LootContext context) {
        ServerLevel level = context.m_78952_();
        if (level.m_5776_()) {
            return ConstantValue.m_165692_((float)0.0f);
        }
        Entity thisEntity = (Entity)this.getParam(context, LootContextParams.f_81455_);
        Player lastDamagePlayer = (Player)this.getParam(context, LootContextParams.f_81456_);
        DamageSource damageSource = (DamageSource)this.getParam(context, LootContextParams.f_81457_);
        Entity killerEntity = (Entity)this.getParam(context, LootContextParams.f_81458_);
        Entity directKiller = (Entity)this.getParam(context, LootContextParams.f_81459_);
        Vec3 origin = (Vec3)this.getParam(context, LootContextParams.f_81460_);
        BlockState blockState = (BlockState)this.getParam(context, LootContextParams.f_81461_);
        BlockEntity blockEntity = (BlockEntity)this.getParam(context, LootContextParams.f_81462_);
        ItemStack tool = this.getParamOrDefault(context, LootContextParams.f_81463_, ItemStack.f_41583_);
        Float explosionRadius = (Float)this.getParam(context, LootContextParams.f_81464_);
        return this.logic.calculate(thisEntity, lastDamagePlayer, damageSource, killerEntity, directKiller, origin, blockState, blockEntity, tool, explosionRadius, level);
    }

    @NotNull
    public LootNumberProviderType m_142587_() {
        return (LootNumberProviderType)GTONumberProviders.CUSTOM_LOGIC.get();
    }

    private <T> T getParam(LootContext context, LootContextParam<T> param) {
        return (T)context.m_78953_(param);
    }

    private <T> T getParamOrDefault(LootContext context, LootContextParam<T> param, T defaultValue) {
        Object value = context.m_78953_(param);
        return (T)(value != null ? value : defaultValue);
    }

    @FunctionalInterface
    public static interface NumberLogic {
        public NumberProvider calculate(@Nullable Entity var1, @Nullable Player var2, @Nullable DamageSource var3, @Nullable Entity var4, @Nullable Entity var5, @Nullable Vec3 var6, @Nullable BlockState var7, @Nullable BlockEntity var8, @NotNull ItemStack var9, @Nullable Float var10, @NotNull ServerLevel var11);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<CustomLogicNumberProvider> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(@NotNull JsonObject json, @NotNull CustomLogicNumberProvider provider, @NotNull JsonSerializationContext context) {
        }

        @NotNull
        public CustomLogicNumberProvider deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            return INSTANCE;
        }
    }

    public static class Builder {
        private final NumberLogic logic;

        public Builder(NumberLogic logic) {
            this.logic = logic;
        }

        public CustomLogicNumberProvider build() {
            return new CustomLogicNumberProvider(this.logic);
        }
    }
}

