/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.ars;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class EnchantingApparatusRecipeBuilder {
    private final ResourceLocation id;
    private Ingredient reagent;
    private ItemStack result;
    private final List<Ingredient> pedestalItems = new ArrayList<Ingredient>();
    private int sourceCost = 0;
    private boolean keepNbtOfReagent = false;

    public static EnchantingApparatusRecipeBuilder builder(String name) {
        return new EnchantingApparatusRecipeBuilder(GTOCore.id((String)("enchanting_apparatus/" + name)));
    }

    private EnchantingApparatusRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public EnchantingApparatusRecipeBuilder input(Ingredient reagent) {
        this.reagent = reagent;
        return this;
    }

    public EnchantingApparatusRecipeBuilder input(ItemLike item) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public EnchantingApparatusRecipeBuilder input(TagKey<Item> tag) {
        return this.input(Ingredient.m_204132_(tag));
    }

    public EnchantingApparatusRecipeBuilder output(ItemStack result) {
        this.result = result;
        return this;
    }

    public EnchantingApparatusRecipeBuilder output(ItemLike item) {
        return this.output(new ItemStack(item));
    }

    public EnchantingApparatusRecipeBuilder output(ItemLike item, int count) {
        return this.output(new ItemStack(item, count));
    }

    public EnchantingApparatusRecipeBuilder addPedestalItem(Ingredient ingredient) {
        if (ingredient != null) {
            this.pedestalItems.add(ingredient);
        }
        return this;
    }

    public EnchantingApparatusRecipeBuilder addPedestalItem(ItemLike item) {
        return this.addPedestalItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public EnchantingApparatusRecipeBuilder addPedestalItem(TagKey<Item> tag) {
        return this.addPedestalItem(Ingredient.m_204132_(tag));
    }

    public EnchantingApparatusRecipeBuilder sourceCost(int cost) {
        this.sourceCost = cost;
        return this;
    }

    public EnchantingApparatusRecipeBuilder keepNbtOfReagent(boolean keepNbt) {
        this.keepNbtOfReagent = keepNbt;
        return this;
    }

    public void save() {
        if (this.reagent == null) {
            throw new IllegalStateException("No input specified for enchanting apparatus recipe");
        }
        if (this.result == null) {
            throw new IllegalStateException("No output specified for enchanting apparatus recipe");
        }
        if (this.pedestalItems.isEmpty()) {
            throw new IllegalStateException("No pedestal items added to enchanting apparatus recipe");
        }
        GTRecipes.RECIPE_MAP.put(this.id, new EnchantingApparatusRecipe(this.id, this.pedestalItems, this.reagent, this.result, this.sourceCost, this.keepNbtOfReagent));
    }
}

