/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.crafting.PetalsRecipe;

public final class PetalApothecaryRecipeBuilder {
    private final ResourceLocation id;
    private ItemStack output;
    private Ingredient reagent;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    public static PetalApothecaryRecipeBuilder builder(String name) {
        return new PetalApothecaryRecipeBuilder(GTOCore.id((String)("petal_apothecary/" + name)));
    }

    private PetalApothecaryRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public PetalApothecaryRecipeBuilder output(ItemLike output) {
        return this.output(new ItemStack(output));
    }

    public PetalApothecaryRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public PetalApothecaryRecipeBuilder reagent(Ingredient reagent) {
        this.reagent = reagent;
        return this;
    }

    public PetalApothecaryRecipeBuilder reagent(ItemLike reagent) {
        return this.reagent(Ingredient.m_43929_((ItemLike[])new ItemLike[]{reagent}));
    }

    public PetalApothecaryRecipeBuilder reagent(TagKey<Item> reagentTag) {
        return this.reagent(Ingredient.m_204132_(reagentTag));
    }

    public PetalApothecaryRecipeBuilder addIngredient(Ingredient ingredient) {
        if (ingredient != null) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public PetalApothecaryRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public PetalApothecaryRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.m_204132_(tag));
    }

    public void save() {
        GTRecipes.RECIPE_MAP.put(this.id, new PetalsRecipe(this.id, this.output, this.reagent, this.ingredients.toArray(new Ingredient[0])));
    }
}

