/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.research;

import com.gregtechceu.gtceu.common.data.GTItems;
import com.gtocore.common.data.GTOItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class ExResearchManager {
    private static final int FNV_OFFSET_BASIS = -2128831035;
    private static final int FNV_PRIME = 16777619;
    public static final String SCANNING_NBT_TAG = "scanning_research";
    public static final String SCANNING_ID_NBT_TAG = "scanning_id";
    public static final String SCANNING_SERIAL_NBT_TAG = "scanning_serial";
    public static final Int2ObjectMap<DataCrystal> scanningMap = new Int2ObjectOpenHashMap();
    public static final String ANALYZE_NBT_TAG = "analyze_research";
    public static final String ANALYZE_ID_NBT_TAG = "analyze_id";
    public static final String ANALYZE_SERIAL_NBT_TAG = "analyze_serial";
    public static final Int2ObjectMap<DataCrystal> analyzeMap = new Int2ObjectOpenHashMap();
    public static final String EMPTY_NBT_TAG = "empty_crystal";
    public static final String EMPTY_ID_NBT_TAG = "empty_id";
    public static final List<ItemStack> DataCrystalList;
    public static final List<ItemStack> ErrorDataCrystalList;
    public static final List<ItemStack> EmptyDataCrystalList;
    public static final List<Item> DataItemList;

    public static ItemStack getDataCrystalItem(int tier) {
        if (tier < 1 || tier > 5) {
            throw new IllegalArgumentException("Invalid crystal tier: " + tier + " (must be 1-5)");
        }
        return DataCrystalList.get(tier).m_41777_();
    }

    public static void writeScanningResearchToNBT(@NotNull CompoundTag stackCompound, @NotNull Object scanned, int dataTier, int dataCrystal) {
        String string;
        if (dataCrystal < 1 || dataCrystal > 5) {
            throw new IllegalArgumentException("dataCrystal must be 1-5, got " + dataCrystal);
        }
        if (!(scanned instanceof ItemStack) && !(scanned instanceof FluidStack)) {
            throw new IllegalArgumentException("scanned must be ItemStack or FluidStack");
        }
        if (scanned instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)scanned;
            string = ExResearchManager.itemStackToString(itemStack);
        } else {
            string = ExResearchManager.fluidStackToString((FluidStack)scanned);
        }
        String scanningId = string;
        int serial = ExResearchManager.generateSerialId(scanningId);
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(SCANNING_ID_NBT_TAG, scanningId);
        compound.m_128405_(SCANNING_SERIAL_NBT_TAG, serial);
        stackCompound.m_128365_(SCANNING_NBT_TAG, (Tag)compound);
        scanningMap.put(serial, (Object)new DataCrystal(scanningId, serial, dataTier, dataCrystal));
    }

    public static void writeAnalyzeResearchToMap(@NotNull String analyzeId, int dataTier, int dataCrystal) {
        if (dataCrystal < 1 || dataCrystal > 5) {
            throw new IllegalArgumentException("dataCrystal must be 1-5, got " + dataCrystal);
        }
        int serial = ExResearchManager.generateSerialId(analyzeId);
        analyzeMap.put(serial, (Object)new DataCrystal(analyzeId, serial, dataTier, dataCrystal));
    }

    public static ItemStack getDataCrystal(int serial) {
        DataCrystal data = (DataCrystal)analyzeMap.get(serial);
        if (data != null) {
            return ExResearchManager.createCrystalWithData(data, ANALYZE_NBT_TAG, ANALYZE_ID_NBT_TAG, ANALYZE_SERIAL_NBT_TAG);
        }
        data = (DataCrystal)scanningMap.get(serial);
        if (data != null) {
            return ExResearchManager.createCrystalWithData(data, SCANNING_NBT_TAG, SCANNING_ID_NBT_TAG, SCANNING_SERIAL_NBT_TAG);
        }
        return Items.f_42127_.m_7968_();
    }

    public static String itemStackToString(@NotNull ItemStack stack) {
        return stack.m_41613_() + "i-" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())).toString().replace(":", "-");
    }

    public static String fluidStackToString(@NotNull FluidStack stack) {
        return stack.getAmount() + "f-" + Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid())).toString().replace(":", "-");
    }

    private static int generateSerialId(@NotNull String dataId) {
        byte[] bytes;
        int hash = -2128831035;
        for (byte b2 : bytes = dataId.getBytes(StandardCharsets.UTF_8)) {
            hash ^= b2 & 0xFF;
            hash *= 16777619;
        }
        return hash;
    }

    private static ItemStack createCrystalWithData(@NotNull DataCrystal data, String nbtTag, String idTag, String serialTag) {
        ItemStack crystalStack = ExResearchManager.getDataCrystalItem(data.crystal());
        CompoundTag stackTag = crystalStack.m_41784_();
        CompoundTag dataTag = new CompoundTag();
        dataTag.m_128359_(idTag, data.data());
        dataTag.m_128405_(serialTag, data.serial());
        stackTag.m_128365_(nbtTag, (Tag)dataTag);
        return crystalStack;
    }

    static {
        analyzeMap.put(0, (Object)new DataCrystal("empty", 0, 0, 0));
        DataCrystalList = new ArrayList<ItemStack>();
        DataCrystalList.addFirst(Items.f_42127_.m_7968_());
        DataCrystalList.add(1, GTOItems.DATA_CRYSTAL_MK1.asStack());
        DataCrystalList.add(2, GTOItems.DATA_CRYSTAL_MK2.asStack());
        DataCrystalList.add(3, GTOItems.DATA_CRYSTAL_MK3.asStack());
        DataCrystalList.add(4, GTOItems.DATA_CRYSTAL_MK4.asStack());
        DataCrystalList.add(5, GTOItems.DATA_CRYSTAL_MK5.asStack());
        ErrorDataCrystalList = new ArrayList<ItemStack>();
        ErrorDataCrystalList.addFirst(Items.f_42127_.m_7968_());
        int[] errorDataCrystal = new int[]{941104160, 991437017, 974659398, 1024992255, 1008214636};
        for (int tier = 1; tier <= 5; ++tier) {
            ItemStack emptyStack = ExResearchManager.getDataCrystalItem(tier);
            CompoundTag stackTag = emptyStack.m_41784_();
            CompoundTag dataTag = new CompoundTag();
            dataTag.m_128359_(ANALYZE_ID_NBT_TAG, "error" + tier);
            dataTag.m_128405_(ANALYZE_SERIAL_NBT_TAG, errorDataCrystal[tier - 1]);
            stackTag.m_128365_(ANALYZE_NBT_TAG, (Tag)dataTag);
            ErrorDataCrystalList.add(tier, emptyStack);
        }
        EmptyDataCrystalList = new ArrayList<ItemStack>();
        EmptyDataCrystalList.addFirst(Items.f_42127_.m_7968_());
        for (int tier = 1; tier <= 5; ++tier) {
            ItemStack emptyStack = ExResearchManager.getDataCrystalItem(tier);
            CompoundTag stackTag = emptyStack.m_41784_();
            CompoundTag emptyTag = new CompoundTag();
            emptyTag.m_128405_(EMPTY_ID_NBT_TAG, 0);
            stackTag.m_128365_(EMPTY_NBT_TAG, (Tag)emptyTag);
            EmptyDataCrystalList.add(tier, emptyStack);
        }
        DataItemList = new ArrayList<Item>();
        DataItemList.addFirst(Items.f_42127_);
        DataItemList.add(1, GTItems.TOOL_DATA_STICK.m_5456_());
        DataItemList.add(2, GTItems.TOOL_DATA_ORB.m_5456_());
        DataItemList.add(3, GTItems.TOOL_DATA_MODULE.m_5456_());
        DataItemList.add(4, GTOItems.NEURAL_MATRIX.m_5456_());
        DataItemList.add(5, GTOItems.ATOMIC_ARCHIVES.m_5456_());
        DataItemList.add(6, GTOItems.OBSIDIAN_MATRIX.m_5456_());
        DataItemList.add(7, GTOItems.MICROCOSM.m_5456_());
    }

    public record DataCrystal(String data, int serial, int tier, int crystal) {
    }
}

