/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.classified;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOBedrockFluids;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTOOres;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.item.DimensionDataItem;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.recipe.RecipeBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

final class CosmosSimulation {
    CosmosSimulation() {
    }

    public static void init() {
        GTORecipeTypes.COSMOS_SIMULATION_RECIPES.recipeBuilder("cosmos_simulation1").inputItems(GTOBlocks.QUANTUM_CHROMODYNAMIC_CHARGE.m_5456_(), 64).inputFluids(GTOMaterials.CosmicElement, 1024000).outputItems(TagPrefix.dust, GTMaterials.Carbon, 2147483).outputItems(TagPrefix.dust, GTMaterials.Phosphorus, 2147483).outputItems(TagPrefix.dust, GTMaterials.Sulfur, 2147483).outputItems(TagPrefix.dust, GTMaterials.Selenium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Iodine, 2147483).outputItems(TagPrefix.dust, GTMaterials.Boron, 2147483).outputItems(TagPrefix.dust, GTMaterials.Silicon, 2147483).outputItems(TagPrefix.dust, GTMaterials.Germanium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Arsenic, 2147483).outputItems(TagPrefix.dust, GTMaterials.Antimony, 2147483).outputItems(TagPrefix.dust, GTMaterials.Tellurium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Astatine, 2147483).outputItems(TagPrefix.dust, GTMaterials.Aluminium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Gallium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Indium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Tin, 2147483).outputItems(TagPrefix.dust, GTMaterials.Thallium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Lead, 2147483).outputItems(TagPrefix.dust, GTMaterials.Bismuth, 2147483).outputItems(TagPrefix.dust, GTMaterials.Polonium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Titanium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Vanadium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Chromium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Manganese, 2147483).outputItems(TagPrefix.dust, GTMaterials.Iron, 2147483).outputItems(TagPrefix.dust, GTMaterials.Cobalt, 2147483).outputItems(TagPrefix.dust, GTMaterials.Nickel, 2147483).outputItems(TagPrefix.dust, GTMaterials.Copper, 2147483).outputItems(TagPrefix.dust, GTMaterials.Zinc, 2147483).outputItems(TagPrefix.dust, GTMaterials.Zirconium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Niobium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Molybdenum, 2147483).outputItems(TagPrefix.dust, GTMaterials.Technetium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Ruthenium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Rhodium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Palladium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Silver, 2147483).outputItems(TagPrefix.dust, GTMaterials.Cadmium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Hafnium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Tantalum, 2147483).outputItems(TagPrefix.dust, GTMaterials.Tungsten, 2147483).outputItems(TagPrefix.dust, GTMaterials.Rhenium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Osmium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Iridium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Platinum, 2147483).outputItems(TagPrefix.dust, GTMaterials.Gold, 2147483).outputItems(TagPrefix.dust, GTMaterials.Beryllium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Magnesium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Calcium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Strontium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Barium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Radium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Yttrium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Lithium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Sodium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Potassium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Rubidium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Caesium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Francium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Scandium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Actinium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Thorium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Protactinium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Uranium238, 2147483).outputItems(TagPrefix.dust, GTMaterials.Neptunium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Plutonium239, 2147483).outputItems(TagPrefix.dust, GTMaterials.Americium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Curium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Berkelium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Californium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Einsteinium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Fermium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Mendelevium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Nobelium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Lawrencium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Lanthanum, 2147483).outputItems(TagPrefix.dust, GTMaterials.Cerium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Praseodymium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Neodymium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Promethium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Samarium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Europium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Gadolinium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Terbium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Dysprosium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Holmium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Erbium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Thulium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Ytterbium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Lutetium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Rutherfordium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Dubnium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Seaborgium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Bohrium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Hassium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Meitnerium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Darmstadtium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Roentgenium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Copernicium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Nihonium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Flerovium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Moscovium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Livermorium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Tennessine, 2147483).outputItems(TagPrefix.dust, GTMaterials.Oganesson, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Jasper, 2147483).outputItems(TagPrefix.dust, GTMaterials.Naquadah, 2147483).outputItems(TagPrefix.dust, GTMaterials.NaquadahEnriched, 2147483).outputItems(TagPrefix.dust, GTMaterials.Naquadria, 2147483).outputItems(TagPrefix.dust, GTMaterials.Duranium, 2147483).outputItems(TagPrefix.dust, GTMaterials.Tritanium, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Mithril, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Orichalcum, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Enderium, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Adamantine, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Vibranium, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Infuscolium, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Taranium, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Draconium, 2147483).outputItems(TagPrefix.dust, GTOMaterials.Starmetal, 2147483).outputFluids(GTOMaterials.SpaceTime, 256).outputFluids(GTOMaterials.StableBaryonicMatter, 21474836).outputFluids(GTOMaterials.QuarkGluon.getFluid(FluidStorageKeys.PLASMA, 21474836)).outputFluids(GTOMaterials.HeavyQuarkDegenerateMatter.getFluid(FluidStorageKeys.PLASMA, 21474836)).outputFluids(GTOMaterials.Neutron, 0xCCCCCCC).outputFluids(GTOMaterials.HeavyLeptonMixture, 0xCCCCCCC).outputFluids(GTMaterials.Hydrogen, Integer.MAX_VALUE).outputFluids(GTMaterials.Nitrogen, Integer.MAX_VALUE).outputFluids(GTMaterials.Oxygen, Integer.MAX_VALUE).outputFluids(GTMaterials.Fluorine, Integer.MAX_VALUE).outputFluids(GTMaterials.Chlorine, Integer.MAX_VALUE).outputFluids(GTMaterials.Bromine, Integer.MAX_VALUE).outputFluids(GTMaterials.Helium, Integer.MAX_VALUE).outputFluids(GTMaterials.Neon, Integer.MAX_VALUE).outputFluids(GTMaterials.Argon, Integer.MAX_VALUE).outputFluids(GTMaterials.Krypton, Integer.MAX_VALUE).outputFluids(GTMaterials.Xenon, Integer.MAX_VALUE).outputFluids(GTMaterials.Radon, Integer.MAX_VALUE).outputFluids(GTMaterials.Mercury, Integer.MAX_VALUE).outputFluids(GTMaterials.Deuterium, Integer.MAX_VALUE).outputFluids(GTMaterials.Tritium, Integer.MAX_VALUE).outputFluids(GTMaterials.Helium3, Integer.MAX_VALUE).outputFluids(GTOMaterials.UnknowWater, Integer.MAX_VALUE).outputFluids(GTMaterials.UUMatter, Integer.MAX_VALUE).duration(12000).addData("tier", 10).save();
        Int2ObjectOpenHashMap dustContent = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap fluidContent = new Int2ObjectOpenHashMap();
        for (Map.Entry<ResourceLocation, Reference2IntOpenHashMap<Material>> entry : GTOOres.ALL_ORES.entrySet()) {
            ResourceLocation dimension = entry.getKey();
            if (dimension.equals((Object)GTODimensions.THE_NETHER)) continue;
            int tier = GTODimensions.getTier((ResourceLocation)dimension);
            if (tier == 0) {
                tier = 1;
            }
            if (tier > 9) {
                tier = 9;
            }
            Reference2IntOpenHashMap materialMap = new Reference2IntOpenHashMap();
            Reference2IntOpenHashMap fluid = new Reference2IntOpenHashMap();
            RecipeBuilder builder = GTORecipeTypes.COSMOS_SIMULATION_RECIPES.recipeBuilder(dimension.m_135815_()).addData("tier", tier).inputFluids(GTOMaterials.CosmicElement, 1024000).notConsumable(((DimensionDataItem)((Object)GTOItems.DIMENSION_DATA.get())).getDimensionData(dimension));
            if (tier > 2) {
                builder.outputFluids(GTOMaterials.RawStarMatter.getFluid(FluidStorageKeys.PLASMA, tier << 16));
            }
            if (tier > 5) {
                builder.outputFluids(GTOMaterials.SpaceTime.getFluid(tier << 4));
            }
            for (Reference2IntMap.Entry ore : entry.getValue().reference2IntEntrySet()) {
                Reference2IntOpenHashMap<Material> reference2IntOpenHashMap = CosmosSimulation.getOreMaterial((Material)ore.getKey(), ore.getIntValue());
                if (reference2IntOpenHashMap == null) continue;
                for (Reference2IntMap.Entry material : CosmosSimulation.getOreMaterial(reference2IntOpenHashMap).reference2IntEntrySet()) {
                    materialMap.merge((Object)((Material)material.getKey()), (int)Math.sqrt(material.getIntValue() << 20) << 8, (a2, b2) -> (int)((double)a2.intValue() + (double)b2.intValue() / 1.5));
                }
            }
            for (FluidStack fluidStack : GTOBedrockFluids.ALL_BEDROCK_FLUID.getOrDefault(GTODimensions.getDimensionKey((ResourceLocation)entry.getKey()), Collections.emptyList())) {
                fluid.merge((Object)fluidStack.getFluid(), (int)Math.sqrt(fluidStack.getAmount() << 16) << 8, Integer::sum);
            }
            materialMap.putAll((Map)dustContent.getOrDefault(tier, (Object)new Reference2IntOpenHashMap()));
            Reference2IntOpenHashMap dust = new Reference2IntOpenHashMap();
            for (Reference2IntMap.Entry entry2 : materialMap.reference2IntEntrySet()) {
                Item item = ChemicalHelper.getItem((TagPrefix)TagPrefix.dust, (Material)((Material)entry2.getKey()));
                if (item == Items.f_41852_) continue;
                dust.mergeInt((Object)item, entry2.getIntValue(), Integer::sum);
            }
            dust.reference2IntEntrySet().stream().sorted(Map.Entry.comparingByValue()).toList().forEach(e -> builder.outputItems((Item)e.getKey(), e.getIntValue()));
            fluid.putAll((Map)fluidContent.getOrDefault(tier, (Object)new Reference2IntOpenHashMap()));
            for (Reference2IntMap.Entry entry3 : fluid.reference2IntEntrySet().stream().sorted(Map.Entry.comparingByValue()).toList()) {
                builder.outputFluids(new FluidStack((Fluid)entry3.getKey(), entry3.getIntValue()));
            }
            builder.duration((int)Math.sqrt(tier * dust.size() << 16)).save();
        }
    }

    private static Reference2IntOpenHashMap<Material> getOreMaterial(Reference2IntOpenHashMap<Material> ore) {
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap();
        for (Reference2IntMap.Entry entry : ore.reference2IntEntrySet()) {
            ImmutableList components = ((Material)entry.getKey()).getMaterialComponents();
            if (components.isEmpty()) {
                map.mergeInt((Object)((Material)entry.getKey()), entry.getIntValue(), Integer::sum);
                continue;
            }
            for (MaterialStack component : components) {
                map.mergeInt((Object)component.material(), (int)((double)components.size() / (double)component.amount() * (double)entry.getIntValue()), Integer::sum);
            }
        }
        return map;
    }

    private static Reference2IntOpenHashMap<Material> getOreMaterial(Material material, int multiplier) {
        OreProperty property = (OreProperty)material.getProperty(PropertyKey.ORE);
        if (property == null) {
            return null;
        }
        Reference2IntOpenHashMap ore = new Reference2IntOpenHashMap();
        ore.put((Object)material, multiplier);
        ore.merge((Object)property.getOreByProduct(0, material), property.getByProductMultiplier() * multiplier / 3, Integer::sum);
        ore.merge((Object)property.getOreByProduct(1, material), property.getByProductMultiplier() * multiplier / 4, Integer::sum);
        ore.merge((Object)property.getOreByProduct(2, material), property.getByProductMultiplier() * multiplier / 5, Integer::sum);
        ore.merge((Object)property.getOreByProduct(3, material), property.getByProductMultiplier() * multiplier / 6, Integer::sum);
        return ore;
    }
}

