/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.classified;

import appeng.core.definitions.AEBlocks;
import appeng.decorative.AEDecorativeBlock;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.utils.holder.IntObjectHolder;
import earth.terrarium.adastra.common.registry.ModFluids;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

final class MinerModule {
    private static final Item[] drones = new Item[]{GTOItems.SPACE_DRONE_MK1.m_5456_(), GTOItems.SPACE_DRONE_MK2.m_5456_(), GTOItems.SPACE_DRONE_MK3.m_5456_(), GTOItems.SPACE_DRONE_MK4.m_5456_(), GTOItems.SPACE_DRONE_MK5.m_5456_(), GTOItems.SPACE_DRONE_MK6.m_5456_()};
    private static final FluidStack[][] fuels = new FluidStack[][]{{GTMaterials.RocketFuel.getFluid(10000), GTOMaterials.RocketFuelRp1.getFluid(6000)}, {GTOMaterials.RocketFuelRp1.getFluid(10000), GTOMaterials.DenseHydrazineFuelMixture.getFluid(6000)}, {GTOMaterials.DenseHydrazineFuelMixture.getFluid(10000), GTOMaterials.RocketFuelH8n4c2o4.getFluid(6000)}, {GTOMaterials.RocketFuelCn3h7o3.getFluid(10000), GTOMaterials.RocketFuelH8n4c2o4.getFluid(6000)}, {GTOMaterials.RocketFuelH8n4c2o4.getFluid(10000), new FluidStack((Fluid)ModFluids.CRYO_FUEL.get(), 6000)}, {new FluidStack((Fluid)ModFluids.CRYO_FUEL.get(), 10000), GTOMaterials.StellarEnergyRocketFuel.getFluid(6000)}};
    private static final int[] baseTime = new int[]{600, 400};

    MinerModule() {
    }

    @SafeVarargs
    private static void buildMinerModuleInputOres(int circuit, int minDroneTire, IntObjectHolder<Material> ... oreHolders) {
        ItemStack[] blocks = new ItemStack[oreHolders.length];
        for (int i = 0; i < oreHolders.length; ++i) {
            IntObjectHolder<Material> holder = oreHolders[i];
            blocks[i] = ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)((Material)holder.obj), (int)holder.number);
        }
        MinerModule.buildMinerModule(circuit, minDroneTire, blocks);
    }

    private static void buildMinerModule(int circuit, int minDroneTire, ItemStack[] blocks) {
        for (int i = minDroneTire - 1; i < 6; ++i) {
            for (int j = 0; j < fuels[minDroneTire - 1].length; ++j) {
                RecipeBuilder build = GTORecipeTypes.MINER_MODULE_RECIPES.recipeBuilder("space_ore_" + circuit + "_" + i + "_" + j).notConsumable(drones[i], 16).circuitMeta(circuit).inputFluids(fuels[minDroneTire - 1][j]).EUt((long)GTValues.VA[8 + i]).duration(baseTime[j] >> i);
                for (ItemStack block : blocks) {
                    build.outputItems(block);
                }
                build.save();
            }
        }
    }

    public static void init() {
        MinerModule.buildMinerModuleInputOres(1, 1, MinerModule.ore(280, GTMaterials.Tetrahedrite), MinerModule.ore(140, GTMaterials.Copper), MinerModule.ore(60, GTMaterials.Bentonite), MinerModule.ore(40, GTMaterials.Magnetite), MinerModule.ore(40, GTMaterials.Olivine), MinerModule.ore(20, GTMaterials.GlauconiteSand));
        MinerModule.buildMinerModuleInputOres(2, 1, MinerModule.ore(180, GTMaterials.Almandine), MinerModule.ore(120, GTMaterials.Pyrope), MinerModule.ore(60, GTMaterials.Sapphire), MinerModule.ore(60, GTMaterials.GreenSapphire), MinerModule.ore(70, GTMaterials.Stibnite), MinerModule.ore(120, GTMaterials.Uraninite));
        MinerModule.buildMinerModuleInputOres(3, 1, MinerModule.ore(90, GTMaterials.Bastnasite), MinerModule.ore(30, GTMaterials.Molybdenum), MinerModule.ore(60, GTMaterials.Goethite), MinerModule.ore(240, GTMaterials.YellowLimonite), MinerModule.ore(240, GTMaterials.Hematite), MinerModule.ore(120, GTMaterials.Malachite));
        MinerModule.buildMinerModuleInputOres(4, 1, MinerModule.ore(120, GTMaterials.Soapstone), MinerModule.ore(80, GTMaterials.Talc), MinerModule.ore(80, GTMaterials.GlauconiteSand), MinerModule.ore(40, GTMaterials.Pentlandite), MinerModule.ore(30, GTMaterials.Neodymium), MinerModule.ore(60, GTMaterials.Monazite));
        MinerModule.buildMinerModuleInputOres(5, 1, MinerModule.ore(180, GTMaterials.Redstone), MinerModule.ore(120, GTMaterials.Ruby), MinerModule.ore(60, GTMaterials.Grossular), MinerModule.ore(40, GTMaterials.Spessartine), MinerModule.ore(40, GTOMaterials.Ostrum), MinerModule.ore(20, GTMaterials.Tantalite));
        MinerModule.buildMinerModule(6, 1, new ItemStack[]{ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Chalcopyrite, (int)250), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Zeolite, (int)10), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Cassiterite, (int)10), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Realgar, (int)50), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Cinnabar, (int)60), new ItemStack((ItemLike)((AEDecorativeBlock)AEBlocks.SKY_STONE_BLOCK.block()).m_5456_(), 80)});
        MinerModule.buildMinerModuleInputOres(7, 1, MinerModule.ore(120, GTMaterials.Saltpeter), MinerModule.ore(80, GTMaterials.Diatomite), MinerModule.ore(80, GTMaterials.Electrotine), MinerModule.ore(40, GTMaterials.Alunite), MinerModule.ore(240, GTMaterials.Coal), MinerModule.ore(40, GTMaterials.Rubidium));
        MinerModule.buildMinerModuleInputOres(8, 1, MinerModule.ore(90, GTMaterials.Beryllium), MinerModule.ore(120, GTMaterials.Emerald), MinerModule.ore(40, GTMaterials.Chalcopyrite), MinerModule.ore(160, GTMaterials.Iron), MinerModule.ore(160, GTMaterials.Pyrite), MinerModule.ore(160, GTMaterials.Copper));
        MinerModule.buildMinerModuleInputOres(9, 1, MinerModule.ore(60, GTMaterials.Grossular), MinerModule.ore(40, GTMaterials.Pyrolusite), MinerModule.ore(20, GTMaterials.Tantalite), MinerModule.ore(240, GTMaterials.Magnetite), MinerModule.ore(160, GTMaterials.VanadiumMagnetite), MinerModule.ore(80, GTMaterials.Gold));
        MinerModule.buildMinerModuleInputOres(10, 1, MinerModule.ore(120, GTMaterials.Lazurite), MinerModule.ore(80, GTMaterials.Sodalite), MinerModule.ore(80, GTMaterials.Lapis), MinerModule.ore(40, GTMaterials.Calcite), MinerModule.ore(150, GTMaterials.Wulfenite), MinerModule.ore(30, GTOMaterials.Calorite));
        MinerModule.buildMinerModuleInputOres(11, 1, MinerModule.ore(120, GTMaterials.Galena), MinerModule.ore(80, GTMaterials.Silver), MinerModule.ore(40, GTMaterials.Lead), MinerModule.ore(100, GTMaterials.Molybdenite), MinerModule.ore(50, GTMaterials.Molybdenum), MinerModule.ore(50, GTMaterials.Powellite));
        MinerModule.buildMinerModuleInputOres(12, 1, MinerModule.ore(140, GTOMaterials.Zircon), MinerModule.ore(60, GTMaterials.YellowLimonite), MinerModule.ore(60, GTMaterials.Kyanite), MinerModule.ore(40, GTMaterials.Mica), MinerModule.ore(40, GTMaterials.Bauxite), MinerModule.ore(20, GTMaterials.Pollucite));
        MinerModule.buildMinerModuleInputOres(13, 1, MinerModule.ore(60, GTOMaterials.Desh), MinerModule.ore(80, GTMaterials.CertusQuartz), MinerModule.ore(90, GTMaterials.Goethite), MinerModule.ore(160, GTMaterials.Cassiterite), MinerModule.ore(60, GTMaterials.Hematite), MinerModule.ore(30, GTMaterials.Gold));
        MinerModule.buildMinerModuleInputOres(14, 1, MinerModule.ore(40, GTMaterials.Barite), MinerModule.ore(120, GTMaterials.GarnetRed), MinerModule.ore(80, GTMaterials.GarnetYellow), MinerModule.ore(80, GTMaterials.Amethyst), MinerModule.ore(40, GTMaterials.Opal), MinerModule.ore(20, GTOMaterials.AlienAlgae));
        MinerModule.buildMinerModuleInputOres(15, 1, MinerModule.ore(210, GTMaterials.BlueTopaz), MinerModule.ore(140, GTMaterials.Topaz), MinerModule.ore(240, GTMaterials.BasalticMineralSand), MinerModule.ore(160, GTMaterials.GraniticMineralSand), MinerModule.ore(160, GTMaterials.FullersEarth), MinerModule.ore(80, GTMaterials.Gypsum));
        MinerModule.buildMinerModuleInputOres(16, 1, MinerModule.ore(150, GTMaterials.RockSalt), MinerModule.ore(10, GTMaterials.Salt), MinerModule.ore(50, GTMaterials.Lepidolite), MinerModule.ore(50, GTMaterials.Spodumene), MinerModule.ore(140, GTMaterials.Chalcocite), MinerModule.ore(70, GTMaterials.Bornite));
        MinerModule.buildMinerModule(17, 1, new ItemStack[]{ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Redstone, (int)180), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Ruby, (int)120), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Cinnabar, (int)60), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.NetherQuartz, (int)240), ChemicalHelper.get((TagPrefix)TagPrefix.ore, (Material)GTMaterials.Quartzite, (int)80), new ItemStack((ItemLike)Blocks.f_50722_.m_5456_(), 50)});
        MinerModule.buildMinerModuleInputOres(18, 1, MinerModule.ore(120, GTMaterials.Apatite), MinerModule.ore(80, GTMaterials.TricalciumPhosphate), MinerModule.ore(40, GTMaterials.Pyrochlore), MinerModule.ore(300, GTMaterials.Sulfur), MinerModule.ore(200, GTMaterials.Pyrite), MinerModule.ore(100, GTMaterials.Sphalerite));
        MinerModule.buildMinerModuleInputOres(19, 1, MinerModule.ore(180, GTMaterials.Magnetite), MinerModule.ore(120, GTMaterials.VanadiumMagnetite), MinerModule.ore(240, GTMaterials.CassiteriteSand), MinerModule.ore(160, GTMaterials.GarnetSand), MinerModule.ore(160, GTMaterials.Asbestos), MinerModule.ore(80, GTMaterials.Diatomite));
        MinerModule.buildMinerModuleInputOres(20, 1, MinerModule.ore(240, GTMaterials.Oilsands), MinerModule.ore(60, GTMaterials.Gold), MinerModule.ore(80, GTOMaterials.InfusedGold), MinerModule.ore(160, GTMaterials.Bauxite), MinerModule.ore(80, GTMaterials.Ilmenite), MinerModule.ore(80, GTMaterials.Aluminium));
        MinerModule.buildMinerModuleInputOres(21, 1, MinerModule.ore(60, GTMaterials.Bornite), MinerModule.ore(40, GTMaterials.Cooperite), MinerModule.ore(120, GTMaterials.Graphite), MinerModule.ore(80, GTMaterials.Diamond), MinerModule.ore(40, GTMaterials.Coal), MinerModule.ore(40, GTMaterials.Titanium));
        MinerModule.buildMinerModuleInputOres(22, 1, MinerModule.ore(120, GTMaterials.Garnierite), MinerModule.ore(80, GTMaterials.Nickel), MinerModule.ore(80, GTMaterials.Cobaltite), MinerModule.ore(40, GTMaterials.Pentlandite), MinerModule.ore(40, GTMaterials.Platinum), MinerModule.ore(20, GTMaterials.Palladium));
        MinerModule.buildMinerModuleInputOres(23, 1, MinerModule.ore(120, GTMaterials.Scheelite), MinerModule.ore(80, GTMaterials.Tungstate), MinerModule.ore(40, GTMaterials.Lithium), MinerModule.ore(20, GTMaterials.Tellurium), MinerModule.ore(30, GTMaterials.Tungsten), MinerModule.ore(180, GTMaterials.Pitchblende));
        MinerModule.buildMinerModuleInputOres(24, 1, MinerModule.ore(180, GTMaterials.Naquadah), MinerModule.ore(120, GTMaterials.Chromite), MinerModule.ore(60, GTMaterials.Plutonium239), MinerModule.ore(30, GTMaterials.NaquadahEnriched), MinerModule.ore(90, GTOMaterials.TriniumCompound), MinerModule.ore(30, GTMaterials.Indium));
        MinerModule.buildMinerModuleInputOres(25, 2, MinerModule.ore(20, GTOMaterials.Jasper), MinerModule.ore(140, GTMaterials.GarnetRed), MinerModule.ore(60, GTMaterials.Topaz), MinerModule.ore(40, GTMaterials.Emerald), MinerModule.ore(40, GTMaterials.Amethyst), MinerModule.ore(20, GTOMaterials.Celestine));
        MinerModule.buildMinerModuleInputOres(26, 3, MinerModule.ore(140, GTMaterials.Iron), MinerModule.ore(140, GTMaterials.Tin), MinerModule.ore(60, GTMaterials.Nickel), MinerModule.ore(60, GTOMaterials.Uruium), MinerModule.ore(40, GTOMaterials.Force), MinerModule.ore(20, GTMaterials.Cobalt));
        MinerModule.buildMinerModuleInputOres(27, 3, MinerModule.ore(120, GTOMaterials.Bloodstone), MinerModule.ore(80, GTMaterials.Redstone), MinerModule.ore(120, GTMaterials.GarnetRed), MinerModule.ore(40, GTMaterials.Ruby), MinerModule.ore(40, GTMaterials.Almandine), MinerModule.ore(40, GTMaterials.Pyrope));
        MinerModule.buildMinerModuleInputOres(28, 4, MinerModule.ore(80, GTMaterials.Naquadah), MinerModule.ore(40, GTOMaterials.AdamantineCompounds), MinerModule.ore(60, GTOMaterials.RareEarthMetal), MinerModule.ore(40, GTMaterials.Monazite), MinerModule.ore(40, GTMaterials.Bastnasite), MinerModule.ore(20, GTMaterials.NaquadahEnriched));
        MinerModule.buildMinerModuleInputOres(29, 4, MinerModule.ore(40, GTOMaterials.GnomeCrystal), MinerModule.ore(40, GTOMaterials.SalamanderCrystal), MinerModule.ore(80, GTMaterials.Uraninite), MinerModule.ore(40, GTOMaterials.Orichalcum), MinerModule.ore(60, GTOMaterials.Mithril), MinerModule.ore(80, GTMaterials.Salt));
        MinerModule.buildMinerModuleInputOres(30, 5, MinerModule.ore(80, GTOMaterials.Enderium), MinerModule.ore(120, GTMaterials.Sodalite), MinerModule.ore(60, GTOMaterials.Celestine), MinerModule.ore(80, GTMaterials.Lapis), MinerModule.ore(60, GTMaterials.Bauxite), MinerModule.ore(40, GTMaterials.Pitchblende));
        MinerModule.buildMinerModuleInputOres(31, 5, MinerModule.ore(40, GTMaterials.Silver), MinerModule.ore(60, GTMaterials.Platinum), MinerModule.ore(60, GTOMaterials.Tartarite), MinerModule.ore(80, GTOMaterials.Vibranium), MinerModule.ore(120, GTMaterials.Aluminium), MinerModule.ore(120, GTMaterials.Iron));
        MinerModule.buildMinerModuleInputOres(32, 6, MinerModule.ore(12, GTMaterials.Lazurite), MinerModule.ore(80, GTMaterials.Sapphire), MinerModule.ore(60, GTOMaterials.Starmetal), MinerModule.ore(80, GTMaterials.GreenSapphire), MinerModule.ore(120, GTMaterials.GarnetYellow), MinerModule.ore(80, GTMaterials.Pollucite));
    }

    private static IntObjectHolder<Material> ore(int count, Material mat) {
        return new IntObjectHolder(count, (Object)mat);
    }
}

