/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTORecipeCategories;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.utils.ItemUtils;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraftforge.fluids.FluidStack;

final class GTODisposableToolHandler {
    private static final List<DisposableTool> toolToMoldMap = List.of(new DisposableTool(GTToolType.FILE, (Item)GTOItems.DISPOSABLE_FILE_MOLD.get(), (Item)GTOItems.DISPOSABLE_FILE.get(), 4), new DisposableTool(GTToolType.WRENCH, (Item)GTOItems.DISPOSABLE_WRENCH_MOLD.get(), (Item)GTOItems.DISPOSABLE_WRENCH.get(), 8), new DisposableTool(GTToolType.CROWBAR, (Item)GTOItems.DISPOSABLE_CROWBAR_MOLD.get(), (Item)GTOItems.DISPOSABLE_CROWBAR.get(), 3), new DisposableTool(GTToolType.WIRE_CUTTER, (Item)GTOItems.DISPOSABLE_WIRE_CUTTER_MOLD.get(), (Item)GTOItems.DISPOSABLE_WIRE_CUTTER.get(), 9), new DisposableTool(GTToolType.HARD_HAMMER, (Item)GTOItems.DISPOSABLE_HAMMER_MOLD.get(), (Item)GTOItems.DISPOSABLE_HAMMER.get(), 6), new DisposableTool(GTToolType.SOFT_MALLET, (Item)GTOItems.DISPOSABLE_MALLET_MOLD.get(), (Item)GTOItems.DISPOSABLE_MALLET.get(), 6), new DisposableTool(GTToolType.SCREWDRIVER, (Item)GTOItems.DISPOSABLE_SCREWDRIVER_MOLD.get(), (Item)GTOItems.DISPOSABLE_SCREWDRIVER.get(), 4), new DisposableTool(GTToolType.SAW, (Item)GTOItems.DISPOSABLE_SAW_MOLD.get(), (Item)GTOItems.DISPOSABLE_SAW.get(), 4));

    GTODisposableToolHandler() {
    }

    public static void run(Material material) {
        if (!material.hasProperty(PropertyKey.TOOL)) {
            return;
        }
        if (!material.hasFluid()) {
            return;
        }
        int durability = ((ToolProperty)material.getProperty(PropertyKey.TOOL)).getDurability();
        FluidStack fluidStack = material.getFluid(72);
        for (DisposableTool tool : toolToMoldMap) {
            if (GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)tool.tool) == null) continue;
            GTORecipeTypes.THREE_DIMENSIONAL_PRINTER_RECIPES.builder(material.getName() + "_to_" + ItemUtils.getIdLocation((Item)tool.item).m_135815_(), new Object[0]).notConsumable(tool.mold).inputFluids(fluidStack).outputItems(tool.item, durability / tool.consume).EUt(30L).category(GTORecipeCategories.THREE_DIMENSIONAL_PRINTER_RECIPES_DISPOSABLE).duration((int)material.getMass()).EUt((long)GTValues.VA[0]).save();
        }
    }

    private record DisposableTool(GTToolType tool, Item mold, Item item, int consume) {
    }
}

