/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.api.data.material.GTOMaterialFlags;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.GTOCore;
import com.gtolib.api.recipe.RecipeBuilder;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public final class GTOOreRecipeHandler {
    private static boolean doesMaterialUseNormalFurnace(Material material) {
        return !material.hasProperty(PropertyKey.BLAST) && !material.hasFlag(MaterialFlags.NO_ORE_SMELTING);
    }

    public static void run(Material material) {
        OreProperty property = (OreProperty)material.getProperty(PropertyKey.ORE);
        if (property == null) {
            return;
        }
        GTOOreRecipeHandler.processOre(material, property);
        GTOOreRecipeHandler.processRawOre(material, property);
        GTOOreRecipeHandler.processCrushedOre(property, material);
        GTOOreRecipeHandler.processCrushedPurified(property, material);
        GTOOreRecipeHandler.processCrushedCentrifuged(property, material);
        GTOOreRecipeHandler.processDirtyDust(property, material);
        GTOOreRecipeHandler.processPureDust(property, material);
    }

    private static void processOre(Material material, OreProperty property) {
        Material smeltingMaterial;
        if (!material.shouldGenerateRecipesFor(TagPrefix.ore)) {
            return;
        }
        ItemStack crushedStack = ChemicalHelper.get((TagPrefix)TagPrefix.crushed, (Material)material);
        int oreMultiplier = property.getOreMultiplier();
        int oreTypeMultiplier = GTOCore.isExpert() ? 4 : 6;
        long mass = material.getMass();
        int dur = (int)Math.max(8.0, Math.sqrt(mass) * 2.0 * (double)oreTypeMultiplier);
        crushedStack.m_41764_(Math.max(oreTypeMultiplier * oreMultiplier, 1));
        TagKey tag = TagPrefix.ore.getItemTags(material)[0];
        RecipeBuilder forge_builder = GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder(material.getName() + "_ore_to_raw_ore").inputItems(tag).duration((dur << 2) / 5).EUt(16L);
        int fc = Math.max(1, crushedStack.m_41613_() / 2);
        ItemStack out = material.hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(material) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES) ? ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material, (int)fc) : crushedStack.m_255036_(fc);
        forge_builder.outputItems(out);
        forge_builder.save();
        ToolHelper.HAMMER_DROP.put(tag, out);
        Material byproductMaterial = property.getOreByProduct(0, material);
        ItemStack byproductStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)byproductMaterial).m_41619_() || material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES) ? ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)byproductMaterial) : ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)byproductMaterial);
        Material material2 = smeltingMaterial = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
        if (!crushedStack.m_41619_()) {
            ItemStack ingotStack;
            RecipeBuilder builder = GTORecipeTypes.CRUSHER_RECIPES.recipeBuilder(material.getName() + "_ore_to_raw_ore").inputItems(tag).outputItems(crushedStack).chancedOutput(byproductStack, 1400, 850).EUt(30L).duration(dur);
            for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                builder.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial), 6700, 800);
            }
            builder.save();
            int crushedAmount = crushedStack.m_41613_();
            RecipeBuilder opBuilder1 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_1_" + material.getName()).circuitMeta(1).inputItems(tag).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial, property.getByProductMultiplier() * crushedAmount, 1400, 850).duration((int)((long)dur + ((long)dur + (mass << 2)) * (long)crushedAmount)).EUt(30L);
            for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                opBuilder1.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
            }
            if (byproductMaterial.hasProperty(PropertyKey.DUST)) {
                opBuilder1.chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 1111, 0);
            }
            opBuilder1.save();
            Material byproductMaterial1 = property.getOreByProduct(1, material);
            ItemStack byproductStack2 = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)property.getOreByProduct(2, material), (int)crushedAmount);
            ItemStack crushedCentrifugedStack = ChemicalHelper.get((TagPrefix)TagPrefix.crushedRefined, (Material)material);
            if (!crushedCentrifugedStack.m_41619_()) {
                RecipeBuilder opBuilder2 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_2_" + material.getName()).circuitMeta(2).inputItems(tag).inputFluids(GTMaterials.DistilledWater.getFluid(100 * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone, crushedAmount).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 3333, 0).chancedOutput(byproductStack2, 1400, 850).duration(dur + (400 + dur) * crushedAmount).EUt(30L);
                for (Object secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                    if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                    opBuilder2.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
                }
                opBuilder2.save();
            }
            ItemStack byproductStack1 = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)byproductMaterial1, (int)crushedAmount);
            RecipeBuilder opBuilder3 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("rocessor_3_" + material.getName()).circuitMeta(3).inputItems(tag).inputFluids(GTMaterials.DistilledWater.getFluid(100 * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone, crushedAmount).chancedOutput(byproductStack1, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + (200 + dur + 16) * crushedAmount).EUt(30L);
            for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                opBuilder3.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
            }
            opBuilder3.save();
            if (material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
                ItemStack exquisiteStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemExquisite, (Material)material);
                ItemStack flawlessStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemFlawless, (Material)material);
                ItemStack gemStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
                if (material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT)) {
                    opBuilder4 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_4_" + material.getName()).circuitMeta(4).inputItems(tag).inputFluids(GTMaterials.DistilledWater.getFluid(100 * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone, crushedAmount).chancedOutput(exquisiteStack, 500, 150).chancedOutput(flawlessStack, 1500, 200).chancedOutput(gemStack, 5000, 1000).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + 426 * crushedAmount).EUt(30L);
                    for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                        if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                        opBuilder4.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
                    }
                    opBuilder4.save();
                } else {
                    opBuilder4 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_4_" + material.getName()).circuitMeta(4).inputItems(tag).inputFluids(GTMaterials.DistilledWater.getFluid(100 * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone, crushedAmount).chancedOutput(exquisiteStack, 300, 100).chancedOutput(flawlessStack, 1000, 150).chancedOutput(gemStack, 3500, 500).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + 426 * crushedAmount).EUt(30L);
                    for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                        if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                        opBuilder4.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
                    }
                    opBuilder4.save();
                }
            }
            if (!((Material)property.getWashedIn().first()).isNull()) {
                Material washingByproduct = property.getOreByProduct(3, material);
                @NotNull ObjectIntPair washedInTuple = property.getWashedIn();
                if (!crushedCentrifugedStack.m_41619_()) {
                    RecipeBuilder opBuilder5 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_5_" + material.getName()).circuitMeta(5).inputItems(tag).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt() * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier() * crushedAmount, 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, crushedAmount, 4000, 650).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 3333, 0).chancedOutput(byproductStack2, 1400, 850).duration(dur + (400 + dur) * crushedAmount).EUt(30L);
                    for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                        if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                        opBuilder5.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
                    }
                    opBuilder5.save();
                }
                RecipeBuilder opBuilder6 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_6_" + material.getName()).circuitMeta(6).inputItems(tag).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt() * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier() * crushedAmount, 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, crushedAmount, 4000, 650).chancedOutput(byproductStack1, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + (200 + dur + 16) * crushedAmount).EUt(30L);
                for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                    if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                    opBuilder6.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
                }
                opBuilder6.save();
                if (material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
                    ItemStack exquisiteStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemExquisite, (Material)material);
                    ItemStack flawlessStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemFlawless, (Material)material);
                    ItemStack gemStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
                    if (material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT)) {
                        RecipeBuilder opBuilder7 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_7_" + material.getName()).circuitMeta(7).inputItems(tag).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt() * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier() * crushedAmount, 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, crushedAmount, 4000, 650).chancedOutput(exquisiteStack, 500, 150).chancedOutput(flawlessStack, 1500, 200).chancedOutput(gemStack, 5000, 1000).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + 426 * crushedAmount).EUt(30L);
                        for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                            if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                            opBuilder7.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
                        }
                        opBuilder7.save();
                    } else {
                        RecipeBuilder opBuilder7 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("processor_7_" + material.getName()).circuitMeta(7).inputItems(tag).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt() * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1400, 850).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier() * crushedAmount, 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, crushedAmount, 4000, 650).chancedOutput(exquisiteStack, 300, 100).chancedOutput(flawlessStack, 1000, 150).chancedOutput(gemStack, 3500, 500).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + 426 * crushedAmount).EUt(30L);
                        for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
                            if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                            opBuilder7.chancedOutput(ChemicalHelper.getGem((MaterialStack)secondaryMaterial).m_255036_(crushedAmount), 6700, 800);
                        }
                        opBuilder7.save();
                    }
                }
            }
            crushedAmount = Math.max(crushedAmount / 2, 1);
            ItemStack itemStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)smeltingMaterial, (int)crushedAmount) : (ingotStack = material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES) ? ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)smeltingMaterial, (int)crushedAmount) : ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)smeltingMaterial, (int)crushedAmount));
            if (!ingotStack.m_41619_() && GTOOreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !TagPrefix.ore.isIgnored(material)) {
                float xp = (float)Math.round(((1.0f + (float)oreTypeMultiplier * 0.5f) * 0.5f - 0.05f) * 10.0f) / 10.0f;
                VanillaRecipeHelper.addSmeltingRecipe((String)material.getName(), (TagKey)tag, (ItemStack)ingotStack, (float)xp);
                VanillaRecipeHelper.addBlastingRecipe((String)material.getName(), (TagKey)tag, (ItemStack)ingotStack, (float)xp);
                if (material.hasProperty(PropertyKey.GEM)) {
                    GTORecipeTypes.AUTOCLAVE_RECIPES.builder("ore2_" + material.getName(), new Object[0]).inputItems(TagPrefix.crushedPurified.getItemTags(material)[0]).outputItems(ingotStack).inputFluids(GTMaterials.DistilledWater, GTOCore.isExpert() ? 20 : 10).EUt(GTOCore.isExpert() ? 8L : 2L).duration(100).save();
                    GTORecipeTypes.AUTOCLAVE_RECIPES.builder("ore1_" + material.getName(), new Object[0]).inputItems(TagPrefix.crushedPurified.getItemTags(material)[0]).outputItems(ingotStack).inputFluids(GTMaterials.Water, 500).EUt(GTOCore.isExpert() ? 16L : 8L).duration(400).save();
                }
            }
        }
    }

    private static void processRawOre(Material material, OreProperty property) {
        ItemStack ingotStack;
        Material smeltingMaterial;
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.rawOre, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int oreTypeMultiplier = GTOCore.isExpert() ? 4 : 6;
        long mass = material.getMass();
        int dur = (int)Math.max(6.0, Math.sqrt(mass) * (double)oreTypeMultiplier * 2.0 / 3.0);
        ItemStack crushedStack = ChemicalHelper.get((TagPrefix)TagPrefix.crushed, (Material)material, (int)Math.max(1, property.getOreMultiplier() * oreTypeMultiplier / 2));
        Material material2 = smeltingMaterial = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
        if (crushedStack.m_41619_()) {
            return;
        }
        RecipeBuilder builder = GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder(TagPrefix.rawOre.name + "_" + material.getName() + "_to_crushed_ore").inputItems(stack).duration((dur << 2) / 5).EUt(16L);
        int fc = Math.max(1, crushedStack.m_41613_() / 2);
        ItemStack out = material.hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(material) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES) ? ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material, (int)fc) : crushedStack.m_255036_(fc);
        builder.outputItems(out);
        builder.save();
        ToolHelper.HAMMER_DROP.put(ChemicalHelper.getTag((TagPrefix)TagPrefix.rawOre, (Material)material), out);
        RecipeBuilder builder2 = GTORecipeTypes.CRUSHER_RECIPES.recipeBuilder(TagPrefix.rawOre.name + "_" + material.getName() + "_ore_to_crushed_ore").inputItems(stack).outputItems(crushedStack).EUt(30L).duration(dur);
        Material byproductMaterial = property.getOreByProduct(0, material);
        ItemStack byproductStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)byproductMaterial).m_41619_() || material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES) ? ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)byproductMaterial) : ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)byproductMaterial);
        builder2.chancedOutput(byproductStack, 1000, 300);
        for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
            if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
            ItemStack dustStack = ChemicalHelper.getGem((MaterialStack)secondaryMaterial);
            builder2.chancedOutput(dustStack, 500, 100);
            break;
        }
        builder2.save();
        int crushedAmount = crushedStack.m_41613_();
        RecipeBuilder opBuilder1 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("raw_processor_1_" + material.getName()).circuitMeta(1).inputItems(stack).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1000, 300).duration((int)((long)dur + ((long)dur + (mass << 2)) * (long)crushedAmount)).EUt(30L);
        if (byproductMaterial.hasProperty(PropertyKey.DUST)) {
            opBuilder1.chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 1111, 0);
        }
        opBuilder1.save();
        Material byproductMaterial1 = property.getOreByProduct(1, material);
        ItemStack byproductStack2 = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)property.getOreByProduct(2, material), (int)crushedAmount);
        ItemStack crushedCentrifugedStack = ChemicalHelper.get((TagPrefix)TagPrefix.crushedRefined, (Material)material);
        if (!crushedCentrifugedStack.m_41619_()) {
            RecipeBuilder opBuilder2 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("raw_processor_2_" + material.getName()).circuitMeta(2).inputItems(stack).inputFluids(GTMaterials.DistilledWater.getFluid(100 * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1000, 300).chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone, crushedAmount).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 3333, 0).chancedOutput(byproductStack2, 1400, 850).duration(dur + (400 + dur) * crushedAmount).EUt(30L);
            opBuilder2.save();
        }
        ItemStack byproductStack1 = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)byproductMaterial1, (int)crushedAmount);
        RecipeBuilder opBuilder3 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("raw_processor_3_" + material.getName()).circuitMeta(3).inputItems(stack).inputFluids(GTMaterials.DistilledWater.getFluid(100 * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1000, 300).chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone, crushedAmount).chancedOutput(byproductStack1, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + (200 + dur + 16) * crushedAmount).EUt(30L);
        for (MaterialStack secondaryMaterial : TagPrefix.ore.secondaryMaterials()) {
            if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
            ItemStack dustStack = ChemicalHelper.getGem((MaterialStack)secondaryMaterial);
            opBuilder3.chancedOutput(dustStack, 500, 100);
            break;
        }
        opBuilder3.save();
        if (material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
            ItemStack exquisiteStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemExquisite, (Material)material);
            ItemStack flawlessStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemFlawless, (Material)material);
            ItemStack gemStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
            RecipeBuilder opBuilder4 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("raw_processor_4_" + material.getName()).circuitMeta(4).inputItems(stack).inputFluids(GTMaterials.DistilledWater.getFluid(100 * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1000, 300).chancedOutput(TagPrefix.dust, byproductMaterial, crushedAmount, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone, crushedAmount).chancedOutput(exquisiteStack, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 500 : 300, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 150 : 100).chancedOutput(flawlessStack, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 1500 : 1000, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 200 : 150).chancedOutput(gemStack, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 5000 : 3500, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 1000 : 500).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + 426 * crushedAmount).EUt(30L);
            opBuilder4.save();
        }
        if (!((Material)property.getWashedIn().first()).isNull()) {
            Material washingByproduct = property.getOreByProduct(3, material);
            @NotNull ObjectIntPair washedInTuple = property.getWashedIn();
            if (!crushedCentrifugedStack.m_41619_()) {
                RecipeBuilder opBuilder5 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("raw_processor_5_" + material.getName()).circuitMeta(5).inputItems(stack).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt() * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1000, 300).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier() * crushedAmount, 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, crushedAmount, 4000, 650).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 3333, 0).chancedOutput(byproductStack2, 1400, 850).duration(dur + (400 + dur) * crushedAmount).EUt(30L);
                opBuilder5.save();
            }
            RecipeBuilder opBuilder6 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("raw_processor_6_" + material.getName()).circuitMeta(6).inputItems(stack).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt() * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1000, 300).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier() * crushedAmount, 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, crushedAmount, 4000, 650).chancedOutput(byproductStack1, 1400, 850).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + (200 + dur + 16) * crushedAmount).EUt(30L);
            opBuilder6.save();
            if (material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
                ItemStack exquisiteStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemExquisite, (Material)material);
                ItemStack flawlessStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemFlawless, (Material)material);
                ItemStack gemStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
                RecipeBuilder opBuilder7 = GTORecipeTypes.INTEGRATED_ORE_PROCESSOR.recipeBuilder("raw_processor_7_" + material.getName()).circuitMeta(7).inputItems(stack).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt() * crushedAmount)).outputItems(TagPrefix.dust, GTOOreRecipeHandler.getOutputMaterial(material), crushedAmount).chancedOutput(byproductStack, 1000, 300).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier() * crushedAmount, 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, crushedAmount, 4000, 650).chancedOutput(exquisiteStack, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 500 : 300, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 150 : 100).chancedOutput(flawlessStack, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 1500 : 1000, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 200 : 150).chancedOutput(gemStack, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 5000 : 3500, material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT) ? 1000 : 500).chancedOutput(TagPrefix.dust, byproductMaterial1, crushedAmount, 1111, 0).duration(dur + 426 * crushedAmount).EUt(30L);
                opBuilder7.save();
            }
        }
        ItemStack itemStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)smeltingMaterial, (int)property.getOreMultiplier()) : (ingotStack = material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES) ? ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)smeltingMaterial, (int)property.getOreMultiplier()) : ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)smeltingMaterial, (int)property.getOreMultiplier()));
        if (!ingotStack.m_41619_() && GTOOreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !TagPrefix.rawOre.isIgnored(material)) {
            float xp = (float)Math.round((1.0f + (float)property.getOreMultiplier() * 0.33f) / 3.0f * 10.0f) / 10.0f;
            VanillaRecipeHelper.addSmeltingRecipe((String)(TagPrefix.rawOre.name + "_" + material.getName()), (ItemStack)stack, (ItemStack)ingotStack, (float)xp);
            VanillaRecipeHelper.addBlastingRecipe((String)(TagPrefix.rawOre.name + "_" + material.getName()), (Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), (ItemStack)ingotStack, (float)xp);
        }
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder(material.getName() + "to_ore_block").inputItems(stack.m_255036_(9)).outputItems(TagPrefix.rawOreBlock, material).duration(300).EUt(2L).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder(material.getName() + "to_raw_ore").inputItems(TagPrefix.rawOreBlock, material).outputItems(stack.m_255036_(9)).duration(300).EUt(2L).save();
    }

    private static void processCrushedOre(@NotNull OreProperty property, @NotNull Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.crushed, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack impureDustStack = ChemicalHelper.get((TagPrefix)TagPrefix.dustImpure, (Material)material);
        Material byproductMaterial = property.getOreByProduct(0, material);
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_impure_dust").inputItems(stack).outputItems(impureDustStack).duration(10).EUt(16L).category(GTRecipeCategories.ORE_FORGING).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_impure_dust").inputItems(stack).outputItems(impureDustStack).duration(400).EUt(2L).chancedOutput(TagPrefix.dust, byproductMaterial, property.getByProductMultiplier(), 1400, 850).category(GTRecipeCategories.ORE_CRUSHING).save();
        ItemStack crushedPurifiedOre = GTUtil.copyFirst((ItemStack[])new ItemStack[]{ChemicalHelper.get((TagPrefix)TagPrefix.crushedPurified, (Material)material), ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTOOreRecipeHandler.getOutputMaterial(material))});
        ItemStack crushedCentrifugedOre = GTUtil.copyFirst((ItemStack[])new ItemStack[]{ChemicalHelper.get((TagPrefix)TagPrefix.crushedRefined, (Material)material), ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTOOreRecipeHandler.getOutputMaterial(material))});
        GTORecipeTypes.ORE_WASHER_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_purified_ore_fast").inputItems(stack).circuitMeta(2).inputFluids(GTMaterials.Water, 100).outputItems(crushedPurifiedOre).duration(8).EUt(4L).save();
        GTORecipeTypes.ORE_WASHER_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_purified_ore").inputItems(stack).inputFluids(GTMaterials.Water, 1000).circuitMeta(1).outputItems(crushedPurifiedOre).chancedOutput(TagPrefix.dust, byproductMaterial, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone).save();
        GTORecipeTypes.ORE_WASHER_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_purified_ore_distilled").inputItems(stack).inputFluids(GTMaterials.DistilledWater, 100).outputItems(crushedPurifiedOre).chancedOutput(TagPrefix.dust, byproductMaterial, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone).duration(200).save();
        GTORecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_refined_ore").inputItems(stack).outputItems(crushedCentrifugedOre).chancedOutput(TagPrefix.dust, property.getOreByProduct(1, material), property.getByProductMultiplier(), 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone).save();
        if (!((Material)property.getWashedIn().first()).isNull()) {
            Material washingByproduct = property.getOreByProduct(3, material);
            @NotNull ObjectIntPair washedInTuple = property.getWashedIn();
            GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_purified_ore").inputItems(stack).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.rightInt())).outputItems(crushedPurifiedOre).chancedOutput(TagPrefix.dust, washingByproduct, property.getByProductMultiplier(), 7000, 580).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 4000, 650).duration(200).EUt((long)GTValues.VA[1]).category(GTRecipeCategories.ORE_BATHING).save();
        }
        GTOOreRecipeHandler.processMetalSmelting(property, TagPrefix.crushed, material);
    }

    private static void processCrushedCentrifuged(@NotNull OreProperty property, @NotNull Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.crushedRefined, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack dustStack = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTOOreRecipeHandler.getOutputMaterial(material));
        ItemStack byproductStack = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)property.getOreByProduct(2, material), (int)1);
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder(material.getName() + "_refined_ore_to_dust").inputItems(stack).outputItems(dustStack).duration(10).EUt(16L).category(GTRecipeCategories.ORE_FORGING).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder(material.getName() + "_refined_ore_to_dust").inputItems(stack).outputItems(dustStack).chancedOutput(byproductStack, 1400, 850).duration(400).EUt(2L).category(GTRecipeCategories.ORE_CRUSHING).save();
        GTOOreRecipeHandler.processMetalSmelting(property, TagPrefix.crushedRefined, material);
    }

    private static void processCrushedPurified(@NotNull OreProperty property, @NotNull Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.crushedPurified, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack crushedCentrifugedStack = ChemicalHelper.get((TagPrefix)TagPrefix.crushedRefined, (Material)material);
        ItemStack dustStack = ChemicalHelper.get((TagPrefix)TagPrefix.dustPure, (Material)material);
        Material byproductMaterial = property.getOreByProduct(1, material);
        ItemStack byproductStack = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)byproductMaterial);
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_dust").inputItems(stack).outputItems(dustStack).duration(10).EUt(16L).category(GTRecipeCategories.ORE_FORGING).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder(material.getName() + "_crushed_ore_to_dust").inputItems(stack).outputItems(dustStack).chancedOutput(byproductStack, 1400, 850).duration(400).EUt(2L).category(GTRecipeCategories.ORE_CRUSHING).save();
        if (!crushedCentrifugedStack.m_41619_()) {
            GTORecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder(material.getName() + "_purified_ore_to_refined_ore").inputItems(stack).outputItems(crushedCentrifugedStack).chancedOutput(TagPrefix.dust, byproductMaterial, 3333, 0).save();
        }
        if (material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
            ItemStack exquisiteStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemExquisite, (Material)material);
            ItemStack flawlessStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemFlawless, (Material)material);
            ItemStack gemStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
            ItemStack flawedStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemFlawed, (Material)material);
            ItemStack chippedStack = ChemicalHelper.get((TagPrefix)TagPrefix.gemChipped, (Material)material);
            if (material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT)) {
                RecipeBuilder builder = GTORecipeTypes.SIFTER_RECIPES.recipeBuilder(material.getName() + "_purified_ore_to_gems").inputItems(stack).chancedOutput(exquisiteStack, 500, 150).chancedOutput(flawlessStack, 1500, 200).chancedOutput(gemStack, 5000, 1000).chancedOutput(dustStack, 2500, 500).duration(400).EUt(16L);
                if (!flawedStack.m_41619_()) {
                    builder.chancedOutput(flawedStack, 2000, 500);
                }
                if (!chippedStack.m_41619_()) {
                    builder.chancedOutput(chippedStack, 3000, 350);
                }
                builder.save();
            } else {
                RecipeBuilder builder = GTORecipeTypes.SIFTER_RECIPES.recipeBuilder(material.getName() + "_purified_ore_to_gems").inputItems(stack).chancedOutput(exquisiteStack, 300, 100).chancedOutput(flawlessStack, 1000, 150).chancedOutput(gemStack, 3500, 500).chancedOutput(dustStack, 5000, 750).duration(400).EUt(16L);
                if (!flawedStack.m_41619_()) {
                    builder.chancedOutput(flawedStack, 2500, 300);
                }
                if (!chippedStack.m_41619_()) {
                    builder.chancedOutput(chippedStack, 3500, 400);
                }
                builder.save();
            }
        }
        GTOOreRecipeHandler.processMetalSmelting(property, TagPrefix.crushedPurified, material);
    }

    private static void processDirtyDust(@NotNull OreProperty property, @NotNull Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.dustImpure, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack dustStack = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTOOreRecipeHandler.getOutputMaterial(material));
        Material byproduct = property.getOreByProduct(0, material);
        RecipeBuilder builder = GTORecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder(material.getName() + "_dirty_dust_to_dust").inputItems(stack).outputItems(dustStack).duration((int)(material.getMass() << 2)).EUt(24L);
        if (byproduct.hasProperty(PropertyKey.DUST)) {
            builder.chancedOutput(TagPrefix.dust, byproduct, 1111, 0);
        } else {
            builder.outputFluids(byproduct.getFluid(16));
        }
        builder.save();
        GTORecipeTypes.ORE_WASHER_RECIPES.recipeBuilder(material.getName() + "_dirty_dust_to_dust").inputItems(stack).circuitMeta(2).inputFluids(GTMaterials.Water, 100).outputItems(dustStack).duration(8).EUt(4L).save();
        GTOOreRecipeHandler.processMetalSmelting(property, TagPrefix.dustImpure, material);
    }

    private static void processPureDust(@NotNull OreProperty property, @NotNull Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.dustPure, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        Material byproductMaterial = property.getOreByProduct(1, material);
        ItemStack dustStack = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTOOreRecipeHandler.getOutputMaterial(material));
        if (property.getSeparatedInto() != null && !property.getSeparatedInto().isEmpty()) {
            List separatedMaterial = property.getSeparatedInto();
            TagPrefix prefix = ((Material)separatedMaterial.get(separatedMaterial.size() - 1)).getBlastTemperature() == 0 && ((Material)separatedMaterial.get(separatedMaterial.size() - 1)).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dust;
            ItemStack separatedStack2 = ChemicalHelper.get((TagPrefix)prefix, (Material)((Material)separatedMaterial.get(separatedMaterial.size() - 1)), (int)(prefix == TagPrefix.nugget ? 2 : 1));
            GTORecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder(material.getName() + "_pure_dust_to_dust").inputItems(stack).outputItems(dustStack).chancedOutput(TagPrefix.dust, (Material)separatedMaterial.get(0), 1000, 250).chancedOutput(separatedStack2, prefix == TagPrefix.dust ? 500 : 2000, prefix == TagPrefix.dust ? 150 : 600).duration(200).EUt(24L).save();
        }
        GTORecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder(material.getName() + "_pure_dust_to_dust").inputItems(stack).outputItems(dustStack).chancedOutput(TagPrefix.dust, byproductMaterial, 1111, 0).duration(100).EUt(5L).save();
        GTORecipeTypes.ORE_WASHER_RECIPES.recipeBuilder(material.getName() + "_pure_dust_to_dust").inputItems(stack).circuitMeta(2).inputFluids(GTMaterials.Water, 100).outputItems(dustStack).duration(8).EUt(4L).save();
        GTOOreRecipeHandler.processMetalSmelting(property, TagPrefix.dustPure, material);
    }

    private static void processMetalSmelting(@NotNull OreProperty property, @NotNull TagPrefix prefix, @NotNull Material material) {
        ItemStack ingotStack;
        Material smeltingResult;
        Material material2 = smeltingResult = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
        if (smeltingResult.hasProperty(PropertyKey.INGOT) && !(ingotStack = ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)smeltingResult)).m_41619_() && GTOOreRecipeHandler.doesMaterialUseNormalFurnace(smeltingResult) && !prefix.isIgnored(material)) {
            VanillaRecipeHelper.addSmeltingRecipe((String)(prefix.name + "_" + material.getName()), (TagKey)ChemicalHelper.getTag((TagPrefix)prefix, (Material)material), (ItemStack)ingotStack, (float)0.5f);
        }
    }

    public static Material getOutputMaterial(Material material) {
        if (material == GTMaterials.Naquadah) {
            return GTOMaterials.NaquadahOxideMixture;
        }
        if (material == GTMaterials.Platinum) {
            return GTOMaterials.PlatinumMetal;
        }
        if (material == GTMaterials.Palladium) {
            return GTOMaterials.PalladiumMetal;
        }
        return material;
    }
}

