/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.data.recipe.misc.RecyclingRecipes;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

final class GTORecyclingRecipeHandler {
    private static final Set<TagPrefix> IGNORE_ARC_SMELTING = Set.of(TagPrefix.ingot, TagPrefix.gem, TagPrefix.nugget);

    GTORecyclingRecipeHandler() {
    }

    static void run(@NotNull Material material) {
        for (TagPrefix prefix : TagPrefix.values()) {
            if (!prefix.generateRecycling()) continue;
            GTORecyclingRecipeHandler.processCrushing(prefix, material);
        }
    }

    private static void processCrushing(@NotNull TagPrefix prefix, @NotNull Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)prefix, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>();
        long amount = prefix.getMaterialAmount(material);
        materialStacks.add(new MaterialStack(material, amount));
        materialStacks.addAll(prefix.secondaryMaterials());
        boolean ignoreArcSmelting = IGNORE_ARC_SMELTING.contains(prefix) && (!material.hasProperty(PropertyKey.INGOT) || ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getArcSmeltingInto() == material);
        RecyclingRecipes.registerRecyclingRecipes((ItemStack)stack, materialStacks, (boolean)ignoreArcSmelting, (TagPrefix)prefix);
        if (!material.hasProperty(PropertyKey.FLUID) || material.getFluid() == null || prefix == TagPrefix.dust && material.hasProperty(PropertyKey.BLAST)) {
            return;
        }
        GTORecipeTypes.LIQUEFACTION_FURNACE_RECIPES.recipeBuilder("extract_" + ItemUtils.getIdLocation((Item)stack.m_41720_()).m_135815_()).outputFluids(material.getFluid((int)(amount * 144L / 3628800L))).duration((int)Math.max(1L, amount * material.getMass() / 3628800L)).blastFurnaceTemp(Math.max(800, (int)((double)material.getBlastTemperature() * 0.6))).EUt((long)GTOUtils.getVoltageMultiplier((Material)material)).inputItems(stack).save();
    }
}

