/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.chemistry;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTORecipeTypes;

final class PolymerRecipes {
    PolymerRecipes() {
    }

    public static void init() {
        PolymerRecipes.polyethyleneProcess();
        PolymerRecipes.polyvinylChlorideProcess();
        PolymerRecipes.ptfeProcess();
        PolymerRecipes.epoxyProcess();
        PolymerRecipes.styreneButadieneProcess();
        PolymerRecipes.polybenzimidazoleProcess();
        PolymerRecipes.polycaprolactamProcess();
    }

    private static void polyethyleneProcess() {
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("ethylene_from_glycerol").inputFluids(GTMaterials.Glycerol, 1000).inputFluids(GTMaterials.CarbonDioxide, 1000).outputFluids(GTMaterials.Ethylene.getFluid(2000)).outputFluids(GTMaterials.Oxygen.getFluid(5000)).duration(400).EUt(200L).save();
    }

    private static void polyvinylChlorideProcess() {
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("vinyl_chloride_from_hydrochloric").circuitMeta(3).inputFluids(GTMaterials.Oxygen, 1000).inputFluids(GTMaterials.HydrochloricAcid, 1000).inputFluids(GTMaterials.Ethylene, 1000).outputFluids(GTMaterials.Water.getFluid(1000)).outputFluids(GTMaterials.VinylChloride.getFluid(1000)).duration(160).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("vinyl_chloride_from_chlorine").circuitMeta(1).inputFluids(GTMaterials.Chlorine, 2000).inputFluids(GTMaterials.Ethylene, 1000).outputFluids(GTMaterials.VinylChloride.getFluid(1000)).outputFluids(GTMaterials.HydrochloricAcid.getFluid(1000)).duration(160).EUt((long)GTValues.VA[1]).save();
    }

    private static void ptfeProcess() {
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("chloroform").circuitMeta(1).inputFluids(GTMaterials.Chlorine, 6000).inputFluids(GTMaterials.Methane, 1000).outputFluids(GTMaterials.HydrochloricAcid.getFluid(3000)).outputFluids(GTMaterials.Chloroform.getFluid(1000)).duration(80).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("tetrafluoroethylene_from_chloroform").inputFluids(GTMaterials.Chloroform, 2000).inputFluids(GTMaterials.HydrofluoricAcid, 4000).outputFluids(GTMaterials.HydrochloricAcid.getFluid(6000)).outputFluids(GTMaterials.Tetrafluoroethylene.getFluid(1000)).duration(480).EUt(240L).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("tetrafluoroethylene_from_methane").circuitMeta(24).inputFluids(GTMaterials.HydrofluoricAcid, 4000).inputFluids(GTMaterials.Methane, 2000).inputFluids(GTMaterials.Chlorine, 12000).outputFluids(GTMaterials.Tetrafluoroethylene.getFluid(1000)).outputFluids(GTMaterials.HydrochloricAcid.getFluid(12000)).duration(540).EUt((long)GTValues.VA[5]).save();
    }

    private static void epoxyProcess() {
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("glycerol_from_seed_oil_ethanol").inputItems(TagPrefix.dustTiny, GTMaterials.SodiumHydroxide).inputFluids(GTMaterials.SeedOil, 6000).inputFluids(GTMaterials.Ethanol, 1000).outputFluids(GTMaterials.Glycerol.getFluid(1000)).outputFluids(GTMaterials.BioDiesel.getFluid(6000)).duration(600).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("glycerol_from_fish_oil_ethanol").inputItems(TagPrefix.dustTiny, GTMaterials.SodiumHydroxide).inputFluids(GTMaterials.FishOil, 6000).inputFluids(GTMaterials.Ethanol, 1000).outputFluids(GTMaterials.Glycerol.getFluid(1000)).outputFluids(GTMaterials.BioDiesel.getFluid(6000)).duration(600).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("allyl_chloride").inputFluids(GTMaterials.Propene, 1000).inputFluids(GTMaterials.Chlorine, 2000).circuitMeta(1).outputFluids(GTMaterials.HydrochloricAcid.getFluid(1000)).outputFluids(GTMaterials.AllylChloride.getFluid(1000)).duration(160).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("epichlorohydrin_from_glycerol").circuitMeta(5).inputFluids(GTMaterials.Glycerol, 1000).inputFluids(GTMaterials.HydrochloricAcid, 1000).outputFluids(GTMaterials.Water.getFluid(2000)).outputFluids(GTMaterials.Epichlorohydrin.getFluid(1000)).duration(480).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("epichlorohydrin_from_allyl_chloride").inputItems(TagPrefix.dust, GTMaterials.SodiumHydroxide, 3).inputFluids(GTMaterials.AllylChloride, 1000).inputFluids(GTMaterials.HypochlorousAcid, 1000).outputFluids(GTMaterials.SaltWater.getFluid(1000)).outputFluids(GTMaterials.Epichlorohydrin.getFluid(1000)).duration(480).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("epichlorohydrin_shortcut_water").circuitMeta(23).inputFluids(GTMaterials.Chlorine, 4000).inputFluids(GTMaterials.Propene, 1000).inputFluids(GTMaterials.Water, 1000).inputItems(TagPrefix.dust, GTMaterials.SodiumHydroxide, 3).outputFluids(GTMaterials.Epichlorohydrin.getFluid(1000)).outputFluids(GTMaterials.HydrochloricAcid.getFluid(2000)).outputFluids(GTMaterials.SaltWater.getFluid(1000)).duration(640).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("epichlorohydrin_shortcut_hypochlorous").circuitMeta(24).inputFluids(GTMaterials.Chlorine, 2000).inputFluids(GTMaterials.Propene, 1000).inputFluids(GTMaterials.HypochlorousAcid, 1000).inputItems(TagPrefix.dust, GTMaterials.SodiumHydroxide, 3).outputFluids(GTMaterials.Epichlorohydrin.getFluid(1000)).outputFluids(GTMaterials.HydrochloricAcid.getFluid(1000)).outputFluids(GTMaterials.SaltWater.getFluid(1000)).duration(640).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("phenol_from_cumene").inputFluids(GTMaterials.Oxygen, 2000).inputFluids(GTMaterials.Cumene, 1000).outputFluids(GTMaterials.Phenol.getFluid(1000)).outputFluids(GTMaterials.Acetone.getFluid(1000)).duration(160).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("bisphenol_a").circuitMeta(1).inputFluids(GTMaterials.HydrochloricAcid, 1000).inputFluids(GTMaterials.Acetone, 1000).inputFluids(GTMaterials.Phenol, 2000).outputFluids(GTMaterials.BisphenolA.getFluid(1000)).outputFluids(GTMaterials.DilutedHydrochloricAcid.getFluid(1000)).duration(160).EUt((long)GTValues.VA[1]).save();
    }

    private static void styreneButadieneProcess() {
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("styrene_from_benzene").inputFluids(GTMaterials.Ethylene, 1000).inputFluids(GTMaterials.Benzene, 1000).outputFluids(GTMaterials.Hydrogen.getFluid(2000)).outputFluids(GTMaterials.Styrene.getFluid(1000)).duration(120).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("styrene_butadiene_rubber").inputItems(TagPrefix.dust, GTMaterials.RawStyreneButadieneRubber, 9).inputItems(TagPrefix.dust, GTMaterials.Sulfur).outputFluids(GTMaterials.StyreneButadieneRubber.getFluid(1296)).duration(600).EUt((long)GTValues.VA[1]).save();
    }

    private static void polybenzimidazoleProcess() {
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("diaminobenzidine").EUt((long)GTValues.VA[5]).duration(100).inputFluids(GTMaterials.Dichlorobenzidine, 1000).inputFluids(GTMaterials.Ammonia, 2000).notConsumable(TagPrefix.dust, GTMaterials.Zinc).outputFluids(GTMaterials.Diaminobenzidine.getFluid(1000)).outputFluids(GTMaterials.HydrochloricAcid.getFluid(2000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("dichlorobenzidine").EUt((long)GTValues.VA[4]).duration(200).inputItems(TagPrefix.dustTiny, GTMaterials.Copper).inputFluids(GTMaterials.Nitrochlorobenzene, 2000).inputFluids(GTMaterials.Hydrogen, 2000).outputFluids(GTMaterials.Dichlorobenzidine.getFluid(1000)).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("dichlorobenzidine_9").EUt((long)GTValues.VA[4]).duration(1800).inputItems(TagPrefix.dust, GTMaterials.Copper).inputFluids(GTMaterials.Nitrochlorobenzene, 18000).inputFluids(GTMaterials.Hydrogen, 18000).outputFluids(GTMaterials.Dichlorobenzidine.getFluid(9000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("nitrochlorobenzene").EUt((long)GTValues.VA[3]).duration(100).inputFluids(GTMaterials.NitrationMixture, 2000).inputFluids(GTMaterials.Chlorobenzene, 1000).outputFluids(GTMaterials.Nitrochlorobenzene.getFluid(1000)).outputFluids(GTMaterials.DilutedSulfuricAcid.getFluid(1000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("chlorobenzene").EUt((long)GTValues.VA[1]).duration(240).inputFluids(GTMaterials.Chlorine, 2000).inputFluids(GTMaterials.Benzene, 1000).circuitMeta(1).outputFluids(GTMaterials.Chlorobenzene.getFluid(1000)).outputFluids(GTMaterials.HydrochloricAcid.getFluid(1000)).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("diphenyl_isophtalate").EUt((long)GTValues.VA[5]).duration(100).inputFluids(GTMaterials.Phenol, 2000).inputFluids(GTMaterials.SulfuricAcid, 1000).inputFluids(GTMaterials.PhthalicAcid, 1000).outputFluids(GTMaterials.DiphenylIsophtalate.getFluid(1000)).outputFluids(GTMaterials.DilutedSulfuricAcid.getFluid(1000)).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("phthalic_acid_from_dimethylbenzene").EUt((long)GTValues.VA[4]).duration(100).inputItems(TagPrefix.dustTiny, GTMaterials.PotassiumDichromate).inputFluids(GTMaterials.Dimethylbenzene, 1000).inputFluids(GTMaterials.Oxygen, 2000).outputFluids(GTMaterials.PhthalicAcid.getFluid(1000)).outputFluids(GTMaterials.Water.getFluid(2000)).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("phthalic_acid_from_dimethylbenzene_9").EUt((long)GTValues.VA[4]).duration(900).inputItems(TagPrefix.dust, GTMaterials.PotassiumDichromate).inputFluids(GTMaterials.Dimethylbenzene, 9000).inputFluids(GTMaterials.Oxygen, 18000).outputFluids(GTMaterials.PhthalicAcid.getFluid(9000)).outputFluids(GTMaterials.Water.getFluid(18000)).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("phthalic_acid_from_naphthalene").EUt((long)GTValues.VA[1]).duration(125).inputFluids(GTMaterials.Naphthalene, 2000).inputFluids(GTMaterials.SulfuricAcid, 1000).inputItems(TagPrefix.dustTiny, GTMaterials.Potassium).outputFluids(GTMaterials.PhthalicAcid.getFluid(2500)).outputFluids(GTMaterials.HydrogenSulfide.getFluid(1000)).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("phthalic_acid_from_naphthalene_9").EUt((long)GTValues.VA[1]).duration(1125).inputFluids(GTMaterials.Naphthalene, 18000).inputFluids(GTMaterials.SulfuricAcid, 9000).inputItems(TagPrefix.dust, GTMaterials.Potassium).outputFluids(GTMaterials.PhthalicAcid.getFluid(22500)).outputFluids(GTMaterials.HydrogenSulfide.getFluid(9000)).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("dimethylbenzene").EUt((long)GTValues.VA[2]).duration(4000).inputFluids(GTMaterials.Methane, 2000).inputFluids(GTMaterials.Benzene, 1000).circuitMeta(1).outputFluids(GTMaterials.Dimethylbenzene.getFluid(1000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("potassium_dichromate").EUt((long)GTValues.VA[3]).duration(100).inputItems(TagPrefix.dust, GTMaterials.Saltpeter, 10).inputItems(TagPrefix.dust, GTMaterials.ChromiumTrioxide, 8).outputItems(TagPrefix.dust, GTMaterials.PotassiumDichromate, 11).outputFluids(GTMaterials.NitrogenDioxide.getFluid(2000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("chromium_trioxide").EUt(60L).duration(100).inputItems(TagPrefix.dust, GTMaterials.Chromium).inputFluids(GTMaterials.Oxygen, 3000).outputItems(TagPrefix.dust, GTMaterials.ChromiumTrioxide, 4).save();
    }

    private static void polycaprolactamProcess() {
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("cyclohexane").EUt((long)GTValues.VA[3]).duration(400).notConsumable(TagPrefix.dust, GTMaterials.Nickel).inputFluids(GTMaterials.Benzene, 1000).inputFluids(GTMaterials.Hydrogen, 6000).outputFluids(GTMaterials.Cyclohexane.getFluid(1000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("nitrosyl_chloride").EUt((long)GTValues.VA[1]).duration(100).inputFluids(GTMaterials.Chlorine, 1000).inputFluids(GTMaterials.NitricOxide, 1000).outputFluids(GTMaterials.NitrosylChloride.getFluid(1000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("cyclohexanone_oxime").EUt((long)GTValues.VA[2]).duration(100).inputFluids(GTMaterials.Cyclohexane, 1000).inputFluids(GTMaterials.NitrosylChloride, 1000).outputItems(TagPrefix.dust, GTMaterials.CyclohexanoneOxime, 19).outputFluids(GTMaterials.HydrochloricAcid.getFluid(1000)).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("caprolactam").EUt((long)GTValues.VA[3]).duration(200).inputItems(TagPrefix.dust, GTMaterials.CyclohexanoneOxime, 19).inputFluids(GTMaterials.SulfuricAcid, 1000).outputItems(TagPrefix.dust, GTMaterials.Caprolactam, 19).outputFluids(GTMaterials.DilutedSulfuricAcid.getFluid(1000)).save();
    }
}

