/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.configurable;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidContainerIngredient;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.RegistriesUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public final class RecipeAddition {
    public static void init() {
        RecipeAddition.hardMiscRecipes();
        RecipeAddition.hardRedstoneRecipes();
        RecipeAddition.disableManualCompression();
        RecipeAddition.hardToolArmorRecipes();
        RecipeAddition.harderRods();
        RecipeAddition.harderBrickRecipes();
        RecipeAddition.steelSteamMultiblocks();
        if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
            RecipeAddition.hardWoodRecipes();
        }
        if (ConfigHolder.INSTANCE.recipes.hardIronRecipes) {
            RecipeAddition.hardIronRecipes();
        }
        if (ConfigHolder.INSTANCE.recipes.hardGlassRecipes) {
            RecipeAddition.hardGlassRecipes();
        }
        if (ConfigHolder.INSTANCE.recipes.nerfPaperCrafting) {
            RecipeAddition.nerfPaperCrafting();
        }
        if (ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes) {
            RecipeAddition.hardAdvancedIronRecipes();
        }
        if (ConfigHolder.INSTANCE.recipes.flintAndSteelRequireSteel) {
            RecipeAddition.flintAndSteelRequireSteel();
        }
        if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
            RecipeAddition.vanillaBlockRecipes();
        }
    }

    private static void steelSteamMultiblocks() {
        if (ConfigHolder.INSTANCE.machines.steelSteamMultiblocks) {
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_oven", (ItemLike)GTMultiMachines.STEAM_OVEN.asItem(), (Object[])new Object[]{"CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_STEEL.m_5456_(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.m_5456_(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.right()).asItem(), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Invar)});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_grinder", (ItemLike)GTMultiMachines.STEAM_GRINDER.asItem(), (Object[])new Object[]{"CGC", "CFC", "CGC", Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.right()).asItem(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.m_5456_()});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_hatch", (ItemLike)GTMachines.STEAM_HATCH.asItem(), (Object[])new Object[]{"BPB", "BTB", "BPB", Character.valueOf('B'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('P'), new MaterialEntry(TagPrefix.pipeNormalFluid, GTMaterials.Steel), Character.valueOf('T'), GTMachines.STEEL_DRUM.asItem()});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_input_bus", (ItemLike)GTMachines.STEAM_IMPORT_BUS.asItem(), (Object[])new Object[]{"C", "H", Character.valueOf('H'), GTBlocks.STEEL_HULL.m_5456_(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_output_bus", (ItemLike)GTMachines.STEAM_EXPORT_BUS.asItem(), (Object[])new Object[]{"H", "C", Character.valueOf('H'), GTBlocks.STEEL_HULL.m_5456_(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN});
        } else {
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_oven", (ItemLike)GTMultiMachines.STEAM_OVEN.asItem(), (Object[])new Object[]{"CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_BRONZE.m_5456_(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.m_5456_(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.left()).asItem(), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Invar)});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_grinder", (ItemLike)GTMultiMachines.STEAM_GRINDER.asItem(), (Object[])new Object[]{"CGC", "CFC", "CGC", Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.left()).asItem(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.m_5456_()});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_hatch", (ItemLike)GTMachines.STEAM_HATCH.asItem(), (Object[])new Object[]{"BPB", "BTB", "BPB", Character.valueOf('B'), new MaterialEntry(TagPrefix.plate, GTMaterials.Bronze), Character.valueOf('P'), new MaterialEntry(TagPrefix.pipeNormalFluid, GTMaterials.Bronze), Character.valueOf('T'), GTMachines.BRONZE_DRUM.asItem()});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_input_bus", (ItemLike)GTMachines.STEAM_IMPORT_BUS.asItem(), (Object[])new Object[]{"C", "H", Character.valueOf('H'), GTBlocks.BRONZE_HULL.m_5456_(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"steam_output_bus", (ItemLike)GTMachines.STEAM_EXPORT_BUS.asItem(), (Object[])new Object[]{"H", "C", Character.valueOf('H'), GTBlocks.BRONZE_HULL.m_5456_(), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN});
        }
    }

    private static void disableManualCompression() {
        if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
            VanillaRecipeHelper.addShapelessRecipe((String)"nether_quartz_block_to_nether_quartz", (ItemStack)new ItemStack((ItemLike)Items.f_42692_, 4), (Object[])new Object[]{Blocks.f_50333_});
        }
    }

    private static void harderBrickRecipes() {
        if (ConfigHolder.INSTANCE.recipes.harderBrickRecipes) {
            VanillaRecipeHelper.addShapedFluidContainerRecipe((String)"brick_from_water", (ItemStack)new ItemStack((ItemLike)Blocks.f_50076_, 2), (Object[])new Object[]{"BBB", "BWB", "BBB", Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42460_), Character.valueOf('W'), new FluidContainerIngredient(GTMaterials.Water.getFluid(1000))});
            VanillaRecipeHelper.addShapedFluidContainerRecipe((boolean)true, (String)"casing_primitive_bricks", (ItemStack)GTBlocks.CASING_PRIMITIVE_BRICKS.asStack(), (Object[])new Object[]{"BGB", "BCB", "BGB", Character.valueOf('B'), GTItems.FIRECLAY_BRICK.m_5456_(), Character.valueOf('G'), new MaterialEntry(TagPrefix.dust, GTMaterials.Gypsum), Character.valueOf('C'), new FluidContainerIngredient(GTMaterials.Concrete.getFluid(1000))});
            VanillaRecipeHelper.addShapelessRecipe((String)"compressed_clay", (ItemStack)GTItems.COMPRESSED_CLAY.asStack(), (Object[])new Object[]{GTItems.WOODEN_FORM_BRICK.m_5456_(), new ItemStack((ItemLike)Items.f_42461_)});
            VanillaRecipeHelper.addSmeltingRecipe((String)"brick_from_compressed_clay", (ItemStack)GTItems.COMPRESSED_CLAY.asStack(), (ItemStack)new ItemStack((ItemLike)Items.f_42460_), (float)0.3f);
        } else {
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"casing_primitive_bricks", (ItemLike)GTBlocks.CASING_PRIMITIVE_BRICKS.m_5456_(), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), GTItems.FIRECLAY_BRICK});
        }
    }

    private static void hardWoodRecipes() {
        VanillaRecipeHelper.addShapedRecipe((String)"ladder", (ItemStack)new ItemStack((ItemLike)Blocks.f_50155_, 2), (Object[])new Object[]{"SrS", "SRS", "ShS", Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('R'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood)});
        VanillaRecipeHelper.addShapedRecipe((String)"bowl", (ItemStack)new ItemStack((ItemLike)Items.f_42399_), (Object[])new Object[]{"k", "X", Character.valueOf('X'), ItemTags.f_13168_});
        VanillaRecipeHelper.addShapedRecipe((String)"chest", (ItemStack)new ItemStack((ItemLike)Blocks.f_50087_), (Object[])new Object[]{"LPL", "PFP", "LPL", Character.valueOf('L'), ItemTags.f_13182_, Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_)});
        VanillaRecipeHelper.addShapedRecipe((String)"barrel", (ItemStack)new ItemStack((ItemLike)Blocks.f_50618_), (Object[])new Object[]{"PSP", "PsP", "PSP", Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('S'), ItemTags.f_13175_});
    }

    private static void hardIronRecipes() {
        VanillaRecipeHelper.addShapedRecipe((String)"cauldron", (ItemStack)new ItemStack((ItemLike)Items.f_42544_), (Object[])new Object[]{"X X", "XhX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron)});
        VanillaRecipeHelper.addShapedRecipe((String)"hopper", (ItemStack)new ItemStack((ItemLike)Blocks.f_50332_), (Object[])new Object[]{"XCX", "XGX", "wXh", Character.valueOf('X'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN, Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron)});
        VanillaRecipeHelper.addShapedRecipe((String)"iron_bars", (ItemStack)new ItemStack((ItemLike)Blocks.f_50183_, 8), (Object[])new Object[]{" h ", "XXX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron)});
        VanillaRecipeHelper.addShapedRecipe((String)"chain_iron", (ItemStack)new ItemStack((ItemLike)Items.f_42026_), (Object[])new Object[]{" R ", "wR ", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron)});
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chain_iron").inputItems(TagPrefix.ring, GTMaterials.Iron, 3).outputItems(Items.f_42026_, 2).circuitMeta(1).duration(40).EUt(10L).save();
        VanillaRecipeHelper.addShapedRecipe((String)"chain_wrought_iron", (ItemStack)new ItemStack((ItemLike)Items.f_42026_, 2), (Object[])new Object[]{" R ", "wR ", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.WroughtIron)});
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chain_wrought_iron").inputItems(TagPrefix.ring, GTMaterials.WroughtIron, 3).outputItems(Items.f_42026_, 3).circuitMeta(1).duration(40).EUt(10L).save();
        VanillaRecipeHelper.addShapedRecipe((String)"chain_steel", (ItemStack)new ItemStack((ItemLike)Items.f_42026_, 3), (Object[])new Object[]{" R ", "wR ", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Steel)});
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chain_steel").inputItems(TagPrefix.ring, GTMaterials.Steel, 3).outputItems(Items.f_42026_, 6).circuitMeta(1).duration(40).EUt(10L).save();
    }

    private static void hardRedstoneRecipes() {
        if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes) {
            VanillaRecipeHelper.addShapedRecipe((String)"dispenser", (ItemStack)new ItemStack((ItemLike)Blocks.f_50061_), (Object[])new Object[]{"CRC", "STS", "GAG", Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13166_, 2).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.spring, GTMaterials.Iron, 2).inputItems(TagPrefix.gearSmall, GTMaterials.Iron, 2).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(Items.f_42401_).outputItems((Object)Blocks.f_50061_).save();
            VanillaRecipeHelper.addShapedRecipe((String)"sticky_piston", (ItemStack)new ItemStack((ItemLike)Blocks.f_50032_), (Object[])new Object[]{"h", "R", "P", Character.valueOf('R'), new ItemStack((ItemLike)Items.f_42518_), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50039_)});
            VanillaRecipeHelper.addShapedRecipe((String)"piston_iron", (ItemStack)new ItemStack((ItemLike)Blocks.f_50039_), (Object[])new Object[]{"WWW", "GFG", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new MaterialEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('F'), ItemTags.f_13176_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron").inputItems(TagPrefix.rod, GTMaterials.Iron).inputItems(TagPrefix.gearSmall, GTMaterials.Iron).inputItems(ItemTags.f_13175_).inputItems(ItemTags.f_13166_).inputFluids(GTMaterials.RedAlloy.getFluid(144)).outputItems((Object)Blocks.f_50039_).duration(240).EUt((long)GTValues.VA[0]).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel").inputItems(TagPrefix.rod, GTMaterials.Steel).inputItems(TagPrefix.gearSmall, GTMaterials.Steel).inputItems(ItemTags.f_13175_, 2).inputItems(ItemTags.f_13166_, 2).inputFluids(GTMaterials.RedAlloy.getFluid(288)).outputItems(Blocks.f_50039_, 2).duration(240).EUt(16L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium").inputItems(TagPrefix.rod, GTMaterials.Aluminium).inputItems(TagPrefix.gearSmall, GTMaterials.Aluminium).inputItems(ItemTags.f_13175_, 4).inputItems(ItemTags.f_13166_, 4).inputFluids(GTMaterials.RedAlloy.getFluid(432)).outputItems(Blocks.f_50039_, 4).duration(240).EUt((long)GTValues.VA[1]).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_stainless_steel").inputItems(TagPrefix.rod, GTMaterials.StainlessSteel).inputItems(TagPrefix.gearSmall, GTMaterials.StainlessSteel).inputItems(ItemTags.f_13175_, 8).inputItems(ItemTags.f_13166_, 8).inputFluids(GTMaterials.RedAlloy.getFluid(576)).outputItems(Blocks.f_50039_, 8).duration(600).EUt((long)GTValues.VA[1]).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium").inputItems(TagPrefix.rod, GTMaterials.Titanium).inputItems(TagPrefix.gearSmall, GTMaterials.Titanium).inputItems(ItemTags.f_13175_, 16).inputItems(ItemTags.f_13166_, 16).inputFluids(GTMaterials.RedAlloy.getFluid(1152)).outputItems(Blocks.f_50039_, 16).duration(800).EUt((long)GTValues.VA[1]).save();
            VanillaRecipeHelper.addShapedRecipe((String)"stone_pressure_plate", (ItemStack)new ItemStack((ItemLike)Blocks.f_50165_, 2), (Object[])new Object[]{"ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), new ItemStack((ItemLike)Blocks.f_50404_), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron)});
            VanillaRecipeHelper.addShapedRecipe((String)"polished_blackstone_pressure_plate", (ItemStack)new ItemStack((ItemLike)Blocks.f_50709_, 2), (Object[])new Object[]{"ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), new ItemStack((ItemLike)Blocks.f_50708_), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron)});
            VanillaRecipeHelper.addShapedRecipe((String)"heavy_weighted_pressure_plate", (ItemStack)new ItemStack((ItemLike)Blocks.f_50326_), (Object[])new Object[]{"ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Steel)});
            VanillaRecipeHelper.addShapedRecipe((String)"light_weighted_pressure_plate", (ItemStack)new ItemStack((ItemLike)Blocks.f_50327_), (Object[])new Object[]{"ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Steel)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate").inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Gold).outputItems((Object)Blocks.f_50326_).duration(200).EUt(16L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate").inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Iron).outputItems((Object)Blocks.f_50327_).duration(200).EUt(16L).save();
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("stone_button").inputItems((Object)Blocks.f_50165_).outputItems(Blocks.f_50124_, 12).duration(25).EUt((long)GTValues.VA[0]).save();
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("blackstone_button").inputItems((Object)Blocks.f_50709_).outputItems(Blocks.f_50710_, 12).duration(25).EUt((long)GTValues.VA[0]).save();
            VanillaRecipeHelper.addShapedRecipe((String)"lever", (ItemStack)new ItemStack((ItemLike)Blocks.f_50164_), (Object[])new Object[]{"B", "S", Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50124_), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
            VanillaRecipeHelper.addShapedRecipe((String)"daylight_detector", (ItemStack)new ItemStack((ItemLike)Blocks.f_50329_), (Object[])new Object[]{"GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((String)"daylight_detector_certus", (ItemStack)new ItemStack((ItemLike)Blocks.f_50329_), (Object[])new Object[]{"GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((String)"daylight_detector_quartzite", (ItemStack)new ItemStack((ItemLike)Blocks.f_50329_), (Object[])new Object[]{"GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_, 1), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector").inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(Blocks.f_50058_, 3).inputItems(TagPrefix.gem, GTMaterials.NetherQuartz, 3).inputItems(ItemTags.f_13168_).outputItems((Object)Blocks.f_50329_).duration(200).EUt(16L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector_certus").inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(Blocks.f_50058_, 3).inputItems(TagPrefix.gem, GTMaterials.CertusQuartz, 3).inputItems(ItemTags.f_13168_).outputItems((Object)Blocks.f_50329_).duration(200).EUt(16L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector_quartzite").inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(Blocks.f_50058_, 3).inputItems(TagPrefix.gem, GTMaterials.Quartzite, 3).inputItems(ItemTags.f_13168_).outputItems((Object)Blocks.f_50329_).duration(200).EUt(16L).save();
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"redstone_lamp", (ItemStack)new ItemStack((ItemLike)Blocks.f_50261_), (Object[])new Object[]{"PPP", "PGP", "PRP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50185_), Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50141_), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"tripwire_hook", (ItemStack)new ItemStack((ItemLike)Blocks.f_50266_), (Object[])new Object[]{"IRI", "SRS", " S ", Character.valueOf('I'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_)});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"dropper", (ItemStack)new ItemStack((ItemLike)Blocks.f_50286_), (Object[])new Object[]{"CRC", "STS", "GAG", Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.springSmall, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"observer", (ItemStack)new ItemStack((ItemLike)Blocks.f_50455_), (Object[])new Object[]{"RCR", "CQC", "GSG", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((String)"observer_certus", (ItemStack)new ItemStack((ItemLike)Blocks.f_50455_), (Object[])new Object[]{"RCR", "CQC", "GSG", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((String)"observer_quartzite", (ItemStack)new ItemStack((ItemLike)Blocks.f_50455_), (Object[])new Object[]{"RCR", "CQC", "GSG", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((String)"repeater", (ItemStack)new ItemStack((ItemLike)Items.f_42350_), (Object[])new Object[]{"S S", "TdT", "PRP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            VanillaRecipeHelper.addShapedRecipe((String)"comparator", (ItemStack)new ItemStack((ItemLike)Items.f_42351_), (Object[])new Object[]{"STS", "TQT", "PdP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_)});
            VanillaRecipeHelper.addShapedRecipe((String)"comparator_certus", (ItemStack)new ItemStack((ItemLike)Items.f_42351_), (Object[])new Object[]{"STS", "TQT", "PdP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_)});
            VanillaRecipeHelper.addShapedRecipe((String)"comparator_quartzite", (ItemStack)new ItemStack((ItemLike)Items.f_42351_), (Object[])new Object[]{"STS", "TQT", "PdP", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new MaterialEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_)});
            VanillaRecipeHelper.addShapedRecipe((String)"powered_rail", (ItemStack)new ItemStack((ItemLike)Blocks.f_50030_, 6), (Object[])new Object[]{"SPS", "IWI", "GdG", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('G'), new MaterialEntry(TagPrefix.rod, GTMaterials.Gold)});
            VanillaRecipeHelper.addShapedRecipe((String)"detector_rail", (ItemStack)new ItemStack((ItemLike)Blocks.f_50031_, 6), (Object[])new Object[]{"SPS", "IWI", "IdI", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50327_), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
            VanillaRecipeHelper.addShapedRecipe((String)"rail", (ItemStack)new ItemStack((ItemLike)Blocks.f_50156_, 8), (Object[])new Object[]{"ShS", "IWI", "IdI", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
            VanillaRecipeHelper.addShapedRecipe((String)"activator_rail", (ItemStack)new ItemStack((ItemLike)Blocks.f_50285_, 6), (Object[])new Object[]{"SPS", "IWI", "IdI", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('I'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), Tags.Items.RODS_WOODEN});
            VanillaRecipeHelper.addShapedRecipe((String)"redstone_torch", (ItemStack)new ItemStack((ItemLike)Blocks.f_50174_), (Object[])new Object[]{"R", "T", Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50081_)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("calibrated_sculk_sensor").inputItems((Object)Blocks.f_152500_).inputItems(TagPrefix.gem, GTMaterials.Amethyst).inputItems(TagPrefix.plate, GTMaterials.Amethyst).outputItems((Object)Blocks.f_276595_).duration(200).EUt(16L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"target", (ItemStack)new ItemStack((ItemLike)Items.f_42793_), (Object[])new Object[]{"RBR", "PHP", "RPR", Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42516_), Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42129_), Character.valueOf('B'), ItemTags.f_13170_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("target").inputItems(TagPrefix.dust, GTMaterials.Redstone, 4).inputItems(ItemTags.f_13170_).inputItems(Items.f_42516_, 3).inputItems(Items.f_42129_).outputItems(Items.f_42793_).duration(200).EUt(120L).save();
        } else {
            VanillaRecipeHelper.addShapedRecipe((String)"piston_bronze", (ItemStack)new ItemStack((ItemLike)Blocks.f_50039_, 1), (Object[])new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Bronze)});
            VanillaRecipeHelper.addShapedRecipe((String)"piston_steel", (ItemStack)new ItemStack((ItemLike)Blocks.f_50039_, 2), (Object[])new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Steel)});
            VanillaRecipeHelper.addShapedRecipe((String)"piston_aluminium", (ItemStack)new ItemStack((ItemLike)Blocks.f_50039_, 4), (Object[])new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Aluminium)});
            VanillaRecipeHelper.addShapedRecipe((String)"piston_titanium", (ItemStack)new ItemStack((ItemLike)Blocks.f_50039_, 8), (Object[])new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new MaterialEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new MaterialEntry(TagPrefix.ingot, GTMaterials.Titanium)});
            VanillaRecipeHelper.addShapedRecipe((String)"sticky_piston_resin", (ItemStack)new ItemStack((ItemLike)Blocks.f_50032_), (Object[])new Object[]{"h", "R", "P", Character.valueOf('R'), GTItems.STICKY_RESIN.m_5456_(), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50039_)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems(ItemTags.f_13168_, 3).inputItems(ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems((Object)Blocks.f_50039_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_bronze").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Bronze).inputItems(ItemTags.f_13168_, 3).inputItems(ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems((Object)Blocks.f_50039_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel).inputItems(ItemTags.f_13168_, 3).inputItems(ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(Blocks.f_50039_, 2).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium).inputItems(ItemTags.f_13168_, 3).inputItems(ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(Blocks.f_50039_, 4).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium").duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium).inputItems(ItemTags.f_13168_, 3).inputItems(ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(Blocks.f_50039_, 8).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate").inputItems(TagPrefix.plate, GTMaterials.Gold, 2).outputItems((Object)Blocks.f_50326_).circuitMeta(3).duration(100).EUt(4L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate").inputItems(TagPrefix.plate, GTMaterials.Iron, 2).outputItems((Object)Blocks.f_50327_).circuitMeta(2).duration(100).EUt(4L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"comparator_certus", (ItemStack)new ItemStack((ItemLike)Items.f_42351_), (Object[])new Object[]{" T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new MaterialEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_)});
            VanillaRecipeHelper.addShapedRecipe((String)"comparator_quartzite", (ItemStack)new ItemStack((ItemLike)Items.f_42351_), (Object[])new Object[]{" T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new MaterialEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_)});
            VanillaRecipeHelper.addShapedRecipe((String)"daylight_detector_certus", (ItemStack)new ItemStack((ItemLike)Blocks.f_50329_), (Object[])new Object[]{"GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('C'), new MaterialEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('P'), ItemTags.f_13175_});
            VanillaRecipeHelper.addShapedRecipe((String)"daylight_detector_quartzite", (ItemStack)new ItemStack((ItemLike)Blocks.f_50329_), (Object[])new Object[]{"GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('C'), new MaterialEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('P'), ItemTags.f_13175_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block").duration(100).EUt(16L).inputItems(ItemTags.f_13168_, 8).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(1).outputItems((Object)Blocks.f_50065_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox").duration(100).EUt(16L).inputItems(ItemTags.f_13168_, 8).inputItems(TagPrefix.gem, GTMaterials.Diamond).outputItems((Object)Blocks.f_50131_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("target").duration(100).EUt(16L).inputItems(Items.f_42451_, 4).inputItems(Items.f_42129_).outputItems((Object)Blocks.f_50716_).save();
        }
    }

    private static void hardToolArmorRecipes() {
        if (ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes) {
            RecipeAddition.createShovelRecipe("iron_shovel", new ItemStack((ItemLike)Items.f_42384_), GTMaterials.Iron);
            RecipeAddition.createPickaxeRecipe("iron_pickaxe", new ItemStack((ItemLike)Items.f_42385_), GTMaterials.Iron);
            RecipeAddition.createAxeRecipe("iron_axe", new ItemStack((ItemLike)Items.f_42386_), GTMaterials.Iron);
            RecipeAddition.createSwordRecipe("iron_sword", new ItemStack((ItemLike)Items.f_42383_), GTMaterials.Iron);
            RecipeAddition.createHoeRecipe("iron_hoe", new ItemStack((ItemLike)Items.f_42387_), GTMaterials.Iron);
            RecipeAddition.createHelmetRecipe("iron_helmet", new ItemStack((ItemLike)Items.f_42468_), GTMaterials.Iron);
            RecipeAddition.createChestplateRecipe("iron_chestplate", new ItemStack((ItemLike)Items.f_42469_), GTMaterials.Iron);
            RecipeAddition.createLeggingsRecipe("iron_leggings", new ItemStack((ItemLike)Items.f_42470_), GTMaterials.Iron);
            RecipeAddition.createBootsRecipe("iron_boots", new ItemStack((ItemLike)Items.f_42471_), GTMaterials.Iron);
            RecipeAddition.createShovelRecipe("golden_shovel", new ItemStack((ItemLike)Items.f_42431_), GTMaterials.Gold);
            RecipeAddition.createPickaxeRecipe("golden_pickaxe", new ItemStack((ItemLike)Items.f_42432_), GTMaterials.Gold);
            RecipeAddition.createAxeRecipe("golden_axe", new ItemStack((ItemLike)Items.f_42433_), GTMaterials.Gold);
            RecipeAddition.createSwordRecipe("golden_sword", new ItemStack((ItemLike)Items.f_42430_), GTMaterials.Gold);
            RecipeAddition.createHoeRecipe("golden_hoe", new ItemStack((ItemLike)Items.f_42434_), GTMaterials.Gold);
            RecipeAddition.createHelmetRecipe("golden_helmet", new ItemStack((ItemLike)Items.f_42476_), GTMaterials.Gold);
            RecipeAddition.createChestplateRecipe("golden_chestplate", new ItemStack((ItemLike)Items.f_42477_), GTMaterials.Gold);
            RecipeAddition.createLeggingsRecipe("golden_leggings", new ItemStack((ItemLike)Items.f_42478_), GTMaterials.Gold);
            RecipeAddition.createBootsRecipe("golden_boots", new ItemStack((ItemLike)Items.f_42479_), GTMaterials.Gold);
            RecipeAddition.createShovelRecipe("diamond_shovel", new ItemStack((ItemLike)Items.f_42389_), GTMaterials.Diamond);
            RecipeAddition.createPickaxeRecipe("diamond_pickaxe", new ItemStack((ItemLike)Items.f_42390_), GTMaterials.Diamond);
            RecipeAddition.createAxeRecipe("diamond_axe", new ItemStack((ItemLike)Items.f_42391_), GTMaterials.Diamond);
            RecipeAddition.createSwordRecipe("diamond_sword", new ItemStack((ItemLike)Items.f_42388_), GTMaterials.Diamond);
            RecipeAddition.createHoeRecipe("diamond_hoe", new ItemStack((ItemLike)Items.f_42392_), GTMaterials.Diamond);
            RecipeAddition.createHelmetRecipe("diamond_helmet", new ItemStack((ItemLike)Items.f_42472_), GTMaterials.Diamond);
            RecipeAddition.createChestplateRecipe("diamond_chestplate", new ItemStack((ItemLike)Items.f_42473_), GTMaterials.Diamond);
            RecipeAddition.createLeggingsRecipe("diamond_leggings", new ItemStack((ItemLike)Items.f_42474_), GTMaterials.Diamond);
            RecipeAddition.createBootsRecipe("diamond_boots", new ItemStack((ItemLike)Items.f_42475_), GTMaterials.Diamond);
            VanillaRecipeHelper.addShapedRecipe((String)"compass", (ItemStack)new ItemStack((ItemLike)Items.f_42522_), (Object[])new Object[]{"SGB", "RPR", "AdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50185_), Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.IronMagnetic), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Zinc), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('A'), new MaterialEntry(TagPrefix.bolt, GTMaterials.RedAlloy)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass").inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Zinc).inputItems(TagPrefix.bolt, GTMaterials.RedAlloy).inputItems(TagPrefix.bolt, GTMaterials.IronMagnetic).inputItems(TagPrefix.screw, GTMaterials.Iron, 2).outputItems(Items.f_42522_).duration(100).EUt(16L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"fishing_rod", (ItemStack)new ItemStack((ItemLike)Items.f_42523_), (Object[])new Object[]{"  S", " SL", "SxR", Character.valueOf('S'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron)});
            VanillaRecipeHelper.addShapedRecipe((String)"clock", (ItemStack)new ItemStack((ItemLike)Items.f_42524_), (Object[])new Object[]{"RPR", "BCB", "dSw", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Gold), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Gold), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42351_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Gold)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock").inputItems(TagPrefix.plate, GTMaterials.Gold).inputItems(TagPrefix.ring, GTMaterials.Gold).inputItems(TagPrefix.bolt, GTMaterials.Gold, 2).inputItems(TagPrefix.screw, GTMaterials.Gold).inputItems(Items.f_42351_).outputItems(Items.f_42524_).duration(100).EUt(16L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"shears", (ItemStack)new ItemStack((ItemLike)Items.f_42574_), (Object[])new Object[]{"PSP", "hRf", "TdT", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
            VanillaRecipeHelper.addShapedRecipe((String)"shield", (ItemStack)new ItemStack((ItemLike)Items.f_42740_), (Object[])new Object[]{"BRB", "LPL", "BRB", Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('L'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood)});
            VanillaRecipeHelper.addShapedRecipe((String)"bow", (ItemStack)new ItemStack((ItemLike)Items.f_42411_), (Object[])new Object[]{"hLS", "LRS", "fLS", Character.valueOf('L'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron)});
            VanillaRecipeHelper.addShapedRecipe((String)"crossbow", (ItemStack)new ItemStack((ItemLike)Items.f_42717_), (Object[])new Object[]{"RIR", "STS", "sRf", Character.valueOf('R'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('T'), new ItemStack((ItemLike)Items.f_42109_), Character.valueOf('I'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron)});
        } else {
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass").inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(1).outputItems(Items.f_42522_).duration(100).EUt(4L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock").inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Gold, 4).outputItems(Items.f_42524_).duration(100).EUt(4L).save();
        }
    }

    private static void harderRods() {
        if (ConfigHolder.INSTANCE.recipes.harderRods) {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone").inputItems(ItemTags.f_13166_).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt((long)GTValues.VA[0]).save();
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone").inputItems((Object)Blocks.f_50069_).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt((long)GTValues.VA[0]).save();
        } else {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone").inputItems(ItemTags.f_13166_).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt((long)GTValues.VA[0]).save();
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone").inputItems((Object)Blocks.f_50069_).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt((long)GTValues.VA[0]).save();
        }
    }

    private static void hardMiscRecipes() {
        if (ConfigHolder.INSTANCE.recipes.hardMiscRecipes) {
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"beacon", (ItemStack)new ItemStack((ItemLike)Blocks.f_50273_), (Object[])new Object[]{"GLG", "GSG", "OOO", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('L'), new MaterialEntry(TagPrefix.lens, GTMaterials.NetherStar), Character.valueOf('S'), new MaterialEntry(TagPrefix.gem, GTMaterials.NetherStar), Character.valueOf('O'), new MaterialEntry(TagPrefix.plate, GTMaterials.Obsidian)});
            VanillaRecipeHelper.addShapedRecipe((String)"jack_o_lantern", (ItemStack)new ItemStack((ItemLike)Blocks.f_50144_), (Object[])new Object[]{"PT", "k ", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50133_), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50081_)});
            VanillaRecipeHelper.addShapedRecipe((String)"book", (ItemStack)new ItemStack((ItemLike)Items.f_42517_), (Object[])new Object[]{"SPL", "SPG", "SPL", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42516_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('G'), GTItems.STICKY_RESIN.m_5456_()});
            VanillaRecipeHelper.addShapedRecipe((String)"brewing_stand", (ItemStack)new ItemStack((ItemLike)Items.f_42543_), (Object[])new Object[]{"RBR", "ABA", "SCS", Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Aluminium), Character.valueOf('B'), new MaterialEntry(TagPrefix.rod, GTMaterials.Blaze), Character.valueOf('A'), new MaterialEntry(TagPrefix.rod, GTMaterials.Aluminium), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Aluminium), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42544_)});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"enchanting_table", (ItemStack)new ItemStack((ItemLike)Blocks.f_50201_), (Object[])new Object[]{"DCD", "PBP", "DPD", Character.valueOf('D'), new MaterialEntry(TagPrefix.gem, GTMaterials.Diamond), Character.valueOf('C'), new ItemStack((ItemLike)Blocks.f_50350_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Obsidian), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50078_)});
            VanillaRecipeHelper.addShapedRecipe((String)"jukebox", (ItemStack)new ItemStack((ItemLike)Blocks.f_50131_), (Object[])new Object[]{"LBL", "NRN", "LGL", Character.valueOf('L'), ItemTags.f_13182_, Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Diamond), Character.valueOf('N'), new ItemStack((ItemLike)Blocks.f_50065_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Iron)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox").inputItems(TagPrefix.bolt, GTMaterials.Diamond).inputItems(TagPrefix.gear, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(Blocks.f_50065_, 2).outputItems((Object)Blocks.f_50131_).duration(100).EUt(16L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"note_block", (ItemStack)new ItemStack((ItemLike)Blocks.f_50065_), (Object[])new Object[]{"PPP", "BGB", "PRP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50183_), Character.valueOf('G'), new MaterialEntry(TagPrefix.gear, GTMaterials.Wood), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.RedAlloy)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block").inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(TagPrefix.gear, GTMaterials.Wood).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(Blocks.f_50183_, 2).outputItems((Object)Blocks.f_50065_).duration(100).EUt(16L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"furnace", (ItemStack)new ItemStack((ItemLike)Blocks.f_50094_), (Object[])new Object[]{"CCC", "FFF", "CCC", Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_), Character.valueOf('C'), ItemTags.f_13166_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace").circuitMeta(8).inputItems(ItemTags.f_13166_, 8).inputItems(Items.f_42484_).outputItems((Object)Blocks.f_50094_).duration(100).EUt((long)GTValues.VA[0]).save();
            VanillaRecipeHelper.addShapedRecipe((String)"crafting_table", (ItemStack)new ItemStack((ItemLike)Blocks.f_50091_), (Object[])new Object[]{"FF", "WW", Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_), Character.valueOf('W'), ItemTags.f_13182_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table").duration(80).EUt(6L).inputItems(ItemTags.f_13182_).inputItems(Items.f_42484_).outputItems((Object)Blocks.f_50091_).save();
            VanillaRecipeHelper.addShapedRecipe((String)"lead", (ItemStack)new ItemStack((ItemLike)Items.f_42655_), (Object[])new Object[]{"SSS", "SBS", "SSS", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42518_)});
            VanillaRecipeHelper.addShapedRecipe((String)"item_frame", (ItemStack)new ItemStack((ItemLike)Items.f_42617_), (Object[])new Object[]{"SRS", "TLT", "TTT", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_)});
            VanillaRecipeHelper.addShapedRecipe((String)"painting", (ItemStack)new ItemStack((ItemLike)Items.f_42487_), (Object[])new Object[]{"SRS", "TCT", "TTT", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('C'), ItemTags.f_215867_});
            VanillaRecipeHelper.addShapedRecipe((String)"chest_minecart", (ItemStack)new ItemStack((ItemLike)Items.f_42519_), (Object[])new Object[]{"hIw", " M ", " d ", Character.valueOf('I'), Tags.Items.CHESTS_WOODEN, Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_)});
            VanillaRecipeHelper.addShapedRecipe((String)"furnace_minecart", (ItemStack)new ItemStack((ItemLike)Items.f_42520_), (Object[])new Object[]{"hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50094_), Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_)});
            VanillaRecipeHelper.addShapedRecipe((String)"tnt_minecart", (ItemStack)new ItemStack((ItemLike)Items.f_42693_), (Object[])new Object[]{"hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50077_), Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_)});
            VanillaRecipeHelper.addShapedRecipe((String)"hopper_minecart", (ItemStack)new ItemStack((ItemLike)Items.f_42694_), (Object[])new Object[]{"hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50332_), Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_)});
            VanillaRecipeHelper.addShapedRecipe((String)"flower_pot", (ItemStack)new ItemStack((ItemLike)Items.f_42618_), (Object[])new Object[]{"BfB", " B ", Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42460_)});
            VanillaRecipeHelper.addShapedRecipe((String)"armor_stand", (ItemStack)new ItemStack((ItemLike)Items.f_42650_), (Object[])new Object[]{"BSB", "hSs", "IPI", Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('I'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_)});
            VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"trapped_chest", (ItemStack)new ItemStack((ItemLike)Blocks.f_50325_), (Object[])new Object[]{" H ", "SCS", " d ", Character.valueOf('H'), new ItemStack((ItemLike)Blocks.f_50266_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('C'), new ItemStack((ItemLike)Blocks.f_50087_)});
            VanillaRecipeHelper.addShapedRecipe((String)"lantern", (ItemStack)new ItemStack((ItemLike)Blocks.f_50681_), (Object[])new Object[]{"hRf", "RFR", " R ", Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50081_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lantern").inputItems((Object)Blocks.f_50081_).inputItems(TagPrefix.ring, GTMaterials.Iron, 4).outputItems((Object)Blocks.f_50681_).duration(100).EUt(1L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"soul_lantern", (ItemStack)new ItemStack((ItemLike)Blocks.f_50682_), (Object[])new Object[]{"hRf", "RFR", " R ", Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50139_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern").inputItems((Object)Blocks.f_50139_).inputItems(TagPrefix.ring, GTMaterials.Iron, 4).outputItems((Object)Blocks.f_50682_).duration(100).EUt(1L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"stonecutter", (ItemStack)new ItemStack((ItemLike)Blocks.f_50679_), (Object[])new Object[]{"f d", "SBS", "XXX", Character.valueOf('X'), new ItemStack((ItemLike)Blocks.f_50404_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('B'), new MaterialEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron)});
            VanillaRecipeHelper.addShapedRecipe((String)"cartography_table", (ItemStack)new ItemStack((ItemLike)Blocks.f_50621_), (Object[])new Object[]{"sPd", "WWW", "SLS", Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42516_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.TreatedWood), Character.valueOf('L'), ItemTags.f_13182_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cartography_table").inputItems(Items.f_42516_).inputItems(ItemTags.f_13182_).outputItems((Object)Blocks.f_50621_).duration(80).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"fletching_table", (ItemStack)new ItemStack((ItemLike)Blocks.f_50622_), (Object[])new Object[]{"sPd", "WWW", "SLS", Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42402_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('L'), ItemTags.f_13182_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fletching_table").inputItems(Items.f_42402_).inputItems(ItemTags.f_13182_).outputItems((Object)Blocks.f_50622_).duration(80).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"smithing_table", (ItemStack)new ItemStack((ItemLike)Blocks.f_50625_), (Object[])new Object[]{"h d", "WWW", "SLS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.WroughtIron), Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('L'), ItemTags.f_13182_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smithing_table").inputItems(TagPrefix.screw, GTMaterials.WroughtIron, 2).inputItems(ItemTags.f_13182_).inputItems(TagPrefix.plate, GTMaterials.Steel, 3).outputItems((Object)Blocks.f_50625_).duration(80).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"grindstone", (ItemStack)new ItemStack((ItemLike)Blocks.f_50623_), (Object[])new Object[]{"hBd", "IXI", "WfW", Character.valueOf('X'), new ItemStack((ItemLike)Blocks.f_50404_), Character.valueOf('B'), new MaterialEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron), Character.valueOf('I'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('W'), new MaterialEntry(TagPrefix.rodLong, GTMaterials.Wood)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("grindstone").inputItems((Object)Blocks.f_50404_).inputItems(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron).inputItems(TagPrefix.rodLong, GTMaterials.Wood, 2).outputItems((Object)Blocks.f_50623_).duration(80).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"loom", (ItemStack)new ItemStack((ItemLike)Blocks.f_50617_), (Object[])new Object[]{"SSS", "PdP", "XYX", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('X'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('Y'), ItemTags.f_13168_});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("loom").inputItems(Items.f_42401_, 3).inputItems(TagPrefix.plate, GTMaterials.Wood, 2).inputItems(ItemTags.f_13168_).outputItems((Object)Blocks.f_50617_).duration(80).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"smoker", (ItemStack)new ItemStack((ItemLike)Blocks.f_50619_), (Object[])new Object[]{"wId", "PFP", "XPX", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50183_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.TreatedWood), Character.valueOf('X'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50094_)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smoker").inputItems((Object)Blocks.f_50183_).inputItems(ItemTags.f_13168_, 3).inputItems((Object)Blocks.f_50094_).outputItems((Object)Blocks.f_50619_).duration(80).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"blast_furnace", (ItemStack)new ItemStack((ItemLike)Blocks.f_50620_), (Object[])new Object[]{"wfd", "PFP", "XPX", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('X'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50094_)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("blast_furnace").inputItems(TagPrefix.plate, GTMaterials.Iron, 3).inputItems((Object)Blocks.f_50094_).outputItems((Object)Blocks.f_50620_).duration(80).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"composter", (ItemStack)new ItemStack((ItemLike)Blocks.f_50715_), (Object[])new Object[]{"PsP", "P P", "XPX", Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('X'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("composter").inputItems(ItemTags.f_13168_, 4).circuitMeta(23).outputItems((Object)Blocks.f_50715_).duration(80).EUt(6L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bell").inputItems(Items.f_42398_).inputItems(TagPrefix.rod, GTMaterials.Stone, 2).inputItems(TagPrefix.bolt, GTMaterials.Iron, 2).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems((Object)Blocks.f_50680_).duration(200).EUt(16L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"candle", (ItemStack)new ItemStack((ItemLike)Blocks.f_152482_), (Object[])new Object[]{"r", "S", "W", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('W'), new ItemStack((ItemLike)Items.f_42784_)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lodestone").inputItems(TagPrefix.plateDense, GTMaterials.SteelMagnetic).inputItems(TagPrefix.screw, GTMaterials.Iron, 4).inputItems(TagPrefix.plate, GTMaterials.Stone, 4).outputItems((Object)Blocks.f_50729_).duration(200).EUt(16L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("music_disc_5").inputItems(Items.f_220218_, 9).outputItems(Items.f_220217_).duration(100).EUt(6L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"turtle_helmet", (ItemStack)new ItemStack((ItemLike)Items.f_42354_), (Object[])new Object[]{"SSS", "SrS", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42355_)});
            VanillaRecipeHelper.addShapedRecipe((String)"scaffolding", (ItemStack)new ItemStack((ItemLike)Blocks.f_50616_, 3), (Object[])new Object[]{"BSB", "BWB", "BrB", Character.valueOf('B'), new ItemStack((ItemLike)Items.f_41911_), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('W'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("scaffolding").inputItems(Items.f_41911_, 6).inputItems(Items.f_42401_).outputItems(Blocks.f_50616_, 4).duration(100).EUt(4L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"beehive", (ItemStack)new ItemStack((ItemLike)Blocks.f_50718_, 1), (Object[])new Object[]{"PsP", "WXW", "PdP", Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('W'), new MaterialEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('X'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("beehive").inputItems(TagPrefix.screw, GTMaterials.Wood, 2).inputItems(ItemTags.f_13168_, 5).circuitMeta(2).outputItems((Object)Blocks.f_50718_).duration(100).EUt(4L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"lightning_rod", (ItemStack)new ItemStack((ItemLike)Blocks.f_152587_), (Object[])new Object[]{" B ", "fRh", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, GTMaterials.Copper), Character.valueOf('B'), new MaterialEntry(TagPrefix.plateDouble, GTMaterials.Copper)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lightning_rod").inputItems(TagPrefix.rod, GTMaterials.Copper, 2).inputItems(TagPrefix.plateDouble, GTMaterials.Copper).outputItems((Object)Blocks.f_152587_).duration(100).EUt(4L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chiseled_bookshelf").inputItems(ItemTags.f_13168_, 6).circuitMeta(4).outputItems((Object)Blocks.f_244299_).duration(100).EUt(4L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"lectern", (ItemStack)new ItemStack((ItemLike)Blocks.f_50624_), (Object[])new Object[]{"SSS", "WBW", "dSs", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('W'), new MaterialEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50078_)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lectern").inputItems(ItemTags.f_13168_, 2).inputItems(TagPrefix.screw, GTMaterials.Wood, 2).inputItems((Object)Blocks.f_50078_).outputItems((Object)Blocks.f_50624_).duration(100).EUt(4L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"brush", (ItemStack)new ItemStack((ItemLike)Items.f_271356_), (Object[])new Object[]{" F ", "fRr", " S ", Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Copper), Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42402_)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("brush").inputItems(TagPrefix.rodLong, GTMaterials.Wood).inputItems(TagPrefix.ring, GTMaterials.Copper).inputItems(Items.f_42402_).outputItems(Items.f_271356_).duration(100).EUt(4L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"spyglass", (ItemStack)new ItemStack((ItemLike)Items.f_151059_), (Object[])new Object[]{"hGd", "LRS", "fP ", Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('G'), new MaterialEntry(TagPrefix.lens, GTMaterials.Glass), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Gold), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Copper)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("spyglass").inputItems(TagPrefix.lens, GTMaterials.Glass).inputItems(TagPrefix.ring, GTMaterials.Gold).inputItems(TagPrefix.plate, GTMaterials.Copper).inputItems(Items.f_42454_).outputItems(Items.f_151059_).duration(100).EUt(4L).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("recovery_compass").inputItems(Items.f_42522_).inputItems(TagPrefix.plate, GTMaterials.EchoShard, 8).inputItems(TagPrefix.rod, GTMaterials.EchoShard).outputItems(Items.f_220211_).duration(400).EUt(30L).save();
            VanillaRecipeHelper.addShapedRecipe((String)"respawn_anchor", (ItemStack)new ItemStack((ItemLike)Items.f_42767_), (Object[])new Object[]{"CCC", "GGG", "CCC", Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42754_), Character.valueOf('G'), new MaterialEntry(TagPrefix.plate, GTMaterials.Glowstone)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("respawn_anchor").inputItems(Items.f_42754_, 6).inputItems(TagPrefix.plate, GTMaterials.Glowstone, 3).outputItems(Items.f_42767_).duration(200).EUt(120L).save();
            for (DyeColor color : DyeColor.values()) {
                RecipeAddition.addBedRecipe(color);
                RecipeAddition.addCarpetRecipe(color);
            }
        } else {
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table").duration(80).EUt(6L).circuitMeta(4).inputItems(ItemTags.f_13168_, 4).outputItems((Object)Blocks.f_50091_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace").circuitMeta(8).inputItems(ItemTags.f_13166_, 8).outputItems((Object)Blocks.f_50094_).duration(100).EUt((long)GTValues.VA[0]).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("enchanting_table").inputItems(Blocks.f_50080_, 4).inputItems(TagPrefix.gem, GTMaterials.Diamond, 2).inputItems(Items.f_42517_).outputItems((Object)Blocks.f_50201_).duration(100).EUt((long)GTValues.VA[0]).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser").duration(100).EUt((long)GTValues.VA[1]).circuitMeta(1).inputItems(ItemTags.f_13166_, 7).inputItems(Items.f_42411_).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems((Object)Blocks.f_50061_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dropper").duration(100).EUt((long)GTValues.VA[1]).circuitMeta(2).inputItems(ItemTags.f_13166_, 7).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems((Object)Blocks.f_50286_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_nether_quartz").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13166_, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.NetherQuartz).outputItems((Object)Blocks.f_50455_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_certus_quartz").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13166_, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.CertusQuartz).outputItems((Object)Blocks.f_50455_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_quartzite").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13166_, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.Quartzite).outputItems((Object)Blocks.f_50455_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lantern").duration(100).EUt((long)GTValues.VA[1]).inputItems(Items.f_42000_).inputFluids(GTMaterials.Iron.getFluid(128)).outputItems((Object)Blocks.f_50681_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tinted_glass").duration(100).EUt((long)GTValues.VA[1]).inputItems(Items.f_151049_, 2).inputItems(Items.f_41904_).outputItems((Object)Blocks.f_152498_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cartography_table").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13168_, 4).inputItems(Items.f_42516_, 2).outputItems((Object)Blocks.f_50621_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fletching_table").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13168_, 4).inputItems(Items.f_42484_, 2).outputItems((Object)Blocks.f_50622_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smithing_table").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13168_, 4).inputFluids(GTMaterials.Iron.getFluid(288)).outputItems((Object)Blocks.f_50625_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("grindstone").duration(100).EUt((long)GTValues.VA[1]).inputItems(Tags.Items.RODS_WOODEN, 2).inputItems(Items.f_41922_).inputItems(ItemTags.f_13168_, 2).outputItems((Object)Blocks.f_50623_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("loom").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13168_, 2).inputItems(Items.f_42401_, 2).outputItems((Object)Blocks.f_50617_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smoker").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13182_, 4).inputItems(Items.f_41962_).outputItems((Object)Blocks.f_50619_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("blast_furnace").duration(100).EUt((long)GTValues.VA[1]).inputItems(Items.f_41994_, 3).inputItems(Items.f_41962_).inputFluids(GTMaterials.Iron.getFluid(720)).outputItems((Object)Blocks.f_50620_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("composter").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13175_, 7).outputItems((Object)Blocks.f_50715_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lodestone").duration(100).EUt((long)GTValues.VA[1]).inputItems(Items.f_42021_, 8).inputItems(Items.f_42418_).outputItems((Object)Blocks.f_50729_).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("scaffolding").duration(100).EUt((long)GTValues.VA[1]).inputItems(Items.f_41911_, 6).inputItems(Items.f_42401_).outputItems(Blocks.f_50616_, 6).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("beehive").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13168_, 6).inputItems(Items.f_42784_, 3).outputItems((Object)Blocks.f_50718_).circuitMeta(7).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chiseled_bookshelf").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13168_, 6).inputItems(ItemTags.f_13175_, 3).outputItems((Object)Blocks.f_244299_).circuitMeta(9).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lectern").duration(100).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_13175_, 4).inputItems(Items.f_41997_).outputItems((Object)Blocks.f_50624_).circuitMeta(10).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("respawn_anchor").duration(100).EUt((long)GTValues.VA[1]).inputItems(Items.f_42754_, 6).inputItems(Items.f_42054_, 3).outputItems((Object)Blocks.f_50724_).save();
        }
    }

    private static void vanillaBlockRecipes() {
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("mud_bricks").inputItems(Items.f_220185_, 1).outputItems(Items.f_220186_, 1).duration(200).EUt(4L).save();
    }

    private static void addBedRecipe(DyeColor color) {
        String colorName = color.m_41065_();
        VanillaRecipeHelper.addShapedRecipe((String)(colorName + "_bed"), (ItemStack)new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(colorName + "_bed")))), (Object[])new Object[]{"WWW", "PPP", "FrF", Character.valueOf('W'), RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(colorName + "_carpet"))), Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('F'), ItemTags.f_13176_});
    }

    private static void addCarpetRecipe(DyeColor color) {
        String colorName = color.m_41065_();
        VanillaRecipeHelper.addShapedRecipe((String)(colorName + "_carpet"), (ItemStack)new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(colorName + "_carpet")))), (Object[])new Object[]{"WW", Character.valueOf('W'), RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(colorName + "_wool")))});
    }

    private static void hardGlassRecipes() {
        VanillaRecipeHelper.addShapedRecipe((String)"glass_pane", (ItemStack)new ItemStack((ItemLike)Blocks.f_50185_, 2), (Object[])new Object[]{"sG", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_)});
        for (DyeColor color : DyeColor.values()) {
            String dyeName = color.m_41065_();
            VanillaRecipeHelper.addShapedRecipe((String)(dyeName + "_glass_pane"), (ItemStack)new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_stained_glass_pane"))), 2), (Object[])new Object[]{"sG", Character.valueOf('G'), RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_stained_glass")))});
        }
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("tinted_glass").inputItems((Object)Blocks.f_50058_).inputItems(Items.f_151049_, 4).outputItems(Blocks.f_152498_, 2).duration(80).EUt(6L).save();
    }

    private static void nerfPaperCrafting() {
        VanillaRecipeHelper.addShapedRecipe((String)"paper_dust", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Paper, (int)2), (Object[])new Object[]{"SSS", " m ", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_41909_)});
        VanillaRecipeHelper.addShapedRecipe((String)"sugar", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Sugar, (int)1), (Object[])new Object[]{"Sm ", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_41909_)});
        VanillaRecipeHelper.addShapedFluidContainerRecipe((String)"paper", (ItemStack)new ItemStack((ItemLike)Items.f_42516_, 2), (Object[])new Object[]{" r ", "SSS", " B ", Character.valueOf('S'), new MaterialEntry(TagPrefix.dust, GTMaterials.Paper), Character.valueOf('B'), new FluidContainerIngredient(GTMaterials.Water.getFluid(1000))});
    }

    private static void hardAdvancedIronRecipes() {
        VanillaRecipeHelper.addShapedRecipe((String)"iron_door", (ItemStack)new ItemStack((ItemLike)Items.f_42341_), (Object[])new Object[]{"PTh", "PRS", "PPd", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50183_), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Steel), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel)});
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_door").inputItems(TagPrefix.plate, GTMaterials.Iron, 4).inputItems((Object)Blocks.f_50183_).inputFluids(GTMaterials.Steel.getFluid(16)).outputItems(Items.f_42341_).duration(400).EUt((long)GTValues.VA[0]).save();
        VanillaRecipeHelper.addShapedRecipe((String)"anvil", (ItemStack)new ItemStack((ItemLike)Blocks.f_50322_), (Object[])new Object[]{"BBB", "SBS", "PBP", Character.valueOf('B'), new MaterialEntry(TagPrefix.block, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron)});
        VanillaRecipeHelper.addShapedRecipe((String)"iron_trapdoor", (ItemStack)new ItemStack((ItemLike)Blocks.f_50376_), (Object[])new Object[]{"SPS", "PTP", "sPd", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), ItemTags.f_13178_});
        VanillaRecipeHelper.addShapedRecipe((String)"minecart_iron", (ItemStack)new ItemStack((ItemLike)Items.f_42449_), (Object[])new Object[]{" h ", "PwP", "WPW", Character.valueOf('W'), GTItems.IRON_MINECART_WHEELS.m_5456_(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron)});
        VanillaRecipeHelper.addShapedRecipe((String)"minecart_steel", (ItemStack)new ItemStack((ItemLike)Items.f_42449_), (Object[])new Object[]{" h ", "PwP", "WPW", Character.valueOf('W'), GTItems.STEEL_MINECART_WHEELS.m_5456_(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel)});
    }

    private static void flintAndSteelRequireSteel() {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"flint_and_steel", (ItemStack)new ItemStack((ItemLike)Items.f_42409_), (Object[])new Object[]{"G", "F", "S", Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, GTMaterials.Steel), Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_), Character.valueOf('S'), new MaterialEntry(TagPrefix.springSmall, GTMaterials.Steel)});
    }

    private static void createShovelRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"hPf", " S ", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
    }

    private static void createPickaxeRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"PII", "hSf", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
    }

    private static void createAxeRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"PIf", "PS ", "hS ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
    }

    private static void createSwordRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{" P ", "hPf", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
    }

    private static void createHoeRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"PIf", "hS ", " S ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, GTMaterials.Wood)});
    }

    private static void createHelmetRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"PPP", "PhP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material)});
    }

    private static void createChestplateRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"PhP", "PPP", "PPP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material)});
    }

    private static void createLeggingsRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"PPP", "PhP", "P P", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material)});
    }

    private static void createBootsRecipe(String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)regName, (ItemStack)output, (Object[])new Object[]{"P P", "PhP", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material)});
    }
}

