/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.misc;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleItemFilter;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.recipe.ToolHeadReplaceRecipe;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.item.ItemMagnetBehavior;
import com.gregtechceu.gtceu.data.pack.GTDynamicDataPack;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.generated.ToolRecipeHandler;
import com.gregtechceu.gtceu.utils.ToolItemHelper;
import com.gtolib.utils.ItemUtils;
import com.tterrag.registrate.util.entry.ItemEntry;
import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public final class CustomToolRecipes {
    private static final Int2ReferenceMap<ItemEntry<? extends Item>> motorItems = new Int2ReferenceArrayMap();
    private static final Int2ReferenceMap<Material> baseMaterials = new Int2ReferenceArrayMap();
    private static final Int2ReferenceMap<List<ItemEntry<? extends Item>>> batteryItems = new Int2ReferenceArrayMap();

    private CustomToolRecipes() {
    }

    public static void init() {
        CustomToolRecipes.initializeGTItems();
        CustomToolRecipes.registerPowerUnitRecipes();
        CustomToolRecipes.registerCustomToolRecipes();
    }

    private static void initializeGTItems() {
        motorItems.put(1, (Object)GTItems.ELECTRIC_MOTOR_LV);
        motorItems.put(2, (Object)GTItems.ELECTRIC_MOTOR_MV);
        motorItems.put(3, (Object)GTItems.ELECTRIC_MOTOR_HV);
        motorItems.put(4, (Object)GTItems.ELECTRIC_MOTOR_EV);
        motorItems.put(5, (Object)GTItems.ELECTRIC_MOTOR_IV);
        baseMaterials.put(1, (Object)GTMaterials.Steel);
        baseMaterials.put(2, (Object)GTMaterials.Aluminium);
        baseMaterials.put(3, (Object)GTMaterials.StainlessSteel);
        baseMaterials.put(4, (Object)GTMaterials.Titanium);
        baseMaterials.put(5, (Object)GTMaterials.TungstenSteel);
        batteryItems.put(0, List.of(GTItems.BATTERY_ULV_TANTALUM));
        batteryItems.put(1, List.of(GTItems.BATTERY_LV_LITHIUM, GTItems.BATTERY_LV_CADMIUM, GTItems.BATTERY_LV_SODIUM));
        batteryItems.put(2, List.of(GTItems.BATTERY_MV_LITHIUM, GTItems.BATTERY_MV_CADMIUM, GTItems.BATTERY_MV_SODIUM));
        batteryItems.put(3, List.of(GTItems.BATTERY_HV_LITHIUM, GTItems.BATTERY_HV_CADMIUM, GTItems.BATTERY_HV_SODIUM, GTItems.ENERGIUM_CRYSTAL));
        batteryItems.put(4, List.of(GTItems.BATTERY_EV_VANADIUM, GTItems.LAPOTRON_CRYSTAL));
        batteryItems.put(5, List.of(GTItems.BATTERY_IV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB));
        batteryItems.put(6, List.of(GTItems.BATTERY_LuV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB_CLUSTER));
        batteryItems.put(7, List.of(GTItems.BATTERY_ZPM_NAQUADRIA, GTItems.ENERGY_MODULE));
        batteryItems.put(8, List.of(GTItems.BATTERY_UV_NAQUADRIA, GTItems.ENERGY_CLUSTER));
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadDrill, (GTToolType)GTToolType.DRILL_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadDrill, (GTToolType)GTToolType.DRILL_MV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadDrill, (GTToolType)GTToolType.DRILL_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadDrill, (GTToolType)GTToolType.DRILL_EV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadDrill, (GTToolType)GTToolType.DRILL_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadChainsaw, (GTToolType)GTToolType.CHAINSAW_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadWrench, (GTToolType)GTToolType.WRENCH_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadWrench, (GTToolType)GTToolType.WRENCH_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadWrench, (GTToolType)GTToolType.WRENCH_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadBuzzSaw, (GTToolType)GTToolType.BUZZSAW);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadScrewdriver, (GTToolType)GTToolType.SCREWDRIVER_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadWireCutter, (GTToolType)GTToolType.WIRE_CUTTER_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadWireCutter, (GTToolType)GTToolType.WIRE_CUTTER_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool((TagPrefix)TagPrefix.toolHeadWireCutter, (GTToolType)GTToolType.WIRE_CUTTER_IV);
    }

    private static void registerPowerUnitRecipes() {
        IntIterator intIterator = ToolRecipeHandler.powerUnitItems.keySet().iterator();
        while (intIterator.hasNext()) {
            int tier = (Integer)intIterator.next();
            List tieredBatteryItems = (List)batteryItems.get(tier);
            for (ItemEntry batteryItem : tieredBatteryItems) {
                if (ToolRecipeHandler.powerUnitItems.get(tier) == null) continue;
                ItemStack batteryStack = batteryItem.asStack();
                long maxCharge = GTCapabilityHelper.getElectricItem((ItemStack)batteryStack).getMaxCharge();
                ItemStack powerUnitStack = ToolItemHelper.getMaxChargeOverrideStack((Item)((Item)((ItemEntry)ToolRecipeHandler.powerUnitItems.get(tier)).get()), (long)maxCharge);
                String recipeName = String.format("%s_%s", ItemUtils.getIdLocation((Item)((Item)((ItemEntry)ToolRecipeHandler.powerUnitItems.get(tier)).get())).m_135815_(), ItemUtils.getIdLocation((Item)((Item)batteryItem.get())).m_135815_());
                VanillaRecipeHelper.addShapedEnergyTransferRecipe((boolean)true, (boolean)false, (boolean)true, (String)recipeName, (Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{batteryStack}), (ItemStack)powerUnitStack, (Object[])new Object[]{"S d", "GMG", "PBP", Character.valueOf('M'), ((ItemEntry)motorItems.get(tier)).m_5456_(), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, (Material)baseMaterials.get(tier)), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, (Material)baseMaterials.get(tier)), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, (Material)baseMaterials.get(tier)), Character.valueOf('B'), batteryStack});
            }
        }
    }

    private static void registerCustomToolRecipes() {
        CustomToolRecipes.registerFlintToolRecipes();
        CustomToolRecipes.registerMortarRecipes();
        CustomToolRecipes.registerSoftToolRecipes();
        CustomToolRecipes.registerElectricRecipes();
        SpecialRecipeBuilder.m_245676_((RecipeSerializer)ToolHeadReplaceRecipe.SERIALIZER).m_126359_(GTDynamicDataPack.CONSUMER, "gtceu:crafting/replace_tool_head");
    }

    private static void registerFlintToolRecipes() {
        MaterialEntry flint = new MaterialEntry(TagPrefix.gem, GTMaterials.Flint);
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        ToolRecipeHandler.addToolRecipe((Material)GTMaterials.Flint, (GTToolType)GTToolType.MORTAR, (boolean)false, (Object[])new Object[]{" I ", "SIS", "SSS", Character.valueOf('I'), flint, Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_)});
        ToolRecipeHandler.addToolRecipe((Material)GTMaterials.Flint, (GTToolType)GTToolType.SWORD, (boolean)false, (Object[])new Object[]{"I", "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick});
        ToolRecipeHandler.addToolRecipe((Material)GTMaterials.Flint, (GTToolType)GTToolType.PICKAXE, (boolean)false, (Object[])new Object[]{"III", " S ", " S ", Character.valueOf('I'), flint, Character.valueOf('S'), stick});
        ToolRecipeHandler.addToolRecipe((Material)GTMaterials.Flint, (GTToolType)GTToolType.SHOVEL, (boolean)false, (Object[])new Object[]{"I", "S", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick});
        ToolRecipeHandler.addToolRecipe((Material)GTMaterials.Flint, (GTToolType)GTToolType.AXE, (boolean)true, (Object[])new Object[]{"II", "IS", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick});
        ToolRecipeHandler.addToolRecipe((Material)GTMaterials.Flint, (GTToolType)GTToolType.HOE, (boolean)true, (Object[])new Object[]{"II", " S", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick});
        ToolRecipeHandler.addToolRecipe((Material)GTMaterials.Flint, (GTToolType)GTToolType.KNIFE, (boolean)false, (Object[])new Object[]{"I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick});
    }

    private static void registerMortarRecipes() {
        for (Material material : new Material[]{GTMaterials.Bronze, GTMaterials.Iron, GTMaterials.Invar, GTMaterials.Steel, GTMaterials.DamascusSteel, GTMaterials.CobaltBrass, GTMaterials.WroughtIron}) {
            ToolRecipeHandler.addToolRecipe((Material)material, (GTToolType)GTToolType.MORTAR, (boolean)false, (Object[])new Object[]{" I ", "SIS", "SSS", Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_)});
        }
    }

    private static void registerSoftToolRecipes() {
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        for (int i = 0; i < ToolRecipeHandler.softMaterials.length; ++i) {
            Material material = ToolRecipeHandler.softMaterials[i];
            if (material.hasProperty(PropertyKey.WOOD)) {
                VanillaRecipeHelper.addShapedRecipe((String)String.format("soft_mallet_%s", material.getName()), (ItemStack)ToolHelper.get((GTToolType)GTToolType.SOFT_MALLET, (Material)material), (Object[])new Object[]{"II ", "IIS", "II ", Character.valueOf('I'), ItemTags.f_13168_, Character.valueOf('S'), stick});
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe((String)String.format("soft_mallet_%s", material.getName()), (ItemStack)ToolHelper.get((GTToolType)GTToolType.SOFT_MALLET, (Material)material), (Object[])new Object[]{"II ", "IIS", "II ", Character.valueOf('I'), new MaterialEntry(TagPrefix.ingot, material), Character.valueOf('S'), stick});
            VanillaRecipeHelper.addShapedRecipe((String)String.format("plunger_%s", material.getName()), (ItemStack)ToolHelper.getAndSetToolData((GTToolType)GTToolType.PLUNGER, (Material)material, (int)(128 * (i << 1)), (int)1, (float)4.0f, (float)0.0f), (Object[])new Object[]{"xPP", " SP", "S f", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('S'), TagPrefix.rod});
        }
    }

    private static void registerElectricRecipes() {
        SimpleItemFilter filter;
        CompoundTag tag;
        ItemStack magnetStack;
        for (ItemEntry batteryItem : (List)batteryItems.get(1)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe((boolean)true, (boolean)false, (boolean)true, (String)("prospector_lv_" + batteryItem.getId().m_135815_()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), (ItemStack)GTItems.PROSPECTOR_LV.asStack(), (Object[])new Object[]{"EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LV.m_5456_(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('S'), GTItems.SENSOR_LV.m_5456_(), Character.valueOf('D'), new MaterialEntry(TagPrefix.plate, GTMaterials.Glass), Character.valueOf('C'), CustomTags.LV_CIRCUITS, Character.valueOf('B'), batteryItem.m_5456_()});
            magnetStack = GTItems.ITEM_MAGNET_LV.asStack();
            tag = magnetStack.m_41784_();
            filter = (SimpleItemFilter)ItemFilter.loadFilter((ItemStack)ItemMagnetBehavior.Filter.SIMPLE.getFilter(magnetStack));
            filter.setBlackList(true);
            tag.m_128365_("MagnetFilter", (Tag)filter.saveFilter());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe((boolean)true, (boolean)false, (boolean)true, (String)("lv_magnet_" + batteryItem.getId().m_135815_()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), (ItemStack)magnetStack, (Object[])new Object[]{"MwM", "MBM", "CPC", Character.valueOf('M'), new MaterialEntry(TagPrefix.rod, GTMaterials.SteelMagnetic), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('C'), new MaterialEntry(TagPrefix.cableGtSingle, GTMaterials.Tin), Character.valueOf('B'), batteryItem.m_5456_()});
        }
        for (ItemEntry batteryItem : (List)batteryItems.get(2)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe((boolean)true, (boolean)false, (boolean)true, (String)("portable_scanner_" + batteryItem.getId().m_135815_()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), (ItemStack)GTItems.PORTABLE_SCANNER.asStack(), (Object[])new Object[]{"EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_MV.m_5456_(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Aluminium), Character.valueOf('S'), GTItems.SENSOR_MV.m_5456_(), Character.valueOf('D'), GTItems.COVER_SCREEN.m_5456_(), Character.valueOf('C'), CustomTags.MV_CIRCUITS, Character.valueOf('B'), batteryItem.m_5456_()});
        }
        for (ItemEntry batteryItem : (List)batteryItems.get(3)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe((boolean)true, (boolean)false, (boolean)true, (String)("prospector_hv_" + batteryItem.getId().m_135815_()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), (ItemStack)GTItems.PROSPECTOR_HV.asStack(), (Object[])new Object[]{"EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_HV.m_5456_(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('S'), GTItems.SENSOR_HV.m_5456_(), Character.valueOf('D'), GTItems.COVER_SCREEN.m_5456_(), Character.valueOf('C'), CustomTags.HV_CIRCUITS, Character.valueOf('B'), batteryItem.m_5456_()});
            magnetStack = GTItems.ITEM_MAGNET_HV.asStack();
            tag = magnetStack.m_41784_();
            filter = (SimpleItemFilter)ItemFilter.loadFilter((ItemStack)ItemMagnetBehavior.Filter.SIMPLE.getFilter(magnetStack));
            filter.setBlackList(true);
            tag.m_128365_("MagnetFilter", (Tag)filter.saveFilter());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe((boolean)true, (boolean)false, (boolean)true, (String)("hv_magnet_" + batteryItem.getId().m_135815_()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), (ItemStack)magnetStack, (Object[])new Object[]{"MwM", "MBM", "CPC", Character.valueOf('M'), new MaterialEntry(TagPrefix.rod, GTMaterials.NeodymiumMagnetic), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('C'), new MaterialEntry(TagPrefix.cableGtSingle, GTMaterials.Gold), Character.valueOf('B'), batteryItem.m_5456_()});
        }
        for (ItemEntry batteryItem : (List)batteryItems.get(6)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe((boolean)true, (boolean)false, (boolean)true, (String)("prospector_luv_" + batteryItem.getId().m_135815_()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{batteryItem}), (ItemStack)GTItems.PROSPECTOR_LuV.asStack(), (Object[])new Object[]{"EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LuV.m_5456_(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.RhodiumPlatedPalladium), Character.valueOf('S'), GTItems.SENSOR_LuV.m_5456_(), Character.valueOf('D'), GTItems.COVER_SCREEN.m_5456_(), Character.valueOf('C'), CustomTags.LuV_CIRCUITS, Character.valueOf('B'), batteryItem.m_5456_()});
        }
    }
}

